/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.simple;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.resultset.simple.ResultSetProcessorSimple;
import com.espertech.esper.common.internal.epl.resultset.simple.ResultSetProcessorSimpleOutputAllHelper;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ResultSetProcessorSimpleOutputAllHelperImpl
implements ResultSetProcessorSimpleOutputAllHelper {
    private final ResultSetProcessorSimple processor;
    private final Deque<EventBean> eventsNewView = new ArrayDeque<EventBean>(2);
    private final Deque<EventBean> eventsOldView = new ArrayDeque<EventBean>(2);
    private final Deque<MultiKeyArrayOfKeys<EventBean>> eventsNewJoin = new ArrayDeque<MultiKeyArrayOfKeys<EventBean>>(2);
    private final Deque<MultiKeyArrayOfKeys<EventBean>> eventsOldJoin = new ArrayDeque<MultiKeyArrayOfKeys<EventBean>>(2);

    public ResultSetProcessorSimpleOutputAllHelperImpl(ResultSetProcessorSimple processor) {
        this.processor = processor;
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData) {
        boolean passesHaving;
        EventBean theEvent;
        int n;
        int n2;
        EventBean[] eventBeanArray;
        if (!this.processor.hasHavingClause()) {
            this.addToView(newData, oldData);
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null && newData.length > 0) {
            eventBeanArray = newData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                eventsPerStream[0] = theEvent = eventBeanArray[n];
                passesHaving = this.processor.evaluateHavingClause(eventsPerStream, true, this.processor.getAgentInstanceContext());
                if (!passesHaving) continue;
                this.eventsNewView.add(theEvent);
            }
        }
        if (oldData != null && oldData.length > 0) {
            eventBeanArray = oldData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                eventsPerStream[0] = theEvent = eventBeanArray[n];
                passesHaving = this.processor.evaluateHavingClause(eventsPerStream, false, this.processor.getAgentInstanceContext());
                if (!passesHaving) continue;
                this.eventsOldView.add(theEvent);
            }
        }
    }

    @Override
    public void processJoin(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents) {
        boolean passesHaving;
        if (!this.processor.hasHavingClause()) {
            this.addToJoin(newEvents, oldEvents);
            return;
        }
        if (newEvents != null && newEvents.size() > 0) {
            for (MultiKeyArrayOfKeys<EventBean> theEvent : newEvents) {
                passesHaving = this.processor.evaluateHavingClause(theEvent.getArray(), true, this.processor.getAgentInstanceContext());
                if (!passesHaving) continue;
                this.eventsNewJoin.add(theEvent);
            }
        }
        if (oldEvents != null && oldEvents.size() > 0) {
            for (MultiKeyArrayOfKeys<EventBean> theEvent : oldEvents) {
                passesHaving = this.processor.evaluateHavingClause(theEvent.getArray(), false, this.processor.getAgentInstanceContext());
                if (!passesHaving) continue;
                this.eventsOldJoin.add(theEvent);
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        UniformPair<EventBean[]> pair = this.processor.processViewResult(EventBeanUtility.toArrayNullIfEmpty(this.eventsNewView), EventBeanUtility.toArrayNullIfEmpty(this.eventsOldView), isSynthesize);
        this.eventsNewView.clear();
        this.eventsOldView.clear();
        return pair;
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        UniformPair<EventBean[]> pair = this.processor.processJoinResult(EventBeanUtility.toLinkedHashSetNullIfEmpty(this.eventsNewJoin), EventBeanUtility.toLinkedHashSetNullIfEmpty(this.eventsOldJoin), isSynthesize);
        this.eventsNewJoin.clear();
        this.eventsOldJoin.clear();
        return pair;
    }

    @Override
    public void destroy() {
    }

    private void addToView(EventBean[] newData, EventBean[] oldData) {
        EventBeanUtility.addToCollection(newData, this.eventsNewView);
        EventBeanUtility.addToCollection(oldData, this.eventsOldView);
    }

    private void addToJoin(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents) {
        EventBeanUtility.addToCollection(newEvents, this.eventsNewJoin);
        EventBeanUtility.addToCollection(oldEvents, this.eventsOldJoin);
    }
}

