/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.expr;

import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodePrecedenceEnum;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeVisitor;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowRecogExprNode
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RowRecogExprNode.class);
    private static final long serialVersionUID = 0L;
    private List<RowRecogExprNode> childNodes = new ArrayList<RowRecogExprNode>();

    public abstract RowRecogExprNodePrecedenceEnum getPrecedence();

    public abstract void toPrecedenceFreeEPL(StringWriter var1);

    public final void toEPL(StringWriter writer, RowRecogExprNodePrecedenceEnum parentPrecedence) {
        if (this.getPrecedence().getLevel() < parentPrecedence.getLevel()) {
            writer.write("(");
            this.toPrecedenceFreeEPL(writer);
            writer.write(")");
        } else {
            this.toPrecedenceFreeEPL(writer);
        }
    }

    public final void addChildNode(RowRecogExprNode childNode) {
        this.childNodes.add(childNode);
    }

    public final List<RowRecogExprNode> getChildNodes() {
        return this.childNodes;
    }

    public final void dumpDebug(String prefix) {
        if (log.isDebugEnabled()) {
            log.debug(".dumpDebug " + prefix + this.toString());
        }
        for (RowRecogExprNode node : this.childNodes) {
            node.dumpDebug(prefix + "  ");
        }
    }

    public void accept(RowRecogExprNodeVisitor visitor) {
        this.acceptChildnodes(visitor, null, 0);
    }

    public void acceptChildnodes(RowRecogExprNodeVisitor visitor, RowRecogExprNode parent, int level) {
        visitor.visit(this, parent, level);
        for (RowRecogExprNode childNode : this.childNodes) {
            childNode.acceptChildnodes(visitor, this, level + 1);
        }
    }

    public void replaceChildNode(RowRecogExprNode nodeToReplace, List<RowRecogExprNode> replacementNodes) {
        ArrayList<RowRecogExprNode> newChildNodes = new ArrayList<RowRecogExprNode>(this.childNodes.size() - 1 + replacementNodes.size());
        for (RowRecogExprNode node : this.childNodes) {
            if (node != nodeToReplace) {
                newChildNodes.add(node);
                continue;
            }
            newChildNodes.addAll(replacementNodes);
        }
        this.childNodes = newChildNodes;
    }
}

