/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.enummethod.dot.ArrayWrappingCollection;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.script.core.ScriptEvaluator;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.util.Arrays;
import java.util.Collection;

public abstract class ScriptEvaluatorBase
implements ScriptEvaluator {
    protected final String scriptName;
    protected final String[] parameterNames;
    protected final ExprEvaluator[] parameters;
    protected final SimpleNumberCoercer coercer;

    public ScriptEvaluatorBase(String scriptName, String[] parameterNames, ExprEvaluator[] parameters, SimpleNumberCoercer coercer) {
        this.scriptName = scriptName;
        this.parameterNames = parameterNames;
        this.parameters = parameters;
        this.coercer = coercer;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = this.evaluate(eventsPerStream, isNewData, context);
        return ScriptEvaluatorBase.scriptResultToROCollectionEvents(result);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = this.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return new ArrayWrappingCollection(result);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    private static Collection<EventBean> scriptResultToROCollectionEvents(Object result) {
        if (result == null) {
            return null;
        }
        if (result.getClass().isArray()) {
            return Arrays.asList((EventBean[])result);
        }
        return (Collection)result;
    }
}

