/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.jsr223;

import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.script.jsr223.ExpressionScriptCompiledJSR223;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223Helper {
    private static final Logger log = LoggerFactory.getLogger(JSR223Helper.class);

    public static ExpressionScriptCompiledJSR223 verifyCompileScript(String scriptName, String expression, String dialect) throws ExprValidationException {
        CompiledScript compiledScript;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine scripting = manager.getEngineByName(dialect);
        if (scripting == null) {
            throw new ExprValidationException("Failed to obtain script runtime for dialect '" + dialect + "' for script '" + scriptName + "'");
        }
        scripting.put("javax.script.filename", scriptName);
        Compilable compilingEngine = (Compilable)((Object)scripting);
        try {
            compiledScript = compilingEngine.compile(expression);
        }
        catch (ScriptException ex) {
            String message = "Exception compiling script '" + scriptName + "' of dialect '" + dialect + "': " + JSR223Helper.getScriptCompileMsg(ex);
            log.info(message, (Throwable)ex);
            throw new ExprValidationException(message, ex);
        }
        return new ExpressionScriptCompiledJSR223(compiledScript);
    }

    public static String getScriptCompileMsg(ScriptException ex) {
        if (ex.getLineNumber() != 1 && ex.getColumnNumber() != -1) {
            return "At line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + ": " + ex.getMessage();
        }
        return ex.getMessage();
    }
}

