/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.jsr223;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.script.core.ScriptEvaluatorBase;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatorJSR223
extends ScriptEvaluatorBase {
    private static final Logger log = LoggerFactory.getLogger(ScriptEvaluatorJSR223.class);
    private final CompiledScript executable;

    public ScriptEvaluatorJSR223(String scriptName, String[] parameterNames, ExprEvaluator[] parameters, SimpleNumberCoercer coercer, CompiledScript executable) {
        super(scriptName, parameterNames, parameters, coercer);
        this.executable = executable;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Bindings bindings = this.getBindings(context);
        for (int i = 0; i < this.parameterNames.length; ++i) {
            bindings.put(this.parameterNames[i], this.parameters[i].evaluate(eventsPerStream, isNewData, context));
        }
        return this.evaluateInternal(bindings, context);
    }

    @Override
    public Object evaluate(Object lookupValues, ExprEvaluatorContext context) {
        Bindings bindings = this.getBindings(context);
        if (this.parameterNames.length == 1) {
            bindings.put(this.parameterNames[0], lookupValues);
        } else if (this.parameterNames.length > 1) {
            Object[] mk = (Object[])lookupValues;
            for (int i = 0; i < this.parameterNames.length; ++i) {
                bindings.put(this.parameterNames[i], mk[i]);
            }
        }
        return this.evaluateInternal(bindings, context);
    }

    private Bindings getBindings(ExprEvaluatorContext context) {
        Bindings bindings = this.executable.getEngine().createBindings();
        bindings.put("epl", (Object)context.getAllocateAgentInstanceScriptContext());
        return bindings;
    }

    private Object evaluateInternal(Bindings bindings, ExprEvaluatorContext context) {
        try {
            Object result = this.executable.eval(bindings);
            if (this.coercer != null && result != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (ScriptException e) {
            String message = "Unexpected exception executing script '" + this.scriptName + "' for statement '" + context.getStatementName() + "' : " + e.getMessage();
            log.error(message, (Throwable)e);
            throw new EPException(message, e);
        }
    }
}

