/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadTreeCollector;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import java.util.Collection;

public class MXCIFQuadTreeFilterIndexCollect {
    public static <L, T> void collectRange(MXCIFQuadTree<Object> quadTree, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector) {
        MXCIFQuadTreeFilterIndexCollect.collectRange(quadTree.getRoot(), x, y, width, height, eventBean, target, collector);
    }

    private static <L, T> void collectRange(MXCIFQuadTreeNode<Object> node, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            MXCIFQuadTreeFilterIndexCollect.collectNode(leaf, x, y, width, height, eventBean, target, collector);
            return;
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        MXCIFQuadTreeFilterIndexCollect.collectNode(branch, x, y, width, height, eventBean, target, collector);
        MXCIFQuadTreeFilterIndexCollect.collectRange(branch.getNw(), x, y, width, height, eventBean, target, collector);
        MXCIFQuadTreeFilterIndexCollect.collectRange(branch.getNe(), x, y, width, height, eventBean, target, collector);
        MXCIFQuadTreeFilterIndexCollect.collectRange(branch.getSw(), x, y, width, height, eventBean, target, collector);
        MXCIFQuadTreeFilterIndexCollect.collectRange(branch.getSe(), x, y, width, height, eventBean, target, collector);
    }

    private static <L, T> void collectNode(MXCIFQuadTreeNode node, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector) {
        Object rectangles = node.getData();
        if (rectangles == null) {
            return;
        }
        if (rectangles instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue rectangle = (XYWHRectangleWValue)rectangles;
            if (BoundingBox.intersectsBoxIncludingEnd(x, y, x + width, y + height, rectangle.getX(), rectangle.getY(), rectangle.getW(), rectangle.getH())) {
                collector.collectInto(eventBean, rectangle.getValue(), target);
            }
            return;
        }
        Collection collection = (Collection)rectangles;
        for (XYWHRectangleWValue rectangle : collection) {
            if (!BoundingBox.intersectsBoxIncludingEnd(x, y, x + width, y + height, rectangle.getX(), rectangle.getY(), rectangle.getW(), rectangle.getH())) continue;
            collector.collectInto(eventBean, rectangle.getValue(), target);
        }
    }
}

