/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.mxcifrowindex.XYWHRectangleMultiType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class MXCIFQuadTreeRowIndexRemove {
    public static void remove(double x, double y, double width, double height, Object value, MXCIFQuadTree<Object> tree) {
        MXCIFQuadTreeNode<Object> root = tree.getRoot();
        MXCIFQuadTreeNode<Object> replacement = MXCIFQuadTreeRowIndexRemove.removeFromNode(x, y, width, height, value, root, tree);
        tree.setRoot(replacement);
    }

    private static MXCIFQuadTreeNode<Object> removeFromNode(double x, double y, double width, double height, Object value, MXCIFQuadTreeNode<Object> node, MXCIFQuadTree<Object> tree) {
        boolean removed;
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            boolean removed2 = MXCIFQuadTreeRowIndexRemove.removeFromPoints(x, y, width, height, value, leaf.getData());
            if (removed2) {
                leaf.decCount();
                if (leaf.getCount() == 0) {
                    leaf.setData(null);
                }
            }
            return leaf;
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        QuadrantAppliesEnum quadrant = node.getBb().getQuadrantApplies(x, y, width, height);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeRowIndexRemove.removeFromNode(x, y, width, height, value, branch.getNw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeRowIndexRemove.removeFromNode(x, y, width, height, value, branch.getNe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeRowIndexRemove.removeFromNode(x, y, width, height, value, branch.getSw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeRowIndexRemove.removeFromNode(x, y, width, height, value, branch.getSe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SOME && (removed = MXCIFQuadTreeRowIndexRemove.removeFromPoints(x, y, width, height, value, branch.getData()))) {
            branch.decCount();
            if (branch.getCount() == 0) {
                branch.setData(null);
            }
        }
        if (!(branch.getNw() instanceof MXCIFQuadTreeNodeLeaf && branch.getNe() instanceof MXCIFQuadTreeNodeLeaf && branch.getSw() instanceof MXCIFQuadTreeNodeLeaf && branch.getSe() instanceof MXCIFQuadTreeNodeLeaf)) {
            return branch;
        }
        MXCIFQuadTreeNodeLeaf nwLeaf = (MXCIFQuadTreeNodeLeaf)branch.getNw();
        MXCIFQuadTreeNodeLeaf neLeaf = (MXCIFQuadTreeNodeLeaf)branch.getNe();
        MXCIFQuadTreeNodeLeaf swLeaf = (MXCIFQuadTreeNodeLeaf)branch.getSw();
        MXCIFQuadTreeNodeLeaf seLeaf = (MXCIFQuadTreeNodeLeaf)branch.getSe();
        int total = branch.getCount() + nwLeaf.getCount() + neLeaf.getCount() + swLeaf.getCount() + seLeaf.getCount();
        if (total >= tree.getLeafCapacity()) {
            return branch;
        }
        LinkedList<XYWHRectangleMultiType> collection = new LinkedList<XYWHRectangleMultiType>();
        int count = MXCIFQuadTreeRowIndexRemove.mergeChildNodes(collection, branch.getData());
        count += MXCIFQuadTreeRowIndexRemove.mergeChildNodes(collection, nwLeaf.getData());
        count += MXCIFQuadTreeRowIndexRemove.mergeChildNodes(collection, neLeaf.getData());
        count += MXCIFQuadTreeRowIndexRemove.mergeChildNodes(collection, swLeaf.getData());
        return new MXCIFQuadTreeNodeLeaf<Object>(branch.getBb(), branch.getLevel(), collection, count += MXCIFQuadTreeRowIndexRemove.mergeChildNodes(collection, seLeaf.getData()));
    }

    private static boolean removeFromPoints(double x, double y, double width, double height, Object value, Object data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof Collection)) {
            boolean removed;
            XYWHRectangleMultiType rectangle = (XYWHRectangleMultiType)data;
            return rectangle.coordinateEquals(x, y, width, height) && (removed = rectangle.remove(value));
        }
        Collection collection = (Collection)data;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            boolean removed;
            XYWHRectangleMultiType rectangle = (XYWHRectangleMultiType)it.next();
            if (!rectangle.coordinateEquals(x, y, width, height) || !(removed = rectangle.remove(value))) continue;
            if (rectangle.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    private static int mergeChildNodes(Collection<XYWHRectangleMultiType> target, Object data) {
        if (data == null) {
            return 0;
        }
        if (data instanceof XYWHRectangleMultiType) {
            XYWHRectangleMultiType r = (XYWHRectangleMultiType)data;
            target.add(r);
            return r.count();
        }
        Collection coll = (Collection)data;
        int total = 0;
        for (XYWHRectangleMultiType r : coll) {
            target.add(r);
            total += r.count();
        }
        return total;
    }
}

