/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.subselect;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorFilterForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorNamedWindowForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorSubselectNoneForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorTableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeArgs;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeDesc;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class SubSelectHelperActivations {
    public static SubSelectActivationDesc createSubSelectActivation(List<FilterSpecCompiled> filterSpecCompileds, List<NamedWindowConsumerStreamSpec> namedWindowConsumers, StatementBaseInfo statement, StatementCompileTimeServices services) throws ExprValidationException {
        LinkedHashMap<ExprSubselectNode, SubSelectActivationPlan> result = new LinkedHashMap<ExprSubselectNode, SubSelectActivationPlan>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>();
        for (ExprSubselectNode subselect : statement.getStatementSpec().getSubselectNodes()) {
            boolean processorDisableIndexShare;
            StatementSpecCompiled statementSpec = subselect.getStatementSpecCompiled();
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
            int subqueryNumber = subselect.getSubselectNumber();
            if (subqueryNumber == -1) {
                throw new IllegalStateException("Unexpected subquery");
            }
            ViewFactoryForgeArgs args = new ViewFactoryForgeArgs(-1, true, subqueryNumber, streamSpec.getOptions(), null, statement.getStatementRawInfo(), services);
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)statementSpec.getStreamSpecs()[0];
                ViewableActivatorFilterForge activatorDeactivator = new ViewableActivatorFilterForge(filterStreamSpec.getFilterSpecCompiled(), false, null, true, subqueryNumber);
                ViewFactoryForgeDesc viewForgeDesc = ViewFactoryForgeUtil.createForges(streamSpec.getViewSpecs(), args, filterStreamSpec.getFilterSpecCompiled().getResultEventType());
                List<ViewFactoryForge> forges = viewForgeDesc.getForges();
                additionalForgeables.addAll(viewForgeDesc.getMultikeyForges());
                EventType eventType = forges.isEmpty() ? filterStreamSpec.getFilterSpecCompiled().getResultEventType() : forges.get(forges.size() - 1).getEventType();
                subselect.setRawEventType(eventType);
                filterSpecCompileds.add(filterStreamSpec.getFilterSpecCompiled());
                result.put(subselect, new SubSelectActivationPlan(filterStreamSpec.getFilterSpecCompiled().getResultEventType(), forges, activatorDeactivator, streamSpec));
                continue;
            }
            if (streamSpec instanceof TableQueryStreamSpec) {
                TableQueryStreamSpec table = (TableQueryStreamSpec)streamSpec;
                ExprNode filter = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(table.getFilterExpressions());
                ViewableActivatorTableForge viewableActivator = new ViewableActivatorTableForge(table.getTable(), filter);
                result.put(subselect, new SubSelectActivationPlan(table.getTable().getInternalEventType(), Collections.emptyList(), viewableActivator, streamSpec));
                subselect.setRawEventType(table.getTable().getInternalEventType());
                continue;
            }
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)statementSpec.getStreamSpecs()[0];
            namedWindowConsumers.add(namedSpec);
            NamedWindowMetaData nwinfo = namedSpec.getNamedWindow();
            EventType namedWindowType = nwinfo.getEventType();
            if (namedSpec.getOptPropertyEvaluator() != null) {
                namedWindowType = namedSpec.getOptPropertyEvaluator().getFragmentEventType();
            }
            boolean disableIndexShare = HintEnum.DISABLE_WINDOW_SUBQUERY_INDEXSHARE.getHint(statement.getStatementRawInfo().getAnnotations()) != null;
            boolean bl = processorDisableIndexShare = !namedSpec.getNamedWindow().isEnableIndexShare();
            if (disableIndexShare && namedSpec.getNamedWindow().isVirtualDataWindow()) {
                disableIndexShare = false;
            }
            if (!namedSpec.getFilterExpressions().isEmpty() || processorDisableIndexShare || disableIndexShare) {
                ViewableActivatorNamedWindowForge activatorNamedWindow = new ViewableActivatorNamedWindowForge(namedSpec, nwinfo, null, null, true, namedSpec.getOptPropertyEvaluator());
                ViewFactoryForgeDesc viewForgeDesc = ViewFactoryForgeUtil.createForges(streamSpec.getViewSpecs(), args, namedWindowType);
                List<ViewFactoryForge> forges = viewForgeDesc.getForges();
                additionalForgeables.addAll(viewForgeDesc.getMultikeyForges());
                subselect.setRawEventType(forges.isEmpty() ? namedWindowType : forges.get(forges.size() - 1).getEventType());
                result.put(subselect, new SubSelectActivationPlan(namedWindowType, forges, activatorNamedWindow, streamSpec));
                continue;
            }
            ViewFactoryForgeDesc viewForgeDesc = ViewFactoryForgeUtil.createForges(streamSpec.getViewSpecs(), args, namedWindowType);
            List<ViewFactoryForge> forges = viewForgeDesc.getForges();
            additionalForgeables.addAll(viewForgeDesc.getMultikeyForges());
            subselect.setRawEventType(namedWindowType);
            ViewableActivatorSubselectNoneForge activatorNamedWindow = new ViewableActivatorSubselectNoneForge(namedWindowType);
            result.put(subselect, new SubSelectActivationPlan(namedWindowType, forges, activatorNamedWindow, streamSpec));
        }
        return new SubSelectActivationDesc(result, additionalForgeables);
    }
}

