/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.subselect;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameSubqueryAgg;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefWSerde;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseExpressions;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultCompileTime;
import com.espertech.esper.common.internal.context.util.ContextPropertyRegistry;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceForgeDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeGroupKey;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamSet;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityAggregation;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationMemberNameQualifiedSubquery;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredNoTraverseVisitor;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.composite.PropertyCompositeEventTableFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.inkeyword.PropertyHashedArrayFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.sorted.PropertySortedFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.index.unindexed.UnindexedEventTableFactoryFactoryForge;
import com.espertech.esper.common.internal.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.common.internal.epl.join.hint.IndexHint;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.IndexNameAndDescPair;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.QueryPlanIndexBuilder;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexDescSubquery;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexHook;
import com.espertech.esper.common.internal.epl.join.support.QueryPlanIndexHookUtil;
import com.espertech.esper.common.internal.epl.lookup.SubordFullTableScanLookupStrategyFactoryForge;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyFactoryForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropPlan;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropUtil;
import com.espertech.esper.common.internal.epl.lookupplan.SubordinateTableLookupStrategyUtil;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForgeDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectStrategyFactoryIndexShareForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectStrategyFactoryLocalViewPreloadedForge;
import com.espertech.esper.common.internal.epl.subselect.SubqueryIndexForgeDesc;
import com.espertech.esper.common.internal.epl.subselect.SubselectUtil;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.epl.util.ViewResourceVerifyHelper;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import com.espertech.esper.common.internal.view.prior.PriorEventViewForge;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSelectHelperForgePlanner {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final String MSG_SUBQUERY_REQUIRES_WINDOW = "Subqueries require one or more views to limit the stream, consider declaring a length or time window (applies to correlated or non-fully-aggregated subqueries)";

    public static SubSelectHelperForgePlan planSubSelect(StatementBaseInfo statement, Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation, String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNamees, StatementCompileTimeServices compileTimeServices) throws ExprValidationException, ViewProcessingException {
        ExprDeclaredNode[] declaredExpressions = statement.getStatementSpec().getDeclaredExpressions();
        LinkedHashMap<ExprSubselectNode, SubSelectFactoryForge> subselectForges = new LinkedHashMap<ExprSubselectNode, SubSelectFactoryForge>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy = null;
        if (declaredExpressions.length > 0) {
            declaredExpressionCallHierarchy = ExprNodeUtilityQuery.getDeclaredExpressionCallHierarchy(declaredExpressions);
        }
        for (Map.Entry<ExprSubselectNode, SubSelectActivationPlan> entry : subselectActivation.entrySet()) {
            ExprSubselectNode subselect = entry.getKey();
            SubSelectActivationPlan subSelectActivation = entry.getValue();
            try {
                SubSelectFactoryForgeDesc forgeDesc = SubSelectHelperForgePlanner.planSubSelectInternal(subselect, subSelectActivation, outerStreamNames, outerEventTypesSelect, outerEventTypeNamees, declaredExpressions, statement.getContextPropertyRegistry(), declaredExpressionCallHierarchy, statement, compileTimeServices);
                subselectForges.put(entry.getKey(), forgeDesc.getSubSelectFactoryForge());
                additionalForgeables.addAll(forgeDesc.getAdditionalForgeables());
            }
            catch (Exception ex) {
                throw new ExprValidationException("Failed to plan " + ExprNodeUtilityMake.getSubqueryInfoText(subselect) + ": " + ex.getMessage(), ex);
            }
        }
        return new SubSelectHelperForgePlan(subselectForges, additionalForgeables);
    }

    private static SubSelectFactoryForgeDesc planSubSelectInternal(ExprSubselectNode subselect, SubSelectActivationPlan subselectActivation, String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNamees, ExprDeclaredNode[] declaredExpressions, ContextPropertyRegistry contextPropertyRegistry, Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy, StatementBaseInfo statement, StatementCompileTimeServices services) throws ExprValidationException {
        NamedWindowConsumerStreamSpec namedSpec;
        ViewResourceDelegateDesc viewResourceDelegateDesc;
        ExprNodePropOrStreamSet nonAggregatedPropsSelect;
        boolean hasNonAggregatedProperties;
        boolean queryPlanLogging = services.getConfiguration().getCommon().getLogging().isEnableQueryPlan();
        if (queryPlanLogging && QUERY_PLAN_LOG.isInfoEnabled()) {
            QUERY_PLAN_LOG.info("For statement '" + statement.getStatementNumber() + "' subquery " + subselect.getSubselectNumber());
        }
        Annotation[] annotations = statement.getStatementSpec().getAnnotations();
        IndexHint indexHint = IndexHint.getIndexHint(annotations);
        StatementSpecCompiled subselectSpec = subselect.getStatementSpecCompiled();
        StreamSpecCompiled filterStreamSpec = subselectSpec.getStreamSpecs()[0];
        int subqueryNum = subselect.getSubselectNumber();
        String subselecteventTypeName = null;
        if (filterStreamSpec instanceof FilterStreamSpecCompiled) {
            subselecteventTypeName = ((FilterStreamSpecCompiled)filterStreamSpec).getFilterSpecCompiled().getFilterForEventTypeName();
        } else if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
            subselecteventTypeName = ((NamedWindowConsumerStreamSpec)filterStreamSpec).getNamedWindow().getEventType().getName();
        } else if (filterStreamSpec instanceof TableQueryStreamSpec) {
            subselecteventTypeName = ((TableQueryStreamSpec)filterStreamSpec).getTable().getTableName();
        }
        List<ViewFactoryForge> viewForges = subselectActivation.getViewForges();
        EventType eventType = viewForges.isEmpty() ? subselectActivation.getViewableType() : viewForges.get(viewForges.size() - 1).getEventType();
        String subexpressionStreamName = SubselectUtil.getStreamName(filterStreamSpec.getOptionalStreamName(), subselect.getSubselectNumber());
        String[] allStreamNames = new String[outerStreamNames.length + 1];
        System.arraycopy(outerStreamNames, 0, allStreamNames, 1, outerStreamNames.length);
        allStreamNames[0] = subexpressionStreamName;
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec || filterStreamSpec instanceof TableQueryStreamSpec) {
            EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(viewForges);
        }
        StreamTypeService subselectTypeService = null;
        EventType[] outerEventTypes = null;
        if (declaredExpressions != null && declaredExpressions.length > 0 && (subselectTypeService = SubSelectHelperForgePlanner.getDeclaredExprTypeService(declaredExpressions, declaredExpressionCallHierarchy, outerStreamNames, outerEventTypesSelect, subselect, subexpressionStreamName, eventType)) != null) {
            outerEventTypes = new EventType[subselectTypeService.getEventTypes().length - 1];
            System.arraycopy(subselectTypeService.getEventTypes(), 1, outerEventTypes, 0, subselectTypeService.getEventTypes().length - 1);
        }
        if (subselectTypeService == null) {
            if (subselect.getFilterSubqueryStreamTypes() != null) {
                subselectTypeService = subselect.getFilterSubqueryStreamTypes();
                outerEventTypes = new EventType[subselectTypeService.getEventTypes().length - 1];
                System.arraycopy(subselectTypeService.getEventTypes(), 1, outerEventTypes, 0, subselectTypeService.getEventTypes().length - 1);
            } else {
                LinkedHashMap<String, Pair<EventType, String>> namesAndTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                namesAndTypes.put(subexpressionStreamName, new Pair<EventType, String>(eventType, subselecteventTypeName));
                for (int i = 0; i < outerEventTypesSelect.length; ++i) {
                    Pair<EventType, String> pair = new Pair<EventType, String>(outerEventTypesSelect[i], outerEventTypeNamees[i]);
                    namesAndTypes.put(outerStreamNames[i], pair);
                }
                subselectTypeService = new StreamTypeServiceImpl(namesAndTypes, true, true);
                outerEventTypes = outerEventTypesSelect;
            }
        }
        ViewResourceDelegateExpr viewResourceDelegateSubselect = new ViewResourceDelegateExpr();
        SelectClauseSpecCompiled selectClauseSpec = subselect.getStatementSpecCompiled().getSelectClauseCompiled();
        ArrayList<ExprNode> selectExpressions = new ArrayList<ExprNode>();
        ArrayList<String> assignedNames = new ArrayList<String>();
        boolean isWildcard = false;
        boolean isStreamWildcard = false;
        ExprValidationContext validationContext = new ExprValidationContextBuilder(subselectTypeService, statement.getStatementRawInfo(), services).withViewResourceDelegate(viewResourceDelegateSubselect).withAllowBindingConsumption(true).withMemberName(new ExprValidationMemberNameQualifiedSubquery(subqueryNum)).build();
        ArrayList<ExprAggregateNode> aggExprNodesSelect = new ArrayList<ExprAggregateNode>(2);
        for (int i = 0; i < selectClauseSpec.getSelectExprList().length; ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[i];
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec compiled = (SelectClauseExprCompiledSpec)element;
                Object selectExpression = compiled.getSelectExpression();
                selectExpression = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SELECT, (ExprNode)selectExpression, validationContext);
                selectExpressions.add((ExprNode)selectExpression);
                if (compiled.getAssignedName() == null) {
                    assignedNames.add(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe((ExprNode)selectExpression));
                } else {
                    assignedNames.add(compiled.getAssignedName());
                }
                ExprAggregateNodeUtil.getAggregatesBottomUp((ExprNode)selectExpression, aggExprNodesSelect);
                if (aggExprNodesSelect.size() <= 0) continue;
                List<Pair<Integer, String>> propertiesNotAggregated = ExprNodeUtilityQuery.getExpressionProperties((ExprNode)selectExpression, false);
                for (Pair<Integer, String> pair : propertiesNotAggregated) {
                    if (pair.getFirst() != 0) continue;
                    throw new ExprValidationException("Subselect properties must all be within aggregation functions");
                }
                continue;
            }
            if (element instanceof SelectClauseElementWildcard) {
                isWildcard = true;
                continue;
            }
            if (!(element instanceof SelectClauseStreamCompiledSpec)) continue;
            isStreamWildcard = true;
        }
        List<ExprAggregateNode> aggExpressionNodesHaving = Collections.emptyList();
        if (subselectSpec.getRaw().getHavingClause() != null) {
            ExprNode validatedHavingClause = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.HAVING, subselectSpec.getRaw().getHavingClause(), validationContext);
            if (JavaClassHelper.getBoxedType(validatedHavingClause.getForge().getEvaluationType()) != Boolean.class) {
                throw new ExprValidationException("Subselect having-clause expression must return a boolean value");
            }
            aggExpressionNodesHaving = new ArrayList();
            ExprAggregateNodeUtil.getAggregatesBottomUp(validatedHavingClause, aggExpressionNodesHaving);
            SubSelectHelperForgePlanner.validateAggregationPropsAndLocalGroup(aggExpressionNodesHaving);
            if (aggExpressionNodesHaving.isEmpty()) {
                ExprNode filter = subselectSpec.getRaw().getWhereClause();
                if (filter == null) {
                    subselectSpec.getRaw().setWhereClause(subselectSpec.getRaw().getHavingClause());
                } else {
                    subselectSpec.getRaw().setWhereClause(ExprNodeUtilityMake.connectExpressionsByLogicalAnd(Arrays.asList(subselectSpec.getRaw().getWhereClause(), subselectSpec.getRaw().getHavingClause())));
                }
                subselectSpec.getRaw().setHavingClause(null);
            } else {
                subselect.setHavingExpr(validatedHavingClause.getForge());
                ExprNodePropOrStreamSet nonAggregatedPropsHaving = ExprNodeUtilityAggregation.getNonAggregatedProps(validationContext.getStreamTypeService().getEventTypes(), Collections.singletonList(validatedHavingClause), contextPropertyRegistry);
                for (ExprNodePropOrStreamPropDesc prop : nonAggregatedPropsHaving.getProperties()) {
                    if (prop.getStreamNum() != 0) continue;
                    throw new ExprValidationException("Subselect having-clause requires that all properties are under aggregation, consider using the 'first' aggregation function instead");
                }
            }
        }
        boolean bl = hasNonAggregatedProperties = !(nonAggregatedPropsSelect = ExprNodeUtilityAggregation.getNonAggregatedProps(validationContext.getStreamTypeService().getEventTypes(), selectExpressions, contextPropertyRegistry)).isEmpty();
        if (!selectExpressions.isEmpty()) {
            if (isWildcard || isStreamWildcard) {
                throw new ExprValidationException("Subquery multi-column select does not allow wildcard or stream wildcard when selecting multiple columns.");
            }
            if (selectExpressions.size() > 1 && !subselect.isAllowMultiColumnSelect()) {
                throw new ExprValidationException("Subquery multi-column select is not allowed in this context.");
            }
            if (subselectSpec.getGroupByExpressions() == null && selectExpressions.size() > 1 && aggExprNodesSelect.size() > 0 && hasNonAggregatedProperties) {
                throw new ExprValidationException("Subquery with multi-column select requires that either all or none of the selected columns are under aggregation, unless a group-by clause is also specified");
            }
            subselect.setSelectClause(selectExpressions.toArray(new ExprNode[selectExpressions.size()]));
            subselect.setSelectAsNames(assignedNames.toArray(new String[assignedNames.size()]));
        }
        ExprNodePropOrStreamSet propertiesGroupBy = null;
        AggregationServiceForgeDesc aggregationServiceForgeDesc = null;
        ExprNode[] groupByNodes = null;
        MultiKeyPlan groupByMultikeyPlan = null;
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        if (aggExprNodesSelect.size() > 0 || aggExpressionNodesHaving.size() > 0) {
            boolean hasGroupBy;
            GroupByClauseExpressions groupBy = subselectSpec.getGroupByExpressions();
            if (groupBy != null && groupBy.getGroupByRollupLevels() != null) {
                throw new ExprValidationException("Group-by expressions in a subselect may not have rollups");
            }
            groupByNodes = groupBy == null ? null : groupBy.getGroupByNodes();
            boolean bl2 = hasGroupBy = groupByNodes != null && groupByNodes.length > 0;
            if (hasGroupBy) {
                boolean allInGroupBy;
                for (int i = 0; i < groupByNodes.length; ++i) {
                    groupByNodes[i] = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.GROUPBY, groupByNodes[i], validationContext);
                    String minimal = ExprNodeUtilityValidate.isMinimalExpression(groupByNodes[i]);
                    if (minimal == null) continue;
                    throw new ExprValidationException("Group-by expressions in a subselect may not have " + minimal);
                }
                propertiesGroupBy = ExprNodeUtilityAggregation.getGroupByPropertiesValidateHasOne(groupByNodes);
                ExprNodePropOrStreamDesc firstNonZeroGroupBy = propertiesGroupBy.getFirstWithStreamNumNotZero();
                if (firstNonZeroGroupBy != null) {
                    throw new ExprValidationException("Subselect with group-by requires that group-by properties are provided by the subselect stream only (" + firstNonZeroGroupBy.getTextual() + " is not)");
                }
                String reasonMessage = propertiesGroupBy.notContainsAll(nonAggregatedPropsSelect);
                boolean bl3 = allInGroupBy = reasonMessage == null;
                if (!allInGroupBy) {
                    throw new ExprValidationException("Subselect with group-by requires non-aggregated properties in the select-clause to also appear in the group-by clause");
                }
                groupByMultikeyPlan = MultiKeyPlanner.planMultiKey(groupByNodes, false, statement.getStatementRawInfo(), services.getSerdeResolver());
                additionalForgeables.addAll(groupByMultikeyPlan.getMultiKeyForgeables());
            }
            SubSelectHelperForgePlanner.validateAggregationPropsAndLocalGroup(aggExprNodesSelect);
            ArrayList<ExprAggregateNodeGroupKey> groupKeyExpressions = null;
            ExprNode[] groupByExpressions = ExprNodeUtilityQuery.EMPTY_EXPR_ARRAY;
            if (hasGroupBy) {
                groupByExpressions = subselectSpec.getGroupByExpressions().getGroupByNodes();
                for (int i = 0; i < selectExpressions.size(); ++i) {
                    ExprNode selectExpression = (ExprNode)selectExpressions.get(i);
                    boolean revalidate = false;
                    for (int j = 0; j < groupByExpressions.length; ++j) {
                        List<Pair<ExprNode, ExprNode>> foundPairs = ExprNodeUtilityQuery.findExpression(selectExpression, groupByExpressions[j]);
                        for (Pair<ExprNode, ExprNode> pair : foundPairs) {
                            CodegenFieldNameSubqueryAgg aggName = new CodegenFieldNameSubqueryAgg(subqueryNum);
                            ExprAggregateNodeGroupKey replacement = new ExprAggregateNodeGroupKey(groupByExpressions.length, j, groupByExpressions[j].getForge().getEvaluationType(), aggName);
                            if (pair.getFirst() == null) {
                                selectExpressions.set(i, replacement);
                            } else {
                                ExprNodeUtilityModify.replaceChildNode(pair.getFirst(), pair.getSecond(), replacement);
                                revalidate = true;
                            }
                            if (groupKeyExpressions == null) {
                                groupKeyExpressions = new ArrayList<ExprAggregateNodeGroupKey>();
                            }
                            groupKeyExpressions.add(replacement);
                        }
                    }
                    if (!revalidate) continue;
                    selectExpression = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.SELECT, selectExpression, validationContext);
                    selectExpressions.set(i, selectExpression);
                }
            }
            aggregationServiceForgeDesc = AggregationServiceFactoryFactory.getService(aggExprNodesSelect, Collections.emptyMap(), Collections.emptyList(), groupByExpressions, groupByMultikeyPlan == null ? null : groupByMultikeyPlan.getClassRef(), aggExpressionNodesHaving, Collections.emptyList(), groupKeyExpressions, hasGroupBy, annotations, services.getVariableCompileTimeResolver(), true, subselectSpec.getRaw().getWhereClause(), subselectSpec.getRaw().getHavingClause(), subselectTypeService.getEventTypes(), null, subselectSpec.getRaw().getOptionalContextName(), null, null, false, false, false, services.getClasspathImportServiceCompileTime(), statement.getStatementRawInfo(), services.getSerdeResolver());
            additionalForgeables.addAll(aggregationServiceForgeDesc.getAdditionalForgeables());
            if (!selectExpressions.isEmpty()) {
                subselect.setSelectClause(selectExpressions.toArray(new ExprNode[selectExpressions.size()]));
                subselect.setSelectAsNames(assignedNames.toArray(new String[assignedNames.size()]));
            }
        }
        if (subselectSpec.getRaw().getWhereClause() != null) {
            LinkedList<ExprAggregateNode> aggExprNodesFilter = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(subselectSpec.getRaw().getWhereClause(), aggExprNodesFilter);
            if (aggExprNodesFilter.size() > 0) {
                throw new ExprValidationException("Aggregation functions are not supported within subquery filters, consider using a having-clause or insert-into instead");
            }
        }
        ExprNode filterExpr = subselectSpec.getRaw().getWhereClause();
        if (filterStreamSpec instanceof TableQueryStreamSpec) {
            TableQueryStreamSpec table = (TableQueryStreamSpec)filterStreamSpec;
            filterExpr = ExprNodeUtilityMake.connectExpressionsByLogicalAnd(table.getFilterExpressions(), filterExpr);
        }
        boolean correlatedSubquery = false;
        if (filterExpr != null) {
            if (JavaClassHelper.getBoxedType((filterExpr = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.FILTER, filterExpr, validationContext)).getForge().getEvaluationType()) != Boolean.class) {
                throw new ExprValidationException("Subselect filter expression must return a boolean value");
            }
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            filterExpr.accept(visitor);
            List<Pair<Integer, String>> propertiesNodes = visitor.getExprProperties();
            for (Pair<Integer, String> pair : propertiesNodes) {
                if (pair.getFirst() == 0) continue;
                correlatedSubquery = true;
                break;
            }
        }
        if (ViewResourceDelegateDesc.hasPrior(new ViewResourceDelegateDesc[]{viewResourceDelegateDesc = ViewResourceVerifyHelper.verifyPreviousAndPriorRequirements(new List[]{viewForges}, viewResourceDelegateSubselect)[0]}) && !viewResourceDelegateDesc.getPriorRequests().isEmpty()) {
            viewForges.add(new PriorEventViewForge(viewForges.isEmpty(), viewForges.isEmpty() ? eventType : viewForges.get(viewForges.size() - 1).getEventType()));
        }
        if (aggregationServiceForgeDesc == null) {
            subselect.setSubselectAggregationType(ExprSubselectNode.SubqueryAggregationType.NONE);
        } else {
            subselect.setSubselectAggregationType(hasNonAggregatedProperties ? ExprSubselectNode.SubqueryAggregationType.FULLY_AGGREGATED_WPROPS : ExprSubselectNode.SubqueryAggregationType.FULLY_AGGREGATED_NOPROPS);
        }
        ExprForge filterExprEval = filterExpr == null ? null : filterExpr.getForge();
        ExprForge assignedFilterExpr = aggregationServiceForgeDesc != null ? null : filterExprEval;
        subselect.setFilterExpr(assignedFilterExpr);
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec && correlatedSubquery && (namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec).getOptPropertyEvaluator() != null) {
            throw new ExprValidationException("Failed to validate named window use in subquery, contained-event is only allowed for named windows when not correlated");
        }
        SubSelectHelperForgePlanner.validateSubqueryDataWindow(subselect, correlatedSubquery, hasNonAggregatedProperties, propertiesGroupBy, nonAggregatedPropsSelect);
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec && (namedSpec = (NamedWindowConsumerStreamSpec)filterStreamSpec).getFilterExpressions().isEmpty()) {
            boolean disableIndexShare;
            NamedWindowMetaData namedWindow = namedSpec.getNamedWindow();
            boolean bl4 = disableIndexShare = HintEnum.DISABLE_WINDOW_SUBQUERY_INDEXSHARE.getHint(annotations) != null;
            if (disableIndexShare && namedWindow.isVirtualDataWindow()) {
                disableIndexShare = false;
            }
            if (!disableIndexShare && namedWindow.isEnableIndexShare()) {
                SubSelectHelperForgePlanner.validateContextAssociation(statement.getContextName(), namedWindow.getContextName(), "named window '" + namedWindow.getEventType().getName() + "'");
                if (queryPlanLogging && QUERY_PLAN_LOG.isInfoEnabled()) {
                    QUERY_PLAN_LOG.info("prefering shared index");
                }
                boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
                ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(allStreamNames, statement.getStatementRawInfo(), services);
                SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
                SubSelectStrategyFactoryIndexShareForge strategyForge = new SubSelectStrategyFactoryIndexShareForge(subqueryNum, subselectActivation, outerEventTypesSelect, namedWindow, null, fullTableScan, indexHint, joinedPropPlan, filterExprEval, groupByNodes, aggregationServiceForgeDesc, statement, services);
                additionalForgeables.addAll(strategyForge.getAdditionalForgeables());
                SubSelectFactoryForge forge = new SubSelectFactoryForge(subqueryNum, subselectActivation.getActivator(), strategyForge);
                return new SubSelectFactoryForgeDesc(forge, additionalForgeables);
            }
        }
        if (filterStreamSpec instanceof TableQueryStreamSpec) {
            TableQueryStreamSpec tableSpec = (TableQueryStreamSpec)filterStreamSpec;
            SubSelectHelperForgePlanner.validateContextAssociation(statement.getStatementRawInfo().getContextName(), tableSpec.getTable().getOptionalContextName(), "table '" + tableSpec.getTable().getTableName() + "'");
            boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
            ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(allStreamNames, statement.getStatementRawInfo(), services);
            SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
            SubSelectStrategyFactoryIndexShareForge strategyForge = new SubSelectStrategyFactoryIndexShareForge(subqueryNum, subselectActivation, outerEventTypesSelect, null, tableSpec.getTable(), fullTableScan, indexHint, joinedPropPlan, filterExprEval, groupByNodes, aggregationServiceForgeDesc, statement, services);
            additionalForgeables.addAll(strategyForge.getAdditionalForgeables());
            SubSelectFactoryForge forge = new SubSelectFactoryForge(subqueryNum, subselectActivation.getActivator(), strategyForge);
            return new SubSelectFactoryForgeDesc(forge, additionalForgeables);
        }
        Set<String> optionalUniqueProps = StreamJoinAnalysisResultCompileTime.getUniqueCandidateProperties(viewForges, annotations);
        NamedWindowMetaData namedWindow = null;
        ExprNode namedWindowFilterExpr = null;
        QueryGraphForge namedWindowFilterQueryGraph = null;
        if (filterStreamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec2 = (NamedWindowConsumerStreamSpec)filterStreamSpec;
            namedWindow = namedSpec2.getNamedWindow();
            optionalUniqueProps = namedWindow.getUniquenessAsSet();
            if (namedSpec2.getFilterExpressions() != null && !namedSpec2.getFilterExpressions().isEmpty()) {
                StreamTypeServiceImpl types = new StreamTypeServiceImpl(namedWindow.getEventType(), namedWindow.getEventType().getName(), false);
                namedWindowFilterExpr = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(namedSpec2.getFilterExpressions());
                namedWindowFilterQueryGraph = EPLValidationUtil.validateFilterGetQueryGraphSafe(namedWindowFilterExpr, types, statement.getStatementRawInfo(), services);
            }
        }
        boolean fullTableScan = HintEnum.SET_NOINDEX.getHint(annotations) != null;
        SubqueryIndexForgeDesc indexDesc = SubSelectHelperForgePlanner.determineSubqueryIndexFactory(filterExpr, eventType, outerEventTypes, subselectTypeService, fullTableScan, queryPlanLogging, optionalUniqueProps, statement, subselect, services);
        additionalForgeables.addAll(indexDesc.getAdditionalForgeables());
        Pair<EventTableFactoryFactoryForge, SubordTableLookupStrategyFactoryForge> indexPair = new Pair<EventTableFactoryFactoryForge, SubordTableLookupStrategyFactoryForge>(indexDesc.getTableForge(), indexDesc.getLookupForge());
        SubSelectStrategyFactoryLocalViewPreloadedForge strategyForge = new SubSelectStrategyFactoryLocalViewPreloadedForge(viewForges, viewResourceDelegateDesc, indexPair, filterExpr, correlatedSubquery, aggregationServiceForgeDesc, subqueryNum, groupByNodes, namedWindow, namedWindowFilterExpr, namedWindowFilterQueryGraph, groupByMultikeyPlan == null ? null : groupByMultikeyPlan.getClassRef());
        SubSelectFactoryForge forge = new SubSelectFactoryForge(subqueryNum, subselectActivation.getActivator(), strategyForge);
        return new SubSelectFactoryForgeDesc(forge, additionalForgeables);
    }

    private static void validateSubqueryDataWindow(ExprSubselectNode subselectNode, boolean correlatedSubquery, boolean hasNonAggregatedProperties, ExprNodePropOrStreamSet propertiesGroupBy, ExprNodePropOrStreamSet nonAggregatedPropsSelect) throws ExprValidationException {
        StreamSpecCompiled streamSpec = subselectNode.getStatementSpecCompiled().getStreamSpecs()[0];
        if (!(streamSpec instanceof FilterStreamSpecCompiled) || streamSpec.getViewSpecs().length > 0) {
            return;
        }
        if (correlatedSubquery) {
            throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
        }
        if (hasNonAggregatedProperties) {
            if (propertiesGroupBy == null) {
                throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
            }
            String reason = nonAggregatedPropsSelect.notContainsAll(propertiesGroupBy);
            if (reason != null) {
                throw new ExprValidationException(MSG_SUBQUERY_REQUIRES_WINDOW);
            }
        }
    }

    private static void validateAggregationPropsAndLocalGroup(List<ExprAggregateNode> aggregateNodes) throws ExprValidationException {
        for (ExprAggregateNode aggNode : aggregateNodes) {
            List<Pair<Integer, String>> propertiesNodesAggregated = ExprNodeUtilityQuery.getExpressionProperties(aggNode, true);
            for (Pair<Integer, String> pair : propertiesNodesAggregated) {
                if (pair.getFirst() == 0) continue;
                throw new ExprValidationException("Subselect aggregation functions cannot aggregate across correlated properties");
            }
            if (aggNode.getOptionalLocalGroupBy() == null) continue;
            throw new ExprValidationException("Subselect aggregations functions cannot specify a group-by");
        }
    }

    private static SubqueryIndexForgeDesc determineSubqueryIndexFactory(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService, boolean fullTableScan, boolean queryPlanLogging, Set<String> optionalUniqueProps, StatementBaseInfo statement, ExprSubselectNode subselect, StatementCompileTimeServices services) throws ExprValidationException {
        SubqueryIndexForgeDesc desc = SubSelectHelperForgePlanner.determineSubqueryIndexInternalFactory(filterExpr, viewableEventType, outerEventTypes, subselectTypeService, fullTableScan, optionalUniqueProps, statement, subselect, services);
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(statement.getStatementSpec().getAnnotations(), services.getClasspathImportServiceCompileTime());
        if (queryPlanLogging && (QUERY_PLAN_LOG.isInfoEnabled() || hook != null)) {
            QUERY_PLAN_LOG.info("local index");
            QUERY_PLAN_LOG.info("strategy " + desc.getLookupForge().toQueryPlan());
            QUERY_PLAN_LOG.info("table " + desc.getTableForge().toQueryPlan());
            if (hook != null) {
                String strategyName = desc.getLookupForge().getClass().getSimpleName();
                hook.subquery(new QueryPlanIndexDescSubquery(new IndexNameAndDescPair[]{new IndexNameAndDescPair(null, desc.getTableForge().getEventTableClass().getSimpleName())}, subselect.getSubselectNumber(), strategyName));
            }
        }
        return desc;
    }

    private static String validateContextAssociation(String optionalProvidedContextName, String entityDeclaredContextName, String entityDesc) throws ExprValidationException {
        if (!(entityDeclaredContextName == null || optionalProvidedContextName != null && optionalProvidedContextName.equals(entityDeclaredContextName))) {
            throw new ExprValidationException("Mismatch in context specification, the context for the " + entityDesc + " is '" + entityDeclaredContextName + "' and the query specifies " + (optionalProvidedContextName == null ? "no context " : "context '" + optionalProvidedContextName + "'"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static SubqueryIndexForgeDesc determineSubqueryIndexInternalFactory(ExprNode filterExpr, EventType viewableEventType, EventType[] outerEventTypes, StreamTypeService subselectTypeService, boolean fullTableScan, Set<String> optionalUniqueProps, StatementBaseInfo statement, ExprSubselectNode subselectNode, StatementCompileTimeServices services) throws ExprValidationException {
        void var21_31;
        EventTableFactoryFactoryForge eventTableFactory;
        CoercionDesc hashCoercionDesc;
        int subqueryNumber = subselectNode.getSubselectNumber();
        if (filterExpr == null || fullTableScan) {
            UnindexedEventTableFactoryFactoryForge tableForge = new UnindexedEventTableFactoryFactoryForge(0, subqueryNumber, false);
            SubordFullTableScanLookupStrategyFactoryForge strategy = new SubordFullTableScanLookupStrategyFactoryForge();
            return new SubqueryIndexForgeDesc(tableForge, strategy, Collections.emptyList());
        }
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(subselectTypeService.getStreamNames(), statement.getStatementRawInfo(), services);
        SubordPropPlan joinPropDesc = QueryPlanIndexBuilder.getJoinProps(filterExpr, outerEventTypes.length, subselectTypeService.getEventTypes(), excludePlanHint);
        Map<String, SubordPropHashKeyForge> hashKeys = joinPropDesc.getHashProps();
        Map<String, SubordPropRangeKeyForge> rangeKeys = joinPropDesc.getRangeProps();
        ArrayList<SubordPropHashKeyForge> hashKeyList = new ArrayList<SubordPropHashKeyForge>(hashKeys.values());
        ArrayList<SubordPropRangeKeyForge> rangeKeyList = new ArrayList<SubordPropRangeKeyForge>(rangeKeys.values());
        boolean unique = false;
        ExprNode[] inKeywordSingleIdxKeys = null;
        ExprNode inKeywordMultiIdxKey = null;
        if (optionalUniqueProps != null && !optionalUniqueProps.isEmpty()) {
            boolean found = true;
            for (String string : optionalUniqueProps) {
                if (hashKeys.containsKey(string)) continue;
                found = false;
                break;
            }
            if (found) {
                String[] hashKeysArray;
                for (String hashKey : hashKeysArray = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()])) {
                    if (optionalUniqueProps.contains(hashKey)) continue;
                    hashKeys.remove(hashKey);
                }
                hashKeyList = new ArrayList<SubordPropHashKeyForge>(hashKeys.values());
                unique = true;
                rangeKeyList.clear();
                rangeKeys.clear();
            }
        }
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        MultiKeyClassRef hashMultikeyClasses = null;
        if (hashKeys.size() != 0 && rangeKeys.isEmpty()) {
            String[] indexedProps = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()]);
            hashCoercionDesc = CoercionUtil.getCoercionTypesHash(viewableEventType, indexedProps, hashKeyList);
            CoercionDesc coercionDesc = new CoercionDesc(false, null);
            MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKey(hashCoercionDesc.getCoercionTypes(), false, statement.getStatementRawInfo(), services.getSerdeResolver());
            additionalForgeables.addAll(multiKeyPlan.getMultiKeyForgeables());
            hashMultikeyClasses = multiKeyPlan.getClassRef();
            eventTableFactory = new PropertyHashedFactoryFactoryForge(0, subqueryNumber, false, indexedProps, viewableEventType, unique, hashCoercionDesc, multiKeyPlan.getClassRef());
        } else if (hashKeys.isEmpty() && rangeKeys.isEmpty()) {
            CoercionDesc coercionDesc = new CoercionDesc(false, null);
            if (joinPropDesc.getInKeywordSingleIndex() != null) {
                String prop = joinPropDesc.getInKeywordSingleIndex().getIndexedProp();
                Class[] propTypes = new Class[]{viewableEventType.getPropertyType(prop)};
                hashCoercionDesc = new CoercionDesc(false, propTypes);
                DataInputOutputSerdeForge serdeForge = services.getSerdeResolver().serdeForIndexHashNonArray(propTypes[0], statement.getStatementRawInfo());
                hashMultikeyClasses = new MultiKeyClassRefWSerde(serdeForge, propTypes);
                eventTableFactory = new PropertyHashedFactoryFactoryForge(0, subqueryNumber, false, new String[]{prop}, viewableEventType, unique, hashCoercionDesc, hashMultikeyClasses);
                inKeywordSingleIdxKeys = joinPropDesc.getInKeywordSingleIndex().getExpressions();
            } else if (joinPropDesc.getInKeywordMultiIndex() != null) {
                String[] props = joinPropDesc.getInKeywordMultiIndex().getIndexedProp();
                hashCoercionDesc = new CoercionDesc(false, EventTypeUtility.getPropertyTypes(viewableEventType, props));
                DataInputOutputSerdeForge[] serdes = new DataInputOutputSerdeForge[hashCoercionDesc.getCoercionTypes().length];
                for (int i = 0; i < hashCoercionDesc.getCoercionTypes().length; ++i) {
                    serdes[i] = services.getSerdeResolver().serdeForIndexHashNonArray(hashCoercionDesc.getCoercionTypes()[i], statement.getStatementRawInfo());
                }
                eventTableFactory = new PropertyHashedArrayFactoryFactoryForge(0, viewableEventType, props, hashCoercionDesc.getCoercionTypes(), serdes, unique, false);
                inKeywordMultiIdxKey = joinPropDesc.getInKeywordMultiIndex().getExpression();
            } else {
                hashCoercionDesc = new CoercionDesc(false, null);
                eventTableFactory = new UnindexedEventTableFactoryFactoryForge(0, subqueryNumber, false);
            }
        } else if (hashKeys.isEmpty() && rangeKeys.size() == 1) {
            String indexedProp = rangeKeys.keySet().iterator().next();
            CoercionDesc coercionRangeTypes = CoercionUtil.getCoercionTypesRange(viewableEventType, rangeKeys, outerEventTypes);
            DataInputOutputSerdeForge serde = services.getSerdeResolver().serdeForIndexBtree(coercionRangeTypes.getCoercionTypes()[0], statement.getStatementRawInfo());
            eventTableFactory = new PropertySortedFactoryFactoryForge(0, subqueryNumber, false, indexedProp, viewableEventType, coercionRangeTypes, serde);
            hashCoercionDesc = new CoercionDesc(false, null);
            CoercionDesc coercionDesc = coercionRangeTypes;
        } else {
            String[] indexedKeyProps = hashKeys.keySet().toArray(new String[hashKeys.keySet().size()]);
            Class[] coercionKeyTypes = SubordPropUtil.getCoercionTypes(hashKeys.values());
            MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKey(coercionKeyTypes, false, statement.getStatementRawInfo(), services.getSerdeResolver());
            additionalForgeables.addAll(multiKeyPlan.getMultiKeyForgeables());
            hashMultikeyClasses = multiKeyPlan.getClassRef();
            String[] indexedRangeProps = rangeKeys.keySet().toArray(new String[rangeKeys.keySet().size()]);
            CoercionDesc coercionRangeTypes = CoercionUtil.getCoercionTypesRange(viewableEventType, rangeKeys, outerEventTypes);
            DataInputOutputSerdeForge[] rangeSerdes = new DataInputOutputSerdeForge[coercionRangeTypes.getCoercionTypes().length];
            for (int i = 0; i < coercionRangeTypes.getCoercionTypes().length; ++i) {
                rangeSerdes[i] = services.getSerdeResolver().serdeForIndexBtree(coercionRangeTypes.getCoercionTypes()[i], statement.getStatementRawInfo());
            }
            eventTableFactory = new PropertyCompositeEventTableFactoryFactoryForge(0, subqueryNumber, false, indexedKeyProps, coercionKeyTypes, hashMultikeyClasses, indexedRangeProps, coercionRangeTypes.getCoercionTypes(), rangeSerdes, viewableEventType);
            hashCoercionDesc = CoercionUtil.getCoercionTypesHash(viewableEventType, indexedKeyProps, hashKeyList);
            CoercionDesc coercionDesc = coercionRangeTypes;
        }
        SubordTableLookupStrategyFactoryForge subqTableLookupStrategyFactory = SubordinateTableLookupStrategyUtil.getLookupStrategy(outerEventTypes, hashKeyList, hashCoercionDesc, hashMultikeyClasses, rangeKeyList, (CoercionDesc)var21_31, inKeywordSingleIdxKeys, inKeywordMultiIdxKey, false);
        return new SubqueryIndexForgeDesc(eventTableFactory, subqTableLookupStrategyFactory, additionalForgeables);
    }

    private static StreamTypeService getDeclaredExprTypeService(ExprDeclaredNode[] declaredExpressions, Map<ExprDeclaredNode, List<ExprDeclaredNode>> declaredExpressionCallHierarchy, String[] outerStreamNames, EventType[] outerEventTypesSelect, ExprSubselectNode subselect, String subexpressionStreamName, EventType eventType) throws ExprValidationException {
        for (ExprDeclaredNode declaration : declaredExpressions) {
            ExprNodeSubselectDeclaredNoTraverseVisitor visitor = new ExprNodeSubselectDeclaredNoTraverseVisitor(declaration);
            visitor.reset();
            declaration.accept(visitor);
            if (!visitor.getSubselects().contains(subselect)) continue;
            if (declaration.getPrototype().isAlias()) {
                return null;
            }
            LinkedHashMap<String, Integer> outerStreamNamesMap = new LinkedHashMap<String, Integer>();
            int count = 0;
            for (String outerStreamName : outerStreamNames) {
                outerStreamNamesMap.put(outerStreamName, count++);
            }
            LinkedHashMap<String, Integer> outerStreamNamesForSubselect = outerStreamNamesMap;
            List<ExprDeclaredNode> callers = declaredExpressionCallHierarchy.get(declaration);
            for (ExprDeclaredNode caller : callers) {
                outerStreamNamesForSubselect = caller.getOuterStreamNames(outerStreamNamesForSubselect);
            }
            outerStreamNamesForSubselect = declaration.getOuterStreamNames(outerStreamNamesForSubselect);
            EventType[] eventTypes = new EventType[outerStreamNamesForSubselect.size() + 1];
            String[] streamNames = new String[outerStreamNamesForSubselect.size() + 1];
            eventTypes[0] = eventType;
            streamNames[0] = subexpressionStreamName;
            count = 0;
            for (Map.Entry entry : outerStreamNamesForSubselect.entrySet()) {
                eventTypes[count + 1] = outerEventTypesSelect[(Integer)entry.getValue()];
                streamNames[count + 1] = (String)entry.getKey();
                ++count;
            }
            StreamTypeServiceImpl availableTypes = new StreamTypeServiceImpl(eventTypes, streamNames, new boolean[eventTypes.length], false, false);
            availableTypes.setRequireStreamNames(true);
            return availableTypes;
        }
        return null;
    }
}

