/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.subselect;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.expression.prior.PriorEvalStrategy;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactory;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactoryFactory;
import com.espertech.esper.common.internal.epl.index.base.EventTableIndexService;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategyNullRow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailViewInstance;
import com.espertech.esper.common.internal.epl.prior.PriorHelper;
import com.espertech.esper.common.internal.epl.subselect.SubSelectStrategyFactory;
import com.espertech.esper.common.internal.epl.subselect.SubSelectStrategyRealization;
import com.espertech.esper.common.internal.epl.subselect.SubqueryIndexStopCallback;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorBase;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorFilteredGrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorFilteredUngrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorUnfilteredGrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregationPreprocessorUnfilteredUngrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregatorViewBase;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregatorViewFilteredGrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregatorViewFilteredUngrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregatorViewUnfilteredGrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectAggregatorViewUnfilteredUngrouped;
import com.espertech.esper.common.internal.epl.subselect.SubselectBufferObserver;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryUtil;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewablePair;
import com.espertech.esper.common.internal.view.previous.PreviousGetterStrategy;
import com.espertech.esper.common.internal.view.util.BufferView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSelectStrategyFactoryLocalViewPreloaded
implements SubSelectStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SubSelectStrategyFactoryLocalViewPreloaded.class);
    private int subqueryNumber;
    private ViewFactory[] viewFactories;
    private ViewResourceDelegateDesc viewResourceDelegate;
    private EventTableFactoryFactory eventTableFactoryFactory;
    private EventTableFactory eventTableFactory;
    private SubordTableLookupStrategyFactory lookupStrategyFactory;
    private AggregationServiceFactory aggregationServiceFactory;
    private boolean correlatedSubquery;
    private ExprEvaluator groupKeyEval;
    private ExprEvaluator filterExprEval;
    private EventTableIndexService eventTableIndexService;
    private NamedWindow namedWindow;
    private ExprEvaluator namedWindowFilterExpr;
    private QueryGraph namedWindowFilterQueryGraph;

    public void setSubqueryNumber(int subqueryNumber) {
        this.subqueryNumber = subqueryNumber;
    }

    public void setViewFactories(ViewFactory[] viewFactories) {
        this.viewFactories = viewFactories;
    }

    public void setViewResourceDelegate(ViewResourceDelegateDesc viewResourceDelegate) {
        this.viewResourceDelegate = viewResourceDelegate;
    }

    public void setEventTableFactoryFactory(EventTableFactoryFactory eventTableFactoryFactory) {
        this.eventTableFactoryFactory = eventTableFactoryFactory;
    }

    public void setNamedWindow(NamedWindow namedWindow) {
        this.namedWindow = namedWindow;
    }

    public void setLookupStrategyFactory(SubordTableLookupStrategyFactory lookupStrategyFactory) {
        this.lookupStrategyFactory = lookupStrategyFactory;
    }

    public void setAggregationServiceFactory(AggregationServiceFactory aggregationServiceFactory) {
        this.aggregationServiceFactory = aggregationServiceFactory;
    }

    public void setCorrelatedSubquery(boolean correlatedSubquery) {
        this.correlatedSubquery = correlatedSubquery;
    }

    public void setGroupKeyEval(ExprEvaluator groupKeyEval) {
        this.groupKeyEval = groupKeyEval;
    }

    public void setFilterExprEval(ExprEvaluator filterExprEval) {
        this.filterExprEval = filterExprEval;
    }

    public void setNamedWindowFilterExpr(ExprEvaluator namedWindowFilterExpr) {
        this.namedWindowFilterExpr = namedWindowFilterExpr;
    }

    public void setNamedWindowFilterQueryGraph(QueryGraph namedWindowFilterQueryGraph) {
        this.namedWindowFilterQueryGraph = namedWindowFilterQueryGraph;
    }

    @Override
    public void ready(StatementContext statementContext, EventType eventType) {
        EventType type = this.viewFactories.length == 0 ? eventType : this.viewFactories[this.viewFactories.length - 1].getEventType();
        this.eventTableFactory = this.eventTableFactoryFactory.create(type, statementContext);
        this.eventTableIndexService = statementContext.getEventTableIndexService();
    }

    @Override
    public SubSelectStrategyRealization instantiate(Viewable viewableRoot, AgentInstanceContext agentInstanceContext, List<AgentInstanceStopCallback> stopCallbackList, int subqueryNumber, boolean isRecoveringResilient) {
        AgentInstanceViewFactoryChainContext viewFactoryChainContext = AgentInstanceViewFactoryChainContext.create(this.viewFactories, agentInstanceContext, this.viewResourceDelegate);
        ViewablePair viewables = ViewFactoryUtil.materialize(this.viewFactories, viewableRoot, viewFactoryChainContext, stopCallbackList);
        Viewable subselectView = viewables.getLast();
        AggregationService aggregationService = null;
        if (this.aggregationServiceFactory != null) {
            final AggregationService aggregationServiceStoppable = aggregationService = this.aggregationServiceFactory.makeService(agentInstanceContext, agentInstanceContext.getClasspathImportServiceRuntime(), true, subqueryNumber, null);
            stopCallbackList.add(new AgentInstanceStopCallback(){

                @Override
                public void stop(AgentInstanceStopServices services) {
                    aggregationServiceStoppable.stop();
                }
            });
        }
        PriorEvalStrategy priorStrategy = PriorHelper.toStrategy(viewFactoryChainContext);
        PreviousGetterStrategy previousGetter = viewFactoryChainContext.getPreviousNodeGetter();
        if (this.aggregationServiceFactory != null && !this.correlatedSubquery) {
            SubselectAggregatorViewBase aggregatorView = this.groupKeyEval == null ? (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null) : new SubselectAggregatorViewFilteredUngrouped(aggregationService, this.filterExprEval, agentInstanceContext, null)) : (this.filterExprEval == null ? new SubselectAggregatorViewUnfilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeyEval) : new SubselectAggregatorViewFilteredGrouped(aggregationService, this.filterExprEval, agentInstanceContext, this.groupKeyEval));
            subselectView.setChild(aggregatorView);
            if (this.namedWindow != null && this.eventTableIndexService.allowInitIndex(isRecoveringResilient)) {
                this.preloadFromNamedWindow(null, aggregatorView, agentInstanceContext);
            }
            return new SubSelectStrategyRealization(SubordTableLookupStrategyNullRow.INSTANCE, null, aggregationService, priorStrategy, previousGetter, subselectView, null);
        }
        EventTable[] index = this.eventTableFactory.makeEventTables(agentInstanceContext, subqueryNumber);
        stopCallbackList.add(new SubqueryIndexStopCallback(index));
        SubordTableLookupStrategy strategy = this.lookupStrategyFactory.makeStrategy(index, agentInstanceContext, null);
        SubselectAggregationPreprocessorBase subselectAggregationPreprocessor = null;
        if (this.aggregationServiceFactory != null) {
            subselectAggregationPreprocessor = this.groupKeyEval == null ? (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredUngrouped(aggregationService, this.filterExprEval, null) : new SubselectAggregationPreprocessorFilteredUngrouped(aggregationService, this.filterExprEval, null)) : (this.filterExprEval == null ? new SubselectAggregationPreprocessorUnfilteredGrouped(aggregationService, this.filterExprEval, this.groupKeyEval) : new SubselectAggregationPreprocessorFilteredGrouped(aggregationService, this.filterExprEval, this.groupKeyEval));
        }
        if (this.namedWindow != null && this.eventTableIndexService.allowInitIndex(isRecoveringResilient)) {
            this.preloadFromNamedWindow(index, subselectView, agentInstanceContext);
        }
        BufferView bufferView = new BufferView(subqueryNumber);
        bufferView.setObserver(new SubselectBufferObserver(index, agentInstanceContext));
        subselectView.setChild(bufferView);
        return new SubSelectStrategyRealization(strategy, subselectAggregationPreprocessor, aggregationService, priorStrategy, previousGetter, subselectView, index);
    }

    private void preloadFromNamedWindow(EventTable[] eventIndex, Viewable subselectView, AgentInstanceContext agentInstanceContext) {
        ArrayList<EventBean> eventsInWindow;
        NamedWindowInstance instance = this.namedWindow.getNamedWindowInstance(agentInstanceContext);
        if (instance == null) {
            throw new EPException("Named window '" + this.namedWindow.getName() + "' is associated to context '" + this.namedWindow.getStatementContext().getContextName() + "' that is not available for querying");
        }
        NamedWindowTailViewInstance consumerView = instance.getTailViewInstance();
        if (this.namedWindowFilterExpr != null) {
            Collection<EventBean> snapshot = consumerView.snapshotNoLock(this.namedWindowFilterQueryGraph, agentInstanceContext.getAnnotations());
            eventsInWindow = new ArrayList(snapshot.size());
            ExprNodeUtilityEvaluate.applyFilterExpressionIterable(snapshot.iterator(), this.namedWindowFilterExpr, agentInstanceContext, eventsInWindow);
        } else {
            eventsInWindow = new ArrayList<EventBean>();
            Iterator<EventBean> it = consumerView.iterator();
            while (it.hasNext()) {
                eventsInWindow.add(it.next());
            }
        }
        EventBean[] newEvents = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
        if (subselectView != null) {
            ((View)subselectView).update(newEvents, null);
        }
        if (eventIndex != null) {
            for (EventTable table : eventIndex) {
                table.add(newEvents, (ExprEvaluatorContext)agentInstanceContext);
            }
        }
    }

    @Override
    public LookupStrategyDesc getLookupStrategyDesc() {
        return this.lookupStrategyFactory.getLookupStrategyDesc();
    }
}

