/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.compiletime;

import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.util.CompileTimeRegistry;
import java.util.Map;

public class TableCompileTimeRegistry
implements CompileTimeRegistry {
    private final Map<String, TableMetaData> tables;

    public TableCompileTimeRegistry(Map<String, TableMetaData> tables) {
        this.tables = tables;
    }

    public void newTable(TableMetaData metaData) {
        if (!metaData.getTableVisibility().isModuleProvidedAccessModifier()) {
            throw new IllegalStateException("Invalid visibility for tables");
        }
        String tableName = metaData.getTableName();
        TableMetaData existing = this.tables.get(tableName);
        if (existing != null) {
            throw new IllegalStateException("Duplicate table encountered for name '" + tableName + "'");
        }
        this.tables.put(tableName, metaData);
    }

    public Map<String, TableMetaData> getTables() {
        return this.tables;
    }

    public TableMetaData getTable(String tableName) {
        return this.tables.get(tableName);
    }
}

