/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.compiletime;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.Copyable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableMetaData
implements Copyable<TableMetaData> {
    private String tableName;
    private String tableModuleName;
    private NameAccessModifier tableVisibility;
    private String optionalContextName;
    private NameAccessModifier optionalContextVisibility;
    private String optionalContextModule;
    private EventType internalEventType;
    private EventType publicEventType;
    private String[] keyColumns;
    private Class[] keyTypes;
    private int[] keyColNums;
    private Map<String, TableMetadataColumn> columns;
    private int numMethodAggs;
    private IndexMultiKey keyIndexMultiKey;
    private EventTableIndexMetadata indexMetadata = new EventTableIndexMetadata();

    public TableMetaData() {
    }

    public TableMetaData(String tableName, String tableModuleName, NameAccessModifier tableVisibility, String optionalContextName, NameAccessModifier optionalContextVisibility, String optionalContextModule, EventType internalEventType, EventType publicEventType, String[] keyColumns, Class[] keyTypes, int[] keyColNums, Map<String, TableMetadataColumn> columns, int numMethodAggs) {
        this.tableName = tableName;
        this.tableModuleName = tableModuleName;
        this.tableVisibility = tableVisibility;
        this.optionalContextName = optionalContextName;
        this.optionalContextVisibility = optionalContextVisibility;
        this.optionalContextModule = optionalContextModule;
        this.internalEventType = internalEventType;
        this.publicEventType = publicEventType;
        this.keyColumns = keyColumns;
        this.keyTypes = keyTypes;
        this.columns = columns;
        this.keyColNums = keyColNums;
        this.numMethodAggs = numMethodAggs;
        this.init();
    }

    private TableMetaData(String tableName, String tableModuleName, NameAccessModifier tableVisibility, String optionalContextName, NameAccessModifier optionalContextVisibility, String optionalContextModule, EventType internalEventType, EventType publicEventType, String[] keyColumns, Class[] keyTypes, int[] keyColNums, Map<String, TableMetadataColumn> columns, int numMethodAggs, IndexMultiKey keyIndexMultiKey, EventTableIndexMetadata indexMetadata) {
        this.tableName = tableName;
        this.tableModuleName = tableModuleName;
        this.tableVisibility = tableVisibility;
        this.optionalContextName = optionalContextName;
        this.optionalContextVisibility = optionalContextVisibility;
        this.optionalContextModule = optionalContextModule;
        this.internalEventType = internalEventType;
        this.publicEventType = publicEventType;
        this.keyColumns = keyColumns;
        this.keyTypes = keyTypes;
        this.keyColNums = keyColNums;
        this.columns = columns;
        this.numMethodAggs = numMethodAggs;
        this.keyIndexMultiKey = keyIndexMultiKey;
        this.indexMetadata = indexMetadata;
    }

    @Override
    public TableMetaData copy() {
        return new TableMetaData(this.tableName, this.tableModuleName, this.tableVisibility, this.optionalContextName, this.optionalContextVisibility, this.optionalContextModule, this.internalEventType, this.publicEventType, this.keyColumns, this.keyTypes, this.keyColNums, this.columns, this.numMethodAggs, this.keyIndexMultiKey, this.indexMetadata.copy());
    }

    public void init() {
        if (this.keyColumns == null || this.keyColumns.length == 0) {
            return;
        }
        IndexedPropDesc[] props = new IndexedPropDesc[this.keyColumns.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = new IndexedPropDesc(this.keyColumns[i], this.keyTypes[i]);
        }
        this.keyIndexMultiKey = new IndexMultiKey(true, props, new IndexedPropDesc[0], null);
        try {
            this.indexMetadata.addIndexExplicit(true, this.keyIndexMultiKey, this.tableName, this.tableModuleName, null, "");
        }
        catch (ExprValidationException e) {
            throw new EPException("Failed to add primary key index: " + e.getMessage(), e);
        }
    }

    public CodegenExpression make(CodegenMethodScope parent, ModuleTableInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(TableMetaData.class, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(TableMetaData.class, "meta", CodegenExpressionBuilder.newInstance(TableMetaData.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setTableName", CodegenExpressionBuilder.constant(this.tableName)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setTableModuleName", CodegenExpressionBuilder.constant(this.tableModuleName)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setTableVisibility", CodegenExpressionBuilder.constant((Object)this.tableVisibility)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setOptionalContextName", CodegenExpressionBuilder.constant(this.optionalContextName)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setOptionalContextVisibility", CodegenExpressionBuilder.constant((Object)this.optionalContextVisibility)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setOptionalContextModule", CodegenExpressionBuilder.constant(this.optionalContextModule)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setInternalEventType", EventTypeUtility.resolveTypeCodegen(this.internalEventType, symbols.getAddInitSvc(method))).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setPublicEventType", EventTypeUtility.resolveTypeCodegen(this.publicEventType, symbols.getAddInitSvc(method))).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setKeyColumns", CodegenExpressionBuilder.constant(this.keyColumns)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setKeyTypes", CodegenExpressionBuilder.constant(this.keyTypes)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setKeyColNums", CodegenExpressionBuilder.constant(this.keyColNums)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setColumns", TableMetadataColumn.makeColumns(this.columns, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "setNumMethodAggs", CodegenExpressionBuilder.constant(this.numMethodAggs)).exprDotMethod(CodegenExpressionBuilder.ref("meta"), "init", new CodegenExpression[0]).methodReturn(CodegenExpressionBuilder.ref("meta"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public CodegenExpression make(CodegenExpressionRef addInitSvc) {
        return CodegenExpressionBuilder.newInstance(TableMetaData.class, CodegenExpressionBuilder.constant(this.tableName), CodegenExpressionBuilder.constant(this.optionalContextName), CodegenExpressionBuilder.constant((Object)this.optionalContextVisibility), CodegenExpressionBuilder.constant(this.optionalContextModule), EventTypeUtility.resolveTypeCodegen(this.internalEventType, addInitSvc), EventTypeUtility.resolveTypeCodegen(this.publicEventType, addInitSvc));
    }

    public EventType getInternalEventType() {
        return this.internalEventType;
    }

    public EventType getPublicEventType() {
        return this.publicEventType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOptionalContextName() {
        return this.optionalContextName;
    }

    public NameAccessModifier getOptionalContextVisibility() {
        return this.optionalContextVisibility;
    }

    public String getOptionalContextModule() {
        return this.optionalContextModule;
    }

    public Class[] getKeyTypes() {
        return this.keyTypes;
    }

    public Map<String, TableMetadataColumn> getColumns() {
        return this.columns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOptionalContextName(String optionalContextName) {
        this.optionalContextName = optionalContextName;
    }

    public void setOptionalContextVisibility(NameAccessModifier optionalContextVisibility) {
        this.optionalContextVisibility = optionalContextVisibility;
    }

    public void setOptionalContextModule(String optionalContextModule) {
        this.optionalContextModule = optionalContextModule;
    }

    public void setInternalEventType(EventType internalEventType) {
        this.internalEventType = internalEventType;
    }

    public void setPublicEventType(EventType publicEventType) {
        this.publicEventType = publicEventType;
    }

    public void setKeyTypes(Class[] keyTypes) {
        this.keyTypes = keyTypes;
    }

    public void setColumns(Map<String, TableMetadataColumn> columns) {
        this.columns = columns;
    }

    public void setNumMethodAggs(int numMethodAggs) {
        this.numMethodAggs = numMethodAggs;
    }

    public int getNumMethodAggs() {
        return this.numMethodAggs;
    }

    public void setKeyColumns(String[] keyColumns) {
        this.keyColumns = keyColumns;
    }

    public String[] getKeyColumns() {
        return this.keyColumns;
    }

    public Set<String> getUniquenessAsSet() {
        if (this.keyColumns == null || this.keyColumns.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.keyColumns));
    }

    public EventTableIndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public boolean isKeyed() {
        return this.keyTypes != null && this.keyTypes.length > 0;
    }

    public int[] getKeyColNums() {
        return this.keyColNums;
    }

    public void setKeyColNums(int[] keyColNums) {
        this.keyColNums = keyColNums;
    }

    public IndexMultiKey getKeyIndexMultiKey() {
        return this.keyIndexMultiKey;
    }

    public String getTableModuleName() {
        return this.tableModuleName;
    }

    public void setTableModuleName(String tableModuleName) {
        this.tableModuleName = tableModuleName;
    }

    public NameAccessModifier getTableVisibility() {
        return this.tableVisibility;
    }

    public void setTableVisibility(NameAccessModifier tableVisibility) {
        this.tableVisibility = tableVisibility;
    }

    public void setKeyIndexMultiKey(IndexMultiKey keyIndexMultiKey) {
        this.keyIndexMultiKey = keyIndexMultiKey;
    }

    public void setIndexMetadata(EventTableIndexMetadata indexMetadata) {
        this.indexMetadata = indexMetadata;
    }

    public void addIndex(String indexName, String indexModuleName, IndexMultiKey imk, QueryPlanIndexItem indexItem) throws ExprValidationException {
        this.indexMetadata.addIndexExplicit(false, imk, indexName, indexModuleName, indexItem, "");
    }
}

