/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.collection.MultiKeyFromMultiKey;
import com.espertech.esper.common.internal.collection.MultiKeyFromObjectArray;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableFactory;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.core.TableMetadataInternalEventToPublic;
import com.espertech.esper.common.internal.epl.table.core.TableSerdes;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyRedoCallback;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import com.espertech.esper.common.internal.statement.resource.StatementResourceService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TableBase
implements Table {
    protected final TableMetaData metaData;
    protected TableMetadataInternalEventToPublic eventToPublic;
    protected StatementContext statementContextCreateTable;
    protected AggregationRowFactory aggregationRowFactory;
    protected TableSerdes tableSerdes;
    protected EventPropertyValueGetter primaryKeyGetter;
    protected DataInputOutputSerde<Object> primaryKeySerde;
    protected MultiKeyFromObjectArray primaryKeyObjectArrayTransform;
    protected MultiKeyFromMultiKey primaryKeyIntoTableTransform;
    protected Set<TableUpdateStrategyRedoCallback> updateStrategyRedoCallbacks = new HashSet<TableUpdateStrategyRedoCallback>(4);
    protected PropertyHashedEventTableFactory primaryKeyIndexFactory;

    protected abstract PropertyHashedEventTableFactory setupPrimaryKeyIndexFactory();

    public TableBase(TableMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void setEventToPublic(TableMetadataInternalEventToPublic eventToPublic) {
        this.eventToPublic = eventToPublic;
    }

    @Override
    public void setStatementContextCreateTable(StatementContext statementContextCreateTable) {
        this.statementContextCreateTable = statementContextCreateTable;
    }

    @Override
    public void setAggregationRowFactory(AggregationRowFactory aggregationRowFactory) {
        this.aggregationRowFactory = aggregationRowFactory;
    }

    @Override
    public void setTableSerdes(TableSerdes tableSerdes) {
        this.tableSerdes = tableSerdes;
    }

    @Override
    public void setPrimaryKeyGetter(EventPropertyValueGetter primaryKeyGetter) {
        this.primaryKeyGetter = primaryKeyGetter;
    }

    @Override
    public void setPrimaryKeySerde(DataInputOutputSerde<Object> primaryKeySerde) {
        this.primaryKeySerde = primaryKeySerde;
    }

    @Override
    public void setPrimaryKeyObjectArrayTransform(MultiKeyFromObjectArray primaryKeyObjectArrayTransform) {
        this.primaryKeyObjectArrayTransform = primaryKeyObjectArrayTransform;
    }

    @Override
    public void setPrimaryKeyIntoTableTransform(MultiKeyFromMultiKey primaryKeyIntoTableTransform) {
        this.primaryKeyIntoTableTransform = primaryKeyIntoTableTransform;
    }

    @Override
    public void tableReady() {
        if (this.metaData.isKeyed()) {
            this.primaryKeyIndexFactory = this.setupPrimaryKeyIndexFactory();
        }
    }

    @Override
    public TableMetadataInternalEventToPublic getEventToPublic() {
        return this.eventToPublic;
    }

    @Override
    public TableMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public TableSerdes getTableSerdes() {
        return this.tableSerdes;
    }

    @Override
    public AggregationRowFactory getAggregationRowFactory() {
        return this.aggregationRowFactory;
    }

    @Override
    public StatementContext getStatementContextCreateTable() {
        return this.statementContextCreateTable;
    }

    @Override
    public PropertyHashedEventTableFactory getPrimaryIndexFactory() {
        return this.primaryKeyIndexFactory;
    }

    @Override
    public boolean isGrouped() {
        return this.metaData.getKeyTypes() != null && this.metaData.getKeyTypes().length > 0;
    }

    @Override
    public String getName() {
        return this.metaData.getTableName();
    }

    @Override
    public EventTableIndexMetadata getEventTableIndexMetadata() {
        return this.metaData.getIndexMetadata();
    }

    public TableInstance getTableInstanceNoRemake(int agentInstanceId) {
        if (this.metaData.getOptionalContextName() == null) {
            return this.getTableInstanceNoContext();
        }
        StatementResourceService statementResourceService = this.statementContextCreateTable.getStatementCPCacheService().getStatementResourceService();
        StatementResourceHolder holder = statementResourceService.getPartitioned(agentInstanceId);
        return holder == null ? null : holder.getTableInstance();
    }

    public TableInstance getTableInstanceNoContextNoRemake() {
        StatementResourceService statementResourceService = this.statementContextCreateTable.getStatementCPCacheService().getStatementResourceService();
        StatementResourceHolder holder = statementResourceService.getUnpartitioned();
        return holder == null ? null : holder.getTableInstance();
    }

    @Override
    public void validateAddIndex(String deploymentId, String statementName, String indexName, String indexModuleName, QueryPlanIndexItem explicitIndexDesc, IndexMultiKey indexMultiKey) throws ExprValidationException {
        this.metaData.getIndexMetadata().addIndexExplicit(false, indexMultiKey, indexName, indexModuleName, explicitIndexDesc, deploymentId);
        for (TableUpdateStrategyRedoCallback callback : this.updateStrategyRedoCallbacks) {
            callback.initTableUpdateStrategy(this);
        }
    }

    @Override
    public void removeIndexReferencesStmtMayRemoveIndex(IndexMultiKey indexMultiKey, String deploymentId, String statementName) {
        boolean last = this.metaData.getIndexMetadata().removeIndexReference(indexMultiKey, deploymentId);
        if (last) {
            this.metaData.getIndexMetadata().removeIndex(indexMultiKey);
            this.removeAllInstanceIndexes(indexMultiKey);
        }
    }

    @Override
    public void removeAllInstanceIndexes(IndexMultiKey index) {
        StatementResourceService statementResourceService = this.statementContextCreateTable.getStatementCPCacheService().getStatementResourceService();
        if (this.metaData.getOptionalContextName() == null) {
            StatementResourceHolder holder = statementResourceService.getUnpartitioned();
            if (holder != null && holder.getTableInstance() != null) {
                holder.getTableInstance().getIndexRepository().removeIndex(index);
            }
        } else {
            for (Map.Entry<Integer, StatementResourceHolder> entry : statementResourceService.getResourcesPartitioned().entrySet()) {
                if (entry.getValue().getTableInstance() == null) continue;
                entry.getValue().getTableInstance().getIndexRepository().removeIndex(index);
            }
        }
    }

    @Override
    public void addUpdateStrategyCallback(TableUpdateStrategyRedoCallback callback) {
        this.updateStrategyRedoCallbacks.add(callback);
    }

    @Override
    public void removeUpdateStrategyCallback(TableUpdateStrategyRedoCallback callback) {
        this.updateStrategyRedoCallbacks.remove(callback);
    }

    @Override
    public Collection<TableUpdateStrategyRedoCallback> getUpdateStrategyCallbacks() {
        return this.updateStrategyRedoCallbacks;
    }

    @Override
    public MultiKeyFromMultiKey getPrimaryKeyIntoTableTransform() {
        return this.primaryKeyIntoTableTransform;
    }

    @Override
    public MultiKeyFromObjectArray getPrimaryKeyObjectArrayTransform() {
        return this.primaryKeyObjectArrayTransform;
    }

    @Override
    public DataInputOutputSerde<Object> getPrimaryKeySerde() {
        return this.primaryKeySerde;
    }
}

