/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class TableExprEvaluatorContext {
    private final ThreadLocal<Set<Lock>> threadLocal = new ThreadLocal<Set<Lock>>(){

        @Override
        protected synchronized Set<Lock> initialValue() {
            return new HashSet<Lock>();
        }
    };

    public boolean addAcquiredLock(Lock lock) {
        Set<Lock> locks = this.threadLocal.get();
        return locks.add(lock);
    }

    public void releaseAcquiredLocks() {
        Set<Lock> locks = this.threadLocal.get();
        if (locks.isEmpty()) {
            return;
        }
        for (Lock lock : locks) {
            lock.unlock();
        }
        locks.clear();
    }

    public int getLockHeldCount() {
        return this.threadLocal.get().size();
    }
}

