/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepository;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class TableInstanceBase
implements TableInstance {
    protected final Table table;
    protected final AgentInstanceContext agentInstanceContext;
    protected final ReentrantReadWriteLock tableLevelRWLock = new ReentrantReadWriteLock();
    protected final EventTableIndexRepository indexRepository;

    public TableInstanceBase(Table table, AgentInstanceContext agentInstanceContext) {
        this.table = table;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new EventTableIndexRepository(table.getEventTableIndexMetadata());
    }

    @Override
    public void addEventUnadorned(EventBean event) {
        if (event.getEventType() != this.table.getMetaData().getInternalEventType()) {
            throw new IllegalStateException("Unexpected event type for add: " + event.getEventType().getName());
        }
        ObjectArrayBackedEventBean oa = (ObjectArrayBackedEventBean)event;
        AggregationRow aggs = this.table.getAggregationRowFactory().make();
        oa.getProperties()[0] = aggs;
        this.addEvent(event);
    }

    @Override
    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    @Override
    public ReadWriteLock getTableLevelRWLock() {
        return this.tableLevelRWLock;
    }
}

