/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.strategy;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactory;
import com.espertech.esper.common.internal.epl.table.strategy.TableAndLockProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExprTableEvalHelperStart {
    public static Map<Integer, ExprTableEvalStrategy> startTableAccess(Map<Integer, ExprTableEvalStrategyFactory> tableAccesses, AgentInstanceContext agentInstanceContext) {
        if (tableAccesses == null || tableAccesses.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean writesToTables = agentInstanceContext.getStatementContext().getStatementInformationals().isWritesToTables();
        HashMap<Integer, ExprTableEvalStrategy> evals = new HashMap<Integer, ExprTableEvalStrategy>(tableAccesses.size(), 1.0f);
        for (Map.Entry<Integer, ExprTableEvalStrategyFactory> entry : tableAccesses.entrySet()) {
            Table table = entry.getValue().getTable();
            TableAndLockProvider provider = table.getStateProvider(agentInstanceContext.getAgentInstanceId(), writesToTables);
            ExprTableEvalStrategy strategy = entry.getValue().makeStrategy(provider);
            evals.put(entry.getKey(), strategy);
        }
        return evals;
    }
}

