/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.update;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategy;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperNoCopy;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class TableUpdateStrategyIndexNonUnique
implements TableUpdateStrategy {
    private final EventBeanUpdateHelperNoCopy updateHelper;
    private final Set<String> affectedIndexNames;

    public TableUpdateStrategyIndexNonUnique(EventBeanUpdateHelperNoCopy updateHelper, Set<String> affectedIndexNames) {
        this.updateHelper = updateHelper;
        this.affectedIndexNames = affectedIndexNames;
    }

    @Override
    public void updateTable(Collection<EventBean> eventsUnsafeIter, TableInstance instance, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] events = new EventBean[eventsUnsafeIter.size()];
        int count = 0;
        for (EventBean event : eventsUnsafeIter) {
            events[count++] = event;
        }
        for (String affectedIndexName : this.affectedIndexNames) {
            EventTable index = instance.getIndex(affectedIndexName);
            index.remove(events, (ExprEvaluatorContext)instance.getAgentInstanceContext());
        }
        for (Iterator<Object> iterator : events) {
            eventsPerStream[0] = iterator;
            ObjectArrayBackedEventBean updatedEvent = (ObjectArrayBackedEventBean)((Object)iterator);
            if (this.updateHelper.isRequiresStream2InitialValueEvent()) {
                Object[] prev = new Object[updatedEvent.getProperties().length];
                System.arraycopy(updatedEvent.getProperties(), 0, prev, 0, prev.length);
                eventsPerStream[2] = new ObjectArrayEventBean(prev, updatedEvent.getEventType());
            }
            this.updateHelper.updateNoCopy(updatedEvent, eventsPerStream, exprEvaluatorContext);
            instance.handleRowUpdated(updatedEvent);
        }
        for (String affectedIndexName : this.affectedIndexNames) {
            EventTable index = instance.getIndex(affectedIndexName);
            index.add(events, (ExprEvaluatorContext)instance.getAgentInstanceContext());
        }
    }
}

