/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.updatehelper;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperForge;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateItemForge;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.StringValue;
import com.espertech.esper.common.internal.util.TypeWidenerCustomizer;
import com.espertech.esper.common.internal.util.TypeWidenerException;
import com.espertech.esper.common.internal.util.TypeWidenerFactory;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventBeanUpdateHelperForgeFactory {
    public static EventBeanUpdateHelperForge make(String updatedWindowOrTableName, EventTypeSPI eventTypeSPI, List<OnTriggerSetAssignment> assignments, String updatedAlias, EventType optionalTriggeringEventType, boolean isCopyOnWrite, String statementName, EventTypeAvroHandler avroHandler) throws ExprValidationException {
        EventBeanCopyMethodForge copyMethod;
        ArrayList<EventBeanUpdateItemForge> updateItems = new ArrayList<EventBeanUpdateItemForge>();
        ArrayList<String> properties = new ArrayList<String>();
        TypeWidenerCustomizer typeWidenerCustomizer = avroHandler.getTypeWidenerCustomizer(eventTypeSPI);
        for (int i = 0; i < assignments.size(); ++i) {
            EventBeanUpdateItemForge updateItem;
            OnTriggerSetAssignment assignment = assignments.get(i);
            Pair<String, ExprNode> possibleAssignment = ExprNodeUtilityValidate.checkGetAssignmentToProp(assignment.getExpression());
            if (possibleAssignment != null) {
                TypeWidenerSPI widener;
                String propertyName = possibleAssignment.getFirst();
                EventPropertyDescriptor writableProperty = eventTypeSPI.getWritableProperty(propertyName);
                if (writableProperty == null) {
                    Pair<String, EventPropertyDescriptor> nameWriteablePair = EventBeanUpdateHelperForgeFactory.checkIndexedOrMappedProp(possibleAssignment.getFirst(), updatedWindowOrTableName, updatedAlias, eventTypeSPI);
                    propertyName = nameWriteablePair.getFirst();
                    writableProperty = nameWriteablePair.getSecond();
                }
                ExprForge evaluator = possibleAssignment.getSecond().getForge();
                EventPropertyWriterSPI writers = eventTypeSPI.getWriter(propertyName);
                boolean notNullableField = writableProperty.getPropertyType().isPrimitive();
                properties.add(propertyName);
                try {
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(possibleAssignment.getSecond()), possibleAssignment.getSecond().getForge().getEvaluationType(), writableProperty.getPropertyType(), propertyName, false, typeWidenerCustomizer, statementName);
                }
                catch (TypeWidenerException ex) {
                    throw new ExprValidationException(ex.getMessage(), ex);
                }
                if (optionalTriggeringEventType != null && possibleAssignment.getSecond() instanceof ExprIdentNode) {
                    ExprIdentNode node = (ExprIdentNode)possibleAssignment.getSecond();
                    FragmentEventType fragmentRHS = optionalTriggeringEventType.getFragmentType(node.getResolvedPropertyName());
                    FragmentEventType fragmentLHS = eventTypeSPI.getFragmentType(possibleAssignment.getFirst());
                    if (fragmentRHS != null && fragmentLHS != null && !EventTypeUtility.isTypeOrSubTypeOf(fragmentRHS.getFragmentType(), fragmentLHS.getFragmentType())) {
                        throw new ExprValidationException("Invalid assignment to property '" + possibleAssignment.getFirst() + "' event type '" + fragmentLHS.getFragmentType().getName() + "' from event type '" + fragmentRHS.getFragmentType().getName() + "'");
                    }
                }
                updateItem = new EventBeanUpdateItemForge(evaluator, propertyName, writers, notNullableField, widener);
            } else {
                updateItem = new EventBeanUpdateItemForge(assignment.getExpression().getForge(), null, null, false, null);
            }
            updateItems.add(updateItem);
        }
        if (isCopyOnWrite) {
            ArrayList propertiesUniqueList = new ArrayList(new HashSet(properties));
            String[] propertiesArray = propertiesUniqueList.toArray(new String[propertiesUniqueList.size()]);
            copyMethod = eventTypeSPI.getCopyMethodForge(propertiesArray);
            if (copyMethod == null) {
                throw new ExprValidationException("Event type does not support event bean copy");
            }
        } else {
            copyMethod = null;
            Set<String> propertiesInitialValue = EventBeanUpdateHelperForgeFactory.determinePropertiesInitialValue(assignments);
            if (!propertiesInitialValue.isEmpty()) {
                String[] propertiesInitialValueArray = propertiesInitialValue.toArray(new String[propertiesInitialValue.size()]);
                copyMethod = eventTypeSPI.getCopyMethodForge(propertiesInitialValueArray);
            }
        }
        EventBeanUpdateItemForge[] updateItemsArray = updateItems.toArray(new EventBeanUpdateItemForge[updateItems.size()]);
        return new EventBeanUpdateHelperForge(eventTypeSPI, copyMethod, updateItemsArray);
    }

    private static Set<String> determinePropertiesInitialValue(List<OnTriggerSetAssignment> assignments) {
        HashSet<String> props = new HashSet<String>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        for (OnTriggerSetAssignment assignment : assignments) {
            if (assignment.getExpression() instanceof ExprEqualsNode) {
                assignment.getExpression().getChildNodes()[1].accept(visitor);
            } else {
                assignment.getExpression().accept(visitor);
            }
            for (ExprIdentNode node : visitor.getExprProperties()) {
                if (node.getStreamId() != 2) continue;
                props.add(node.getResolvedPropertyName());
            }
        }
        return props;
    }

    private static Pair<String, EventPropertyDescriptor> checkIndexedOrMappedProp(String propertyName, String updatedWindowOrTableName, String namedWindowAlias, EventTypeSPI eventTypeSPI) throws ExprValidationException {
        String name;
        String prefix;
        EventPropertyDescriptor writableProperty = null;
        int indexDot = propertyName.indexOf(".");
        if (namedWindowAlias != null && indexDot != -1) {
            prefix = StringValue.unescapeBacktick(propertyName.substring(0, indexDot));
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(namedWindowAlias)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null && indexDot != -1) {
            prefix = propertyName.substring(0, indexDot);
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(updatedWindowOrTableName)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null) {
            throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
        }
        return new Pair<String, Object>(propertyName, writableProperty);
    }
}

