/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.common.internal.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactoryForge;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ViewResourceVerifyHelper {
    /*
     * WARNING - void declaration
     */
    public static ViewResourceDelegateDesc[] verifyPreviousAndPriorRequirements(List<ViewFactoryForge>[] unmaterializedViewChain, ViewResourceDelegateExpr delegate) throws ExprValidationException {
        void var6_11;
        void var6_9;
        int numStreams = unmaterializedViewChain.length;
        ViewResourceDelegateDesc[] perStream = new ViewResourceDelegateDesc[numStreams];
        boolean[] previousPerStream = new boolean[numStreams];
        for (ExprPreviousNode exprPreviousNode : delegate.getPreviousRequests()) {
            int stream = exprPreviousNode.getStreamNumber();
            List<ViewFactoryForge> forges = unmaterializedViewChain[stream];
            boolean pass = ViewResourceVerifyHelper.inspectViewFactoriesForPrevious(forges);
            if (!pass) {
                throw new ExprValidationException("Previous function requires a single data window view onto the stream");
            }
            boolean found = ViewResourceVerifyHelper.findDataWindow(forges);
            if (!found) {
                throw new ExprValidationException("Required data window not found for the 'prev' function, specify a data window for which previous events are retained");
            }
            previousPerStream[stream] = true;
        }
        SortedMap[] priorPerStream = new SortedMap[numStreams];
        for (ExprPriorNode priorNode : delegate.getPriorRequests()) {
            TreeMap treemap;
            LinkedList<ExprPriorNode> callbackList;
            int stream = priorNode.getStreamNumber();
            if (priorPerStream[stream] == null) {
                priorPerStream[stream] = new TreeMap();
            }
            if ((callbackList = (LinkedList<ExprPriorNode>)(treemap = (TreeMap)priorPerStream[stream]).get(priorNode.getConstantIndexNumber())) == null) {
                callbackList = new LinkedList<ExprPriorNode>();
                treemap.put(priorNode.getConstantIndexNumber(), callbackList);
            }
            callbackList.add(priorNode);
        }
        boolean bl = false;
        while (var6_9 < numStreams) {
            if (priorPerStream[var6_9] != null) {
                int relativeIndex = 0;
                for (Map.Entry entry : priorPerStream[var6_9].entrySet()) {
                    for (ExprPriorNode node : (List)entry.getValue()) {
                        node.setRelativeIndex(relativeIndex);
                    }
                    ++relativeIndex;
                }
            }
            ++var6_9;
        }
        boolean bl2 = false;
        while (var6_11 < numStreams) {
            if (priorPerStream[var6_11] == null) {
                priorPerStream[var6_11] = new TreeMap();
            }
            perStream[var6_11] = new ViewResourceDelegateDesc(previousPerStream[var6_11], new TreeSet<Integer>(priorPerStream[var6_11].keySet()));
            ++var6_11;
        }
        return perStream;
    }

    private static boolean findDataWindow(List<ViewFactoryForge> forges) {
        for (ViewFactoryForge forge : forges) {
            if (forge instanceof DataWindowViewForgeWithPrevious) {
                return true;
            }
            if (!(forge instanceof GroupByViewFactoryForge)) continue;
            GroupByViewFactoryForge group = (GroupByViewFactoryForge)forge;
            return ViewResourceVerifyHelper.findDataWindow(group.getGroupeds());
        }
        return false;
    }

    private static boolean inspectViewFactoriesForPrevious(List<ViewFactoryForge> viewFactories) {
        if (viewFactories.size() == 1) {
            return true;
        }
        if (viewFactories.size() == 2) {
            return viewFactories.get(0) instanceof GroupByViewFactoryForge;
        }
        return true;
    }
}

