/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableManagementService;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerSetDesc;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteDesc;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VariableReadWritePackage {
    private Map<EventTypeSPI, EventBeanCopyMethod> copyMethods;
    private VariableTriggerSetDesc[] assignments;
    private VariableTriggerWriteDesc[] writers;
    private Variable[] variables;
    private boolean[] mustCoerce;
    private VariableReader[] readersForGlobalVars;

    public void setCopyMethods(Map<EventTypeSPI, EventBeanCopyMethod> copyMethods) {
        this.copyMethods = copyMethods;
    }

    public void setAssignments(VariableTriggerSetDesc[] assignments) {
        this.assignments = assignments;
    }

    public void setWriters(VariableTriggerWriteDesc[] writers) {
        this.writers = writers;
    }

    public void setVariables(Variable[] variables) {
        this.variables = variables;
    }

    public void setMustCoerce(boolean[] mustCoerce) {
        this.mustCoerce = mustCoerce;
    }

    public void setReadersForGlobalVars(VariableReader[] readersForGlobalVars) {
        this.readersForGlobalVars = readersForGlobalVars;
    }

    public void writeVariables(EventBean[] eventsPerStream, Map<String, Object> valuesWritten, AgentInstanceContext agentInstanceContext) {
        HashSet<String> variablesBeansCopied = null;
        VariableManagementService variableService = agentInstanceContext.getVariableManagementService();
        if (!this.copyMethods.isEmpty()) {
            variablesBeansCopied = new HashSet<String>();
        }
        variableService.getReadWriteLock().writeLock().lock();
        try {
            variableService.setLocalVersion();
            int count = 0;
            for (VariableTriggerSetDesc assignment : this.assignments) {
                Variable variable = this.variables[count];
                VariableMetaData variableMetaData = variable.getMetaData();
                int agentInstanceId = variableMetaData.getOptionalContextName() == null ? -1 : agentInstanceContext.getAgentInstanceId();
                Object value = assignment.getEvaluator().evaluate(eventsPerStream, true, agentInstanceContext);
                int variableNumber = variable.getVariableNumber();
                if (this.writers[count] != null) {
                    VariableReader reader = variableService.getReader(this.variables[count].getDeploymentId(), variableMetaData.getVariableName(), agentInstanceId);
                    EventBean current = (EventBean)reader.getValue();
                    if (current == null) {
                        value = null;
                    } else {
                        VariableTriggerWriteDesc writeDesc = this.writers[count];
                        boolean copy = variablesBeansCopied.add(writeDesc.getVariableName());
                        if (copy) {
                            current = this.copyMethods.get(writeDesc.getType()).copy(current);
                        }
                        variableService.write(variableNumber, agentInstanceId, current);
                        writeDesc.getWriter().write(value, current);
                    }
                } else if (variableMetaData.getEventType() != null) {
                    EventBean eventBean = agentInstanceContext.getEventBeanTypedEventFactory().adapterForTypedBean(value, variableMetaData.getEventType());
                    variableService.write(variableNumber, agentInstanceId, eventBean);
                } else {
                    if (value != null && this.mustCoerce[count]) {
                        value = JavaClassHelper.coerceBoxed((Number)value, variableMetaData.getType());
                    }
                    variableService.write(variableNumber, agentInstanceId, value);
                }
                ++count;
                if (valuesWritten == null) continue;
                valuesWritten.put(assignment.getVariableName(), value);
            }
            variableService.commit();
        }
        catch (RuntimeException ex) {
            variableService.rollback();
            throw new EPException("Failed variable write: " + ex.getMessage(), ex);
        }
        finally {
            variableService.getReadWriteLock().writeLock().unlock();
        }
    }

    public Map<String, Object> iterate(VariableManagementService variableManagementService, int agentInstanceId) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int count = 0;
        for (VariableTriggerSetDesc assignment : this.assignments) {
            Object value;
            if (this.readersForGlobalVars[count] == null) {
                VariableReader reader = variableManagementService.getReader(this.variables[count].getDeploymentId(), assignment.getVariableName(), agentInstanceId);
                if (reader == null) continue;
                value = reader.getValue();
            } else {
                value = this.readersForGlobalVars[count].getValue();
            }
            if (value == null) {
                values.put(assignment.getVariableName(), null);
            } else if (this.writers[count] != null) {
                EventBean current = (EventBean)value;
                values.put(assignment.getVariableName(), this.writers[count].getGetter().get(current));
            } else if (value instanceof EventBean) {
                values.put(assignment.getVariableName(), ((EventBean)value).getUnderlying());
            } else {
                values.put(assignment.getVariableName(), value);
            }
            ++count;
        }
        return values;
    }
}

