/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableVersionThreadEntry;
import com.espertech.esper.common.internal.epl.variable.core.VariableVersionThreadLocal;
import com.espertech.esper.common.internal.epl.variable.core.VersionedValueList;

public class VariableReader {
    private final Variable variable;
    private final VariableVersionThreadLocal versionThreadLocal;
    private volatile VersionedValueList<Object> versionsHigh;
    private volatile VersionedValueList<Object> versionsLow;

    public VariableReader(Variable variable, VariableVersionThreadLocal versionThreadLocal, VersionedValueList<Object> versionsLow) {
        this.variable = variable;
        this.versionThreadLocal = versionThreadLocal;
        this.versionsLow = versionsLow;
        this.versionsHigh = null;
    }

    public void setVersionsHigh(VersionedValueList<Object> versionsHigh) {
        this.versionsHigh = versionsHigh;
    }

    public void setVersionsLow(VersionedValueList<Object> versionsLow) {
        this.versionsLow = versionsLow;
    }

    public Object getValue() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() != null && entry.getUncommitted().containsKey(this.variable.getVariableNumber())) {
            return entry.getUncommitted().get(this.variable.getVariableNumber()).getSecond();
        }
        int myVersion = entry.getVersion();
        VersionedValueList<Object> versions = this.versionsLow;
        if (myVersion >= 2147383647 && this.versionsHigh != null) {
            versions = this.versionsHigh;
        }
        return versions.getVersion(myVersion);
    }

    public VariableMetaData getMetaData() {
        return this.variable.getMetaData();
    }

    public VersionedValueList<Object> getVersionsLow() {
        return this.versionsLow;
    }

    public Variable getVariable() {
        return this.variable;
    }
}

