/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.virtualdw;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowKeyRange;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookup;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeIn;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlan;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinExecTableLookupStrategyVirtualDW
implements JoinExecTableLookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(JoinExecTableLookupStrategyVirtualDW.class);
    private final String namedWindowName;
    private final VirtualDataWindowLookup externalIndex;
    private final ExternalEvaluator[] evaluators;
    private final EventBean[] eventsPerStream;
    private final int lookupStream;

    public JoinExecTableLookupStrategyVirtualDW(String namedWindowName, VirtualDataWindowLookup externalIndex, TableLookupPlan tableLookupPlan) {
        QueryGraphValueEntryRange[] rangeKeys;
        this.namedWindowName = namedWindowName;
        this.externalIndex = externalIndex;
        this.lookupStream = tableLookupPlan.getLookupStream();
        ExprEvaluator[] hashKeys = tableLookupPlan.getVirtualDWHashEvals();
        if (hashKeys == null) {
            hashKeys = new ExprEvaluator[]{};
        }
        if ((rangeKeys = tableLookupPlan.getVirtualDWRangeEvals()) == null) {
            rangeKeys = new QueryGraphValueEntryRange[]{};
        }
        this.evaluators = new ExternalEvaluator[hashKeys.length + rangeKeys.length];
        this.eventsPerStream = new EventBean[this.lookupStream + 1];
        int count = 0;
        for (ExprEvaluator hashKey : hashKeys) {
            this.evaluators[count] = new ExternalEvaluatorHashRelOp(hashKey);
            ++count;
        }
        for (QueryGraphValueEntryRange rangeKey : rangeKeys) {
            if (rangeKey.getType().isRange()) {
                QueryGraphValueEntryRangeIn range = (QueryGraphValueEntryRangeIn)rangeKey;
                ExprEvaluator evaluatorStart = range.getExprStart();
                ExprEvaluator evaluatorEnd = range.getExprEnd();
                this.evaluators[count] = new ExternalEvaluatorBtreeRange(evaluatorStart, evaluatorEnd);
            } else {
                QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeKey;
                ExprEvaluator evaluator = relOp.getExpression();
                this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator);
            }
            ++count;
        }
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext context) {
        this.eventsPerStream[this.lookupStream] = theEvent;
        Object[] keys = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(this.eventsPerStream, context);
        }
        Set<EventBean> events = null;
        try {
            events = this.externalIndex.lookup(keys, this.eventsPerStream);
        }
        catch (RuntimeException ex) {
            log.warn("Exception encountered invoking virtual data window external index for window '" + this.namedWindowName + "': " + ex.getMessage(), (Throwable)ex);
        }
        return events;
    }

    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " external index " + this.externalIndex;
    }

    public LookupStrategyDesc getStrategyDesc() {
        return new LookupStrategyDesc(LookupStrategyType.VDW);
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.VDW;
    }

    private static class ExternalEvaluatorBtreeRange
    implements ExternalEvaluator {
        private final ExprEvaluator startEval;
        private final ExprEvaluator endEval;

        private ExternalEvaluatorBtreeRange(ExprEvaluator startEval, ExprEvaluator endEval) {
            this.startEval = startEval;
            this.endEval = endEval;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            Object start = this.startEval.evaluate(events, true, context);
            Object end = this.endEval.evaluate(events, true, context);
            return new VirtualDataWindowKeyRange(start, end);
        }
    }

    private static class ExternalEvaluatorHashRelOp
    implements ExternalEvaluator {
        private final ExprEvaluator hashKeysEval;

        private ExternalEvaluatorHashRelOp(ExprEvaluator hashKeysEval) {
            this.hashKeysEval = hashKeysEval;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            return this.hashKeysEval.evaluate(events, true, context);
        }
    }

    private static interface ExternalEvaluator {
        public Object evaluate(EventBean[] var1, ExprEvaluatorContext var2);
    }
}

