/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.virtualdw;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindow;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowEventStartIndex;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowEventStopIndex;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowEventStopWindow;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowKeyRange;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookup;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookupContext;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookupFieldDesc;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowLookupOp;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.exec.util.RangeIndexLookupValue;
import com.espertech.esper.common.internal.epl.join.exec.util.RangeIndexLookupValueRange;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlan;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.common.internal.epl.virtualdw.JoinExecTableLookupStrategyVirtualDW;
import com.espertech.esper.common.internal.epl.virtualdw.SubordTableLookupStrategyFactoryVDW;
import com.espertech.esper.common.internal.epl.virtualdw.SubordTableLookupStrategyVDW;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWEventTable;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWQueryPlanUtil;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDataWindowLookupContextSPI;
import com.espertech.esper.common.internal.filterspec.Range;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualDWViewImpl
extends ViewSupport
implements VirtualDWView {
    private static final EventTableOrganization TABLE_ORGANIZATION = new EventTableOrganization(null, false, false, 0, null, EventTableOrganizationType.VDW);
    private static final Logger log = LoggerFactory.getLogger(VirtualDWViewImpl.class);
    private final VirtualDWViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private final VirtualDataWindow dataExternal;
    private String lastAccessedByDeploymentId;
    private String lastAccessedByStatementName;
    private int lastAccessedByNum;

    public VirtualDWViewImpl(VirtualDWViewFactory factory, AgentInstanceContext agentInstanceContext, VirtualDataWindow dataExternal) {
        this.factory = factory;
        this.agentInstanceContext = agentInstanceContext;
        this.dataExternal = dataExternal;
    }

    @Override
    public VirtualDataWindow getVirtualDataWindow() {
        return this.dataExternal;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.dataExternal.update(newData, oldData);
    }

    @Override
    public EventType getEventType() {
        return this.factory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.dataExternal.iterator();
    }

    @Override
    public void destroy() {
        this.dataExternal.destroy();
    }

    @Override
    public SubordTableLookupStrategy getSubordinateLookupStrategy(SubordTableLookupStrategyFactoryVDW subordTableFactory, AgentInstanceContext agentInstanceContext) {
        VirtualDataWindowLookup index;
        Pair<IndexMultiKey, VirtualDWEventTable> tableVW = VirtualDWQueryPlanUtil.getSubordinateQueryDesc(false, subordTableFactory.getIndexHashedProps(), subordTableFactory.getIndexBtreeProps());
        VirtualDWEventTable noopTable = tableVW.getSecond();
        for (int i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            String opRange = subordTableFactory.getRangeEvals()[i].getType().getStringOp();
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(opRange);
            noopTable.getBtreeAccess().get(i).setOperator(op);
        }
        if (this.lastAccessedByStatementName == null || !this.lastAccessedByDeploymentId.equals(agentInstanceContext.getDeploymentId()) || !this.lastAccessedByStatementName.equals(agentInstanceContext.getStatementName())) {
            this.lastAccessedByNum = 0;
        }
        ++this.lastAccessedByNum;
        VirtualDataWindowLookupContextSPI context = new VirtualDataWindowLookupContextSPI(agentInstanceContext.getDeploymentId(), agentInstanceContext.getStatementName(), agentInstanceContext.getStatementId(), agentInstanceContext.getAnnotations(), false, this.factory.getNamedWindowName(), noopTable.getHashAccess(), noopTable.getBtreeAccess(), this.lastAccessedByNum);
        try {
            index = this.dataExternal.getLookup(context);
        }
        catch (Throwable t) {
            throw new EPException("Failed to obtain lookup for virtual data window '" + this.factory.getNamedWindowName() + "': " + t.getMessage(), t);
        }
        return new SubordTableLookupStrategyVDW(this.factory, subordTableFactory, index);
    }

    @Override
    public JoinExecTableLookupStrategy getJoinLookupStrategy(TableLookupPlan tableLookupPlan, AgentInstanceContext agentInstanceContext, EventTable[] eventTables, int lookupStream) {
        int i;
        VirtualDWEventTable noopTable = (VirtualDWEventTable)eventTables[0];
        for (i = 0; i < noopTable.getHashAccess().size(); ++i) {
            Class hashKeyType = tableLookupPlan.getVirtualDWHashTypes()[i];
            noopTable.getHashAccess().get(i).setLookupValueType(hashKeyType);
        }
        for (i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            QueryGraphValueEntryRange range = tableLookupPlan.getVirtualDWRangeEvals()[i];
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(range.getType().getStringOp());
            VirtualDataWindowLookupFieldDesc rangeField = noopTable.getBtreeAccess().get(i);
            rangeField.setOperator(op);
            rangeField.setLookupValueType(tableLookupPlan.getVirtualDWRangeTypes()[i]);
        }
        VirtualDataWindowLookup index = this.dataExternal.getLookup(new VirtualDataWindowLookupContext(agentInstanceContext.getDeploymentId(), agentInstanceContext.getStatementName(), agentInstanceContext.getStatementId(), agentInstanceContext.getAnnotations(), false, this.factory.getNamedWindowName(), noopTable.getHashAccess(), noopTable.getBtreeAccess()));
        this.checkIndex(index);
        return new JoinExecTableLookupStrategyVirtualDW(this.factory.getNamedWindowName(), index, tableLookupPlan);
    }

    private void checkIndex(VirtualDataWindowLookup index) {
        if (index == null) {
            throw new EPException("Exception obtaining index lookup from virtual data window, the implementation has returned a null index");
        }
    }

    @Override
    public Collection<EventBean> getFireAndForgetData(EventTable eventTable, Object[] keyValues, RangeIndexLookupValue[] rangeValues, Annotation[] annotations) {
        VirtualDWEventTable noopTable = (VirtualDWEventTable)eventTable;
        for (int i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            RangeIndexLookupValueRange range = (RangeIndexLookupValueRange)rangeValues[i];
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(range.getOperator().getStringOp());
            noopTable.getBtreeAccess().get(i).setOperator(op);
        }
        Object[] keys = new Object[keyValues.length + rangeValues.length];
        for (int i = 0; i < keyValues.length; ++i) {
            keys[i] = keyValues[i];
            noopTable.getHashAccess().get(i).setLookupValueType(keyValues[i] == null ? null : keyValues[i].getClass());
        }
        int offset = keyValues.length;
        for (int j = 0; j < rangeValues.length; ++j) {
            Object rangeValue = rangeValues[j].getValue();
            if (rangeValue instanceof Range) {
                Range range = (Range)rangeValue;
                keys[j + offset] = new VirtualDataWindowKeyRange(range.getLowEndpoint(), range.getHighEndpoint());
                noopTable.getBtreeAccess().get(j).setLookupValueType(range.getLowEndpoint() == null ? null : range.getLowEndpoint().getClass());
                continue;
            }
            keys[j + offset] = rangeValue;
            noopTable.getBtreeAccess().get(j).setLookupValueType(rangeValue == null ? null : rangeValue.getClass());
        }
        String namedWindowName = this.factory.getNamedWindowName();
        VirtualDataWindowLookup index = this.dataExternal.getLookup(new VirtualDataWindowLookupContext(null, null, -1, annotations, true, namedWindowName, noopTable.getHashAccess(), noopTable.getBtreeAccess()));
        this.checkIndex(index);
        if (index == null) {
            throw new EPException("Exception obtaining index from virtual data window '" + namedWindowName + "'");
        }
        Set<EventBean> events = null;
        try {
            events = index.lookup(keys, null);
        }
        catch (RuntimeException ex) {
            log.warn("Exception encountered invoking virtual data window external index for window '" + namedWindowName + "': " + ex.getMessage(), (Throwable)ex);
        }
        return events;
    }

    @Override
    public void handleStartIndex(String indexName, QueryPlanIndexItem explicitIndexDesc) {
        try {
            ArrayList<VirtualDataWindowEventStartIndex.VDWCreateIndexField> fields = new ArrayList<VirtualDataWindowEventStartIndex.VDWCreateIndexField>();
            for (String hash : explicitIndexDesc.getHashProps()) {
                fields.add(new VirtualDataWindowEventStartIndex.VDWCreateIndexField(hash, "hash"));
            }
            for (String range : explicitIndexDesc.getRangeProps()) {
                fields.add(new VirtualDataWindowEventStartIndex.VDWCreateIndexField(range, "btree"));
            }
            VirtualDataWindowEventStartIndex create = new VirtualDataWindowEventStartIndex(this.factory.getNamedWindowName(), indexName, fields, explicitIndexDesc.isUnique());
            this.dataExternal.handleEvent(create);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle start-index event for window '" + this.factory.getNamedWindowName() + "': " + ex.getMessage();
            log.warn(message, (Throwable)ex);
            throw new EPException(message, ex);
        }
    }

    @Override
    public void handleStopIndex(String indexName, QueryPlanIndexItem explicitIndexDesc) {
        try {
            VirtualDataWindowEventStopIndex theEvent = new VirtualDataWindowEventStopIndex(this.factory.getNamedWindowName(), indexName);
            this.dataExternal.handleEvent(theEvent);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle stop-index event for window '" + this.factory.getNamedWindowName() + "': " + ex.getMessage();
            log.warn(message, (Throwable)ex);
        }
    }

    @Override
    public void handleDestroy(int agentInstanceId) {
        try {
            VirtualDataWindowEventStopWindow theEvent = new VirtualDataWindowEventStopWindow(this.factory.getNamedWindowName(), agentInstanceId);
            this.dataExternal.handleEvent(theEvent);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle stop-window event for window '" + this.factory.getNamedWindowName() + "': " + ex.getMessage();
            log.warn(message, (Throwable)ex);
        }
    }
}

