/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventSender;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;

public class EventSenderObjectArray
implements EventSender {
    private final EPRuntimeEventProcessWrapped runtimeEventSender;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final ObjectArrayEventType objectArrayEventType;
    private final ThreadingCommon threadingService;

    public EventSenderObjectArray(EPRuntimeEventProcessWrapped runtimeEventSender, ObjectArrayEventType objectArrayEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.objectArrayEventType = objectArrayEventType;
        this.threadingService = threadingService;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public void sendEvent(Object theEvent) {
        if (!theEvent.getClass().isArray()) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected Object[]");
        }
        Object[] arr = (Object[])theEvent;
        ObjectArrayBackedEventBean objectArrayEvent = this.eventBeanTypedEventFactory.adapterForTypedObjectArray(arr, this.objectArrayEventType);
        if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(objectArrayEvent, this.runtimeEventSender);
        } else {
            this.runtimeEventSender.processWrappedEvent(objectArrayEvent);
        }
    }

    @Override
    public void routeEvent(Object theEvent) {
        if (!theEvent.getClass().isArray()) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected Object[]");
        }
        Object[] arr = (Object[])theEvent;
        ObjectArrayBackedEventBean objectArrayEvent = this.eventBeanTypedEventFactory.adapterForTypedObjectArray(arr, this.objectArrayEventType);
        this.runtimeEventSender.routeEventBean(objectArrayEvent);
    }
}

