/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;

public class ObjectArrayPOJOEntryPropertyGetter
extends BaseNativePropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final BeanEventPropertyGetter entryGetter;

    public ObjectArrayPOJOEntryPropertyGetter(int propertyIndex, BeanEventPropertyGetter entryGetter, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory, Class returnType, Class nestedComponentType) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, returnType, nestedComponentType);
        this.propertyIndex = propertyIndex;
        this.entryGetter = entryGetter;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        Object value = array[this.propertyIndex];
        if (value == null) {
            return null;
        }
        if (value instanceof EventBean) {
            return this.entryGetter.get((EventBean)value);
        }
        return this.entryGetter.getBeanProp(value);
    }

    private CodegenMethod getObjectArrayCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(Object[].class, "array").getBlock().declareVar(Object.class, "value", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.propertyIndex))).ifRefNullReturnNull("value").ifInstanceOf("value", EventBean.class).blockReturn(this.entryGetter.eventBeanGetCodegen(CodegenExpressionBuilder.castRef(EventBean.class, "value"), codegenMethodScope, codegenClassScope)).methodReturn(this.entryGetter.underlyingGetCodegen(CodegenExpressionBuilder.cast(this.entryGetter.getTargetType(), (CodegenExpression)CodegenExpressionBuilder.ref("value")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(eventBean);
        return this.isExistsProperty(array);
    }

    private boolean isExistsProperty(Object[] array) {
        Object value = array[this.propertyIndex];
        if (value == null) {
            return false;
        }
        if (value instanceof EventBean) {
            return this.entryGetter.isExistsProperty((EventBean)value);
        }
        return this.entryGetter.isBeanExistsProperty(value);
    }

    private CodegenMethod isExistsPropertyCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Boolean.TYPE, this.getClass(), (CodegenScope)codegenClassScope).addParam(Object[].class, "array").getBlock().declareVar(Object.class, "value", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(this.propertyIndex))).ifRefNullReturnFalse("value").ifInstanceOf("value", EventBean.class).blockReturn(this.entryGetter.eventBeanExistsCodegen(CodegenExpressionBuilder.castRef(EventBean.class, "value"), codegenMethodScope, codegenClassScope)).methodReturn(this.entryGetter.underlyingExistsCodegen(CodegenExpressionBuilder.cast(this.entryGetter.getTargetType(), (CodegenExpression)CodegenExpressionBuilder.ref("value")), codegenMethodScope, codegenClassScope));
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getObjectArrayCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.isExistsPropertyCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public Class getTargetType() {
        return Object[].class;
    }

    @Override
    public Class getBeanPropType() {
        return Object.class;
    }
}

