/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.util.AccessorStyle;
import com.espertech.esper.common.client.util.PropertyResolutionStyle;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStemBuilder;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanEventTypeStemService {
    private final Map<Class, List<String>> publicClassToTypeNames;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final PropertyResolutionStyle defaultPropertyResolutionStyle;
    private final AccessorStyle defaultAccessorStyle;
    private final Map<Class, BeanEventTypeStem> stems = new HashMap<Class, BeanEventTypeStem>();

    public BeanEventTypeStemService(Map<Class, List<String>> publicClassToTypeNames, EventBeanTypedEventFactory eventBeanTypedEventFactory, PropertyResolutionStyle defaultPropertyResolutionStyle, AccessorStyle defaultAccessorStyle) {
        this.publicClassToTypeNames = publicClassToTypeNames;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.defaultPropertyResolutionStyle = defaultPropertyResolutionStyle;
        this.defaultAccessorStyle = defaultAccessorStyle;
    }

    public EventBeanTypedEventFactory getEventBeanTypedEventFactory() {
        return this.eventBeanTypedEventFactory;
    }

    public Map<Class, List<String>> getPublicClassToTypeNames() {
        return this.publicClassToTypeNames;
    }

    public BeanEventTypeStem getCreateStem(Class clazz, ConfigurationCommonEventTypeBean optionalConfiguration) {
        BeanEventTypeStem stem = this.stems.get(clazz);
        if (stem != null) {
            return stem;
        }
        if (optionalConfiguration == null && this.defaultAccessorStyle != AccessorStyle.JAVABEAN) {
            optionalConfiguration = new ConfigurationCommonEventTypeBean();
            optionalConfiguration.setAccessorStyle(this.defaultAccessorStyle);
        }
        stem = new BeanEventTypeStemBuilder(optionalConfiguration, this.defaultPropertyResolutionStyle).make(clazz);
        this.stems.put(clazz, stem);
        return stem;
    }
}

