/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.internal.event.core.EventPropertyType;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PropertyStem {
    private String propertyName;
    private Method readMethod;
    private Field accessorField;
    private EventPropertyType propertyType;

    public PropertyStem(String propertyName, Method readMethod, EventPropertyType propertyType) {
        this.propertyName = propertyName;
        this.readMethod = readMethod;
        this.propertyType = propertyType;
    }

    public PropertyStem(String propertyName, Field accessorField, EventPropertyType propertyType) {
        this.propertyName = propertyName;
        this.accessorField = accessorField;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EventPropertyType getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Field getAccessorField() {
        return this.accessorField;
    }

    public Class getReturnType() {
        if (this.readMethod != null) {
            return this.readMethod.getReturnType();
        }
        return this.accessorField.getType();
    }

    public GenericPropertyDesc getReturnTypeGeneric() {
        if (this.readMethod != null) {
            return new GenericPropertyDesc(this.readMethod.getReturnType(), JavaClassHelper.getGenericReturnType(this.readMethod, true));
        }
        return new GenericPropertyDesc(this.accessorField.getType(), JavaClassHelper.getGenericFieldType(this.accessorField, true));
    }

    public String toString() {
        return "propertyName=" + this.propertyName + " readMethod=" + this.readMethod + " accessorField=" + this.accessorField + " propertyType=" + (Object)((Object)this.propertyType);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PropertyStem)) {
            return false;
        }
        PropertyStem otherDesc = (PropertyStem)other;
        if (!otherDesc.propertyName.equals(this.propertyName)) {
            return false;
        }
        if (otherDesc.readMethod == null && this.readMethod != null || otherDesc.readMethod != null && this.readMethod == null) {
            return false;
        }
        if (otherDesc.readMethod != null && this.readMethod != null && !otherDesc.readMethod.equals(this.readMethod)) {
            return false;
        }
        if (otherDesc.accessorField == null && this.accessorField != null || otherDesc.accessorField != null && this.accessorField == null) {
            return false;
        }
        if (otherDesc.accessorField != null && this.accessorField != null && !otherDesc.accessorField.equals(this.accessorField)) {
            return false;
        }
        return otherDesc.propertyType == this.propertyType;
    }

    public int hashCode() {
        return this.propertyName.hashCode();
    }
}

