/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArrayMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final Method method;
    private final int index;

    public ArrayMethodPropertyGetter(Method method, int index, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, method.getReturnType().getComponentType(), null);
        this.index = index;
        this.method = method;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.index);
    }

    private Object getBeanPropInternal(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.method.invoke(object, (Object[])null);
            return CollectionUtil.arrayValueAtIndex(value, index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    private boolean getBeanPropInternalExists(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.method.invoke(object, (Object[])null);
            return CollectionUtil.arrayExistsAtIndex(value, index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    protected static CodegenMethod getBeanPropInternalCode(CodegenMethodScope codegenMethodScope, Method method, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(JavaClassHelper.getBoxedType(method.getReturnType().getComponentType()), ArrayMethodPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(method.getDeclaringClass(), "obj").addParam(Integer.TYPE, "index").getBlock().declareVar(method.getReturnType(), "array", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("obj"), method.getName(), new CodegenExpression[0])).ifRefNullReturnNull("array").ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("index")), null).methodReturn(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.ref("index")));
    }

    protected static CodegenMethod getBeanPropInternalExistsCode(CodegenMethodScope codegenMethodScope, Method method, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Boolean.TYPE, ArrayMethodPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(method.getDeclaringClass(), "obj").addParam(Integer.TYPE, "index").getBlock().declareVar(method.getReturnType(), "array", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("obj"), method.getName(), new CodegenExpression[0])).ifRefNullReturnFalse("array").ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("index")), false).methodReturn(CodegenExpressionBuilder.constantTrue());
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ArrayMethodPropertyGetter  method=" + this.method.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        return this.getBeanPropInternalExists(underlying, this.index);
    }

    @Override
    public Class getBeanPropType() {
        return this.method.getReturnType().getComponentType();
    }

    @Override
    public Class getTargetType() {
        return this.method.getDeclaringClass();
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(ArrayMethodPropertyGetter.getBeanPropInternalCode(codegenMethodScope, this.method, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(ArrayMethodPropertyGetter.getBeanPropInternalExistsCode(codegenMethodScope, this.method, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(ArrayMethodPropertyGetter.getBeanPropInternalCode(codegenMethodScope, this.method, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }
}

