/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Iterator;

public abstract class BaseNativePropertyGetter
implements EventPropertyGetterSPI {
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final BeanEventTypeFactory beanEventTypeFactory;
    private volatile BeanEventType fragmentEventType;
    private final Class fragmentClassType;
    private boolean isFragmentable;
    private final boolean isArray;
    private final boolean isIterable;

    public abstract Class getTargetType();

    public abstract Class getBeanPropType();

    public static Object toFragmentArray(Object[] object, BeanEventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        EventBean[] events = new EventBean[object.length];
        int countFilled = 0;
        for (int i = 0; i < object.length; ++i) {
            Object element = Array.get(object, i);
            if (element == null) continue;
            events[countFilled] = eventBeanTypedEventFactory.adapterForTypedBean(element, fragmentEventType);
            ++countFilled;
        }
        if (countFilled == object.length) {
            return events;
        }
        if (countFilled == 0) {
            return new EventBean[0];
        }
        EventBean[] returnVal = new EventBean[countFilled];
        System.arraycopy(events, 0, returnVal, 0, countFilled);
        return returnVal;
    }

    public static Object getFragmentDynamic(Object object, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        if (object == null) {
            return null;
        }
        BeanEventType fragmentEventType = null;
        boolean isArray = false;
        if (object.getClass().isArray()) {
            if (JavaClassHelper.isFragmentableType(object.getClass().getComponentType())) {
                isArray = true;
                fragmentEventType = beanEventTypeFactory.getCreateBeanType(object.getClass().getComponentType());
            }
        } else if (JavaClassHelper.isFragmentableType(object.getClass())) {
            fragmentEventType = beanEventTypeFactory.getCreateBeanType(object.getClass());
        }
        if (fragmentEventType == null) {
            return null;
        }
        if (isArray) {
            int len = Array.getLength(object);
            EventBean[] events = new EventBean[len];
            int countFilled = 0;
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(object, i);
                if (element == null) continue;
                events[countFilled] = eventBeanTypedEventFactory.adapterForTypedBean(element, fragmentEventType);
                ++countFilled;
            }
            if (countFilled == len) {
                return events;
            }
            if (countFilled == 0) {
                return new EventBean[0];
            }
            EventBean[] returnVal = new EventBean[countFilled];
            System.arraycopy(events, 0, returnVal, 0, countFilled);
            return returnVal;
        }
        return eventBeanTypedEventFactory.adapterForTypedBean(object, fragmentEventType);
    }

    public static Object toFragmentIterable(Object object, BeanEventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        if (!(object instanceof Iterable)) {
            return null;
        }
        Iterator iterator = ((Iterable)object).iterator();
        if (!iterator.hasNext()) {
            return new EventBean[0];
        }
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) continue;
            events.add(eventBeanTypedEventFactory.adapterForTypedBean(next, fragmentEventType));
        }
        return events.toArray(new EventBean[events.size()]);
    }

    public BaseNativePropertyGetter(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory, Class returnType, Class genericType) {
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.beanEventTypeFactory = beanEventTypeFactory;
        if (returnType.isArray()) {
            this.fragmentClassType = returnType.getComponentType();
            this.isArray = true;
            this.isIterable = false;
        } else if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            this.fragmentClassType = genericType;
            this.isArray = false;
            this.isIterable = true;
        } else {
            this.fragmentClassType = returnType;
            this.isArray = false;
            this.isIterable = false;
        }
        this.isFragmentable = true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return null;
        }
        Object object = this.get(eventBean);
        if (object == null) {
            return null;
        }
        if (this.isArray) {
            return BaseNativePropertyGetter.toFragmentArray((Object[])object, this.fragmentEventType, this.eventBeanTypedEventFactory);
        }
        if (this.isIterable) {
            return BaseNativePropertyGetter.toFragmentIterable(object, this.fragmentEventType, this.eventBeanTypedEventFactory);
        }
        return this.eventBeanTypedEventFactory.adapterForTypedBean(object, this.fragmentEventType);
    }

    private CodegenMethod getFragmentCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenExpressionField msvc = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField mtype = codegenClassScope.addFieldUnshared(false, BeanEventType.class, CodegenExpressionBuilder.cast(BeanEventType.class, EventTypeUtility.resolveTypeCodegen(this.fragmentEventType, EPStatementInitServices.REF)));
        CodegenBlock block = codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(this.getTargetType(), "underlying").getBlock().declareVar(this.getBeanPropType(), "object", this.underlyingGetCodegen(CodegenExpressionBuilder.ref("underlying"), codegenMethodScope, codegenClassScope)).ifRefNullReturnNull("object");
        if (this.isArray) {
            return block.methodReturn(CodegenExpressionBuilder.staticMethod(BaseNativePropertyGetter.class, "toFragmentArray", CodegenExpressionBuilder.cast(Object[].class, (CodegenExpression)CodegenExpressionBuilder.ref("object")), mtype, msvc));
        }
        if (this.isIterable) {
            return block.methodReturn(CodegenExpressionBuilder.staticMethod(BaseNativePropertyGetter.class, "toFragmentIterable", CodegenExpressionBuilder.ref("object"), mtype, msvc));
        }
        return block.methodReturn(CodegenExpressionBuilder.exprDotMethod(msvc, "adapterForTypedBean", CodegenExpressionBuilder.ref("object"), mtype));
    }

    @Override
    public final CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public final CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        this.determineFragmentable();
        if (!this.isFragmentable) {
            return CodegenExpressionBuilder.constantNull();
        }
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    private void determineFragmentable() {
        if (this.fragmentEventType == null) {
            if (JavaClassHelper.isFragmentableType(this.fragmentClassType)) {
                this.fragmentEventType = this.beanEventTypeFactory.getCreateBeanType(this.fragmentClassType);
            } else {
                this.isFragmentable = false;
            }
        }
    }
}

