/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptor;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.getter.DynamicPropertyGetterBase;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class DynamicMappedPropertyGetter
extends DynamicPropertyGetterBase {
    private final String getterMethodName;
    private final Object[] parameters;

    public DynamicMappedPropertyGetter(String fieldName, String key, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.parameters = new Object[]{key};
    }

    @Override
    public Method determineMethod(Class clazz) throws PropertyAccessException {
        return DynamicMappedPropertyGetter.dynamicMapperPropertyDetermineMethod(clazz, this.getterMethodName);
    }

    @Override
    protected CodegenExpression determineMethodCodegen(CodegenExpressionRef clazz, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetter.class, "dynamicMapperPropertyDetermineMethod", clazz, CodegenExpressionBuilder.constant(this.getterMethodName));
    }

    @Override
    protected Object call(DynamicPropertyDescriptor descriptor, Object underlying) {
        return DynamicMappedPropertyGetter.dynamicMappedPropertyGet(descriptor, underlying, this.parameters);
    }

    @Override
    protected CodegenExpression callCodegen(CodegenExpressionRef desc, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField params = codegenClassScope.addFieldUnshared(true, Object[].class, CodegenExpressionBuilder.constant(this.parameters));
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetter.class, "dynamicMappedPropertyGet", desc, object, params);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(Boolean.TYPE, DynamicPropertyGetterBase.class, (CodegenScope)codegenClassScope).addParam(Object.class, "object");
        method.getBlock().declareVar(DynamicPropertyDescriptor.class, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetter.class, "dynamicMappedPropertyExists", CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.constant(this.parameters[0])));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        DynamicPropertyDescriptor desc = DynamicMappedPropertyGetter.getPopulateCache(this.cache, this, eventBean.getUnderlying(), this.eventBeanTypedEventFactory);
        if (desc.getMethod() == null) {
            return false;
        }
        return DynamicMappedPropertyGetter.dynamicMappedPropertyExists(desc, eventBean.getUnderlying(), (String)this.parameters[0]);
    }

    public static Method dynamicMapperPropertyDetermineMethod(Class clazz, String getterMethodName) throws PropertyAccessException {
        try {
            return clazz.getMethod(getterMethodName, String.class);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (method.getReturnType() != Map.class) {
                return null;
            }
            return method;
        }
    }

    public static Object dynamicMappedPropertyGet(DynamicPropertyDescriptor descriptor, Object underlying, Object[] parameters) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, parameters);
            }
            Object result = descriptor.getMethod().invoke(underlying, null);
            if (result instanceof Map && result != null) {
                Map map = (Map)result;
                return map.get(parameters[0]);
            }
            return null;
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }

    public static boolean dynamicMappedPropertyExists(DynamicPropertyDescriptor descriptor, Object underlying, String key) {
        try {
            if (descriptor.isHasParameters()) {
                return true;
            }
            Object result = descriptor.getMethod().invoke(underlying, null);
            if (result instanceof Map && result != null) {
                Map map = (Map)result;
                return map.containsKey(key);
            }
            return false;
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }
}

