/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptor;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class DynamicPropertyGetterBase
implements BeanEventPropertyGetter {
    protected final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    protected final BeanEventTypeFactory beanEventTypeFactory;
    protected final CopyOnWriteArrayList<DynamicPropertyDescriptor> cache;
    protected final CodegenFieldSharable sharableCode = new CodegenFieldSharable(){

        @Override
        public Class type() {
            return CopyOnWriteArrayList.class;
        }

        @Override
        public CodegenExpression initCtorScoped() {
            return CodegenExpressionBuilder.newInstance(CopyOnWriteArrayList.class, new CodegenExpression[0]);
        }
    };

    protected abstract Method determineMethod(Class var1);

    protected abstract CodegenExpression determineMethodCodegen(CodegenExpressionRef var1, CodegenMethodScope var2, CodegenClassScope var3);

    protected abstract Object call(DynamicPropertyDescriptor var1, Object var2);

    protected abstract CodegenExpression callCodegen(CodegenExpressionRef var1, CodegenExpressionRef var2, CodegenMethodScope var3, CodegenClassScope var4);

    public static Object cacheAndCall(CopyOnWriteArrayList<DynamicPropertyDescriptor> cache, DynamicPropertyGetterBase getter, Object object, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        DynamicPropertyDescriptor desc = DynamicPropertyGetterBase.getPopulateCache(cache, getter, object, eventBeanTypedEventFactory);
        if (desc.getMethod() == null) {
            return null;
        }
        return getter.call(desc, object);
    }

    private CodegenExpression cacheAndCallCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(Object.class, DynamicPropertyGetterBase.class, (CodegenScope)codegenClassScope).addParam(Object.class, "object");
        method.getBlock().declareVar(DynamicPropertyDescriptor.class, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(this.callCodegen(CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), method, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    public static boolean cacheAndExists(CopyOnWriteArrayList<DynamicPropertyDescriptor> cache, DynamicPropertyGetterBase getter, Object object, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        DynamicPropertyDescriptor desc = DynamicPropertyGetterBase.getPopulateCache(cache, getter, object, eventBeanTypedEventFactory);
        return desc.getMethod() != null;
    }

    protected CodegenExpression cacheAndExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(Boolean.TYPE, DynamicPropertyGetterBase.class, (CodegenScope)codegenClassScope).addParam(Object.class, "object");
        method.getBlock().declareVar(DynamicPropertyDescriptor.class, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.constant(true));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    public DynamicPropertyGetterBase(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.cache = new CopyOnWriteArrayList();
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return DynamicPropertyGetterBase.cacheAndCall(this.cache, this, object, this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    @Override
    public Class getTargetType() {
        return Object.class;
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return DynamicPropertyGetterBase.cacheAndExists(this.cache, this, object, this.eventBeanTypedEventFactory);
    }

    @Override
    public final Object get(EventBean event) throws PropertyAccessException {
        return DynamicPropertyGetterBase.cacheAndCall(this.cache, this, event.getUnderlying(), this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    @Override
    public Class getBeanPropType() {
        return Object.class;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.cacheAndCallCodegen(underlyingExpression, codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        Object result = this.get(eventBean);
        return BaseNativePropertyGetter.getFragmentDynamic(result, this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DynamicPropertyDescriptor getPopulateCache(CopyOnWriteArrayList<DynamicPropertyDescriptor> cache, DynamicPropertyGetterBase dynamicPropertyGetterBase, Object obj, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        DynamicPropertyDescriptor desc = DynamicPropertyGetterBase.dynamicPropertyCacheCheck(cache, obj);
        if (desc != null) {
            return desc;
        }
        DynamicPropertyGetterBase dynamicPropertyGetterBase2 = dynamicPropertyGetterBase;
        synchronized (dynamicPropertyGetterBase2) {
            desc = DynamicPropertyGetterBase.dynamicPropertyCacheCheck(cache, obj);
            if (desc != null) {
                return desc;
            }
            Method method = dynamicPropertyGetterBase.determineMethod(obj.getClass());
            desc = DynamicPropertyGetterBase.dynamicPropertyCacheAdd(obj.getClass(), method, cache);
            return desc;
        }
    }

    protected CodegenExpression getPopulateCacheCodegen(CodegenExpression memberCache, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenMethod method = parent.makeChild(DynamicPropertyDescriptor.class, DynamicPropertyGetterBase.class, (CodegenScope)codegenClassScope).addParam(CopyOnWriteArrayList.class, "cache").addParam(Object.class, "obj");
        method.getBlock().declareVar(DynamicPropertyDescriptor.class, "desc", CodegenExpressionBuilder.staticMethod(DynamicPropertyGetterBase.class, "dynamicPropertyCacheCheck", CodegenExpressionBuilder.ref("cache"), CodegenExpressionBuilder.ref("obj"))).ifRefNotNull("desc").blockReturn(CodegenExpressionBuilder.ref("desc")).declareVar(Class.class, "clazz", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("obj"), "getClass", new CodegenExpression[0])).declareVar(Method.class, "method", this.determineMethodCodegen(CodegenExpressionBuilder.ref("clazz"), method, codegenClassScope)).assignRef("desc", CodegenExpressionBuilder.staticMethod(DynamicPropertyGetterBase.class, "dynamicPropertyCacheAdd", CodegenExpressionBuilder.ref("clazz"), CodegenExpressionBuilder.ref("method"), CodegenExpressionBuilder.ref("cache"))).methodReturn(CodegenExpressionBuilder.ref("desc"));
        return CodegenExpressionBuilder.localMethod(method, memberCache, object);
    }

    public static DynamicPropertyDescriptor dynamicPropertyCacheCheck(CopyOnWriteArrayList<DynamicPropertyDescriptor> cache, Object obj) {
        Class<?> target = obj.getClass();
        for (DynamicPropertyDescriptor desc : cache) {
            if (desc.getClazz() != target) continue;
            return desc;
        }
        return null;
    }

    public static DynamicPropertyDescriptor dynamicPropertyCacheAdd(Class clazz, Method method, CopyOnWriteArrayList<DynamicPropertyDescriptor> cache) {
        DynamicPropertyDescriptor propertyDescriptor = method == null ? new DynamicPropertyDescriptor(clazz, null, false) : new DynamicPropertyDescriptor(clazz, method, method.getParameterTypes().length > 0);
        cache.add(propertyDescriptor);
        return propertyDescriptor;
    }

    public static PropertyAccessException handleException(DynamicPropertyDescriptor descriptor, Object underlying, Throwable t) {
        if (t instanceof ClassCastException) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, (ClassCastException)t);
        }
        if (t instanceof InvocationTargetException) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), (InvocationTargetException)t);
        }
        if (t instanceof IllegalArgumentException) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), (IllegalArgumentException)t);
        }
        if (t instanceof IllegalAccessException) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), (IllegalAccessException)t);
        }
        throw PropertyUtility.getGeneralException(descriptor.getMethod(), t);
    }
}

