/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KeyedMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndMapped,
EventPropertyGetterAndIndexed {
    private final Method method;
    private final Object key;

    public KeyedMethodPropertyGetter(Method method, Object key, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, method.getReturnType(), null);
        this.key = key;
        this.method = method;
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), mapKey);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.key);
    }

    private Object getBeanPropInternal(Object object, Object key) throws PropertyAccessException {
        try {
            return this.method.invoke(object, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    protected static CodegenMethod getBeanPropInternalCodegen(CodegenMethodScope codegenMethodScope, Class targetType, Method method, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(method.getReturnType(), KeyedMethodPropertyGetter.class, (CodegenScope)codegenClassScope).addParam(targetType, "object").addParam(method.getParameterTypes()[0], "key").getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("object"), method.getName(), CodegenExpressionBuilder.ref("key")));
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "KeyedMethodPropertyGetter  method=" + this.method.toString() + " key=" + this.key;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Class getBeanPropType() {
        return this.method.getReturnType();
    }

    @Override
    public Class getTargetType() {
        return this.method.getDeclaringClass();
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(KeyedMethodPropertyGetter.getBeanPropInternalCodegen(codegenMethodScope, this.getTargetType(), this.method, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanGetMappedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(KeyedMethodPropertyGetter.getBeanPropInternalCodegen(codegenMethodScope, this.getTargetType(), this.method, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(KeyedMethodPropertyGetter.getBeanPropInternalCodegen(codegenMethodScope, this.getTargetType(), this.method, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }
}

