/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.instantiator;

import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByCtor;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByNewInstanceReflection;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForgeByReflection;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInstantiatorFactory {
    private static final Logger log = LoggerFactory.getLogger(BeanInstantiatorFactory.class);
    public static final Constructor<Object> SUN_JVM_OBJECT_CONSTRUCTOR;

    public static BeanInstantiatorForge makeInstantiator(BeanEventType beanEventType, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        if (beanEventType.getFactoryMethodName() != null) {
            return BeanInstantiatorFactory.resolveFactoryMethod(beanEventType, classpathImportService);
        }
        try {
            classpathImportService.resolveCtor(beanEventType.getUnderlyingType(), new Class[0]);
            return new BeanInstantiatorForgeByNewInstanceReflection(beanEventType.getUnderlyingType());
        }
        catch (ClasspathImportException ex) {
            ClasspathImportException ctorNotFoundEx = ex;
            if (SUN_JVM_OBJECT_CONSTRUCTOR != null) {
                Class underlyingType = beanEventType.getUnderlyingType();
                return new BeanInstantiatorForgeByCtor(underlyingType);
            }
            throw new EventBeanManufactureException("Failed to find no-arg constructor and no factory method has been configured and cannot use Sun-JVM reflection to instantiate object of type " + beanEventType.getUnderlyingType().getName(), ctorNotFoundEx);
        }
    }

    private static BeanInstantiatorForge resolveFactoryMethod(BeanEventType beanEventType, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        String factoryMethodName = beanEventType.getFactoryMethodName();
        int lastDotIndex = factoryMethodName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            try {
                Method method = classpathImportService.resolveMethod(beanEventType.getUnderlyingType(), factoryMethodName, new Class[0], new boolean[0], new boolean[0]);
                return new BeanInstantiatorForgeByReflection(method);
            }
            catch (ClasspathImportException e) {
                String message = "Failed to resolve configured factory method '" + factoryMethodName + "' expected to exist for class '" + beanEventType.getUnderlyingType() + "'";
                log.info(message, (Throwable)e);
                throw new EventBeanManufactureException(message, e);
            }
        }
        String className = factoryMethodName.substring(0, lastDotIndex);
        String methodName = factoryMethodName.substring(lastDotIndex + 1);
        try {
            Method method = classpathImportService.resolveMethodOverloadChecked(className, methodName, new Class[0], new boolean[0], new boolean[0]);
            return new BeanInstantiatorForgeByReflection(method);
        }
        catch (ClasspathImportException e) {
            String message = "Failed to resolve configured factory method '" + methodName + "' expected to exist for class '" + className + "'";
            log.info(message, (Throwable)e);
            throw new EventBeanManufactureException(message, e);
        }
    }

    static {
        Constructor c = null;
        Class<?> reflectionFactoryClass = null;
        try {
            c = Object.class.getConstructor(null);
            reflectionFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("sun.reflect.ReflectionFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SUN_JVM_OBJECT_CONSTRUCTOR = c != null && reflectionFactoryClass != null ? c : null;
    }
}

