/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorFactory;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerBean;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterFactory;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBeanManufacturerBeanForge
implements EventBeanManufacturerForge {
    private static final Logger log = LoggerFactory.getLogger(EventBeanManufacturerBeanForge.class);
    private final BeanInstantiatorForge beanInstantiator;
    private final BeanEventType beanEventType;
    private final WriteablePropertyDescriptor[] properties;
    private final ClasspathImportService classpathImportService;
    private final Method[] writeMethodsReflection;
    private final boolean hasPrimitiveTypes;
    private final boolean[] primitiveType;

    public EventBeanManufacturerBeanForge(BeanEventType beanEventType, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        this.beanEventType = beanEventType;
        this.properties = properties;
        this.classpathImportService = classpathImportService;
        this.beanInstantiator = BeanInstantiatorFactory.makeInstantiator(beanEventType, classpathImportService);
        this.writeMethodsReflection = new Method[properties.length];
        boolean primitiveTypeCheck = false;
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.writeMethodsReflection[i] = properties[i].getWriteMethod();
            this.primitiveType[i] = properties[i].getType().isPrimitive();
            primitiveTypeCheck |= this.primitiveType[i];
        }
        this.hasPrimitiveTypes = primitiveTypeCheck;
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventBeanTypedEventFactory eventBeanTypedEventFactory) throws EventBeanManufactureException {
        return new EventBeanManufacturerBean(this.beanEventType, eventBeanTypedEventFactory, this.properties, this.classpathImportService);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod init = codegenClassScope.getPackageScope().getInitMethod();
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField beanType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(this.beanEventType, EPStatementInitServices.REF));
        CodegenExpressionNewAnonymousClass manufacturer = CodegenExpressionBuilder.newAnonymousClass(init.getBlock(), EventBeanManufacturer.class);
        CodegenMethod makeUndMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), codegenClassScope).addParam(Object[].class, "properties");
        manufacturer.addMethod("makeUnderlying", makeUndMethod);
        this.makeUnderlyingCodegen(makeUndMethod, codegenClassScope);
        CodegenMethod makeMethod = CodegenMethod.makeParentNode(EventBean.class, this.getClass(), codegenClassScope).addParam(Object[].class, "properties");
        manufacturer.addMethod("make", makeMethod);
        makeMethod.getBlock().declareVar(Object.class, "und", (CodegenExpression)CodegenExpressionBuilder.localMethod(makeUndMethod, CodegenExpressionBuilder.ref("properties"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedBean", CodegenExpressionBuilder.ref("und"), beanType));
        return codegenClassScope.addFieldUnshared(true, EventBeanManufacturer.class, manufacturer);
    }

    private void makeUnderlyingCodegen(CodegenMethod method, CodegenClassScope codegenClassScope) {
        method.getBlock().declareVar(this.beanEventType.getUnderlyingType(), "und", CodegenExpressionBuilder.cast(this.beanEventType.getUnderlyingType(), this.beanInstantiator.make(method, codegenClassScope))).declareVar(Object.class, "value", CodegenExpressionBuilder.constantNull());
        for (int i = 0; i < this.writeMethodsReflection.length; ++i) {
            CodegenExpression value;
            method.getBlock().assignRef("value", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("properties"), CodegenExpressionBuilder.constant(i)));
            Class<?> targetType = this.writeMethodsReflection[i].getParameterTypes()[0];
            if (targetType.isPrimitive()) {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(Object.class, targetType);
                value = caster.codegen(CodegenExpressionBuilder.ref("value"), Object.class, method, codegenClassScope);
            } else {
                value = CodegenExpressionBuilder.cast(targetType, (CodegenExpression)CodegenExpressionBuilder.ref("value"));
            }
            CodegenExpression set = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("und"), this.writeMethodsReflection[i].getName(), value);
            if (this.primitiveType[i]) {
                method.getBlock().ifRefNotNull("value").expression(set).blockEnd();
                continue;
            }
            method.getBlock().expression(set);
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("und"));
    }
}

