/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventPropertyGetterIndexed;
import com.espertech.esper.common.client.EventPropertyGetterMapped;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNestableGetterFactory;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.PropertySetDescriptor;
import com.espertech.esper.common.internal.event.core.PropertySetDescriptorItem;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.StringValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BaseNestableEventType
implements EventTypeSPI {
    protected EventTypeMetadata metadata;
    protected final EventType[] optionalSuperTypes;
    protected final Set<EventType> optionalDeepSupertypes;
    protected final EventTypeNestableGetterFactory getterFactory;
    protected final BeanEventTypeFactory beanEventTypeFactory;
    protected String[] propertyNames;
    protected EventPropertyDescriptor[] propertyDescriptors;
    protected Map<String, PropertySetDescriptorItem> propertyItems;
    protected Map<String, EventPropertyGetterSPI> propertyGetterCache;
    protected final Map<String, Object> nestableTypes;
    protected String startTimestampPropertyName;
    protected String endTimestampPropertyName;

    public BaseNestableEventType(EventTypeMetadata metadata, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampPropertyName, String endTimestampPropertyName, EventTypeNestableGetterFactory getterFactory, BeanEventTypeFactory beanEventTypeFactory) {
        this.metadata = metadata;
        this.getterFactory = getterFactory;
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.startTimestampPropertyName = startTimestampPropertyName;
        this.endTimestampPropertyName = endTimestampPropertyName;
        this.optionalSuperTypes = optionalSuperTypes;
        this.optionalDeepSupertypes = optionalDeepSupertypes == null ? Collections.emptySet() : optionalDeepSupertypes;
        PropertySetDescriptor propertySet = EventTypeUtility.getNestableProperties(propertyTypes, beanEventTypeFactory.getEventBeanTypedEventFactory(), getterFactory, optionalSuperTypes, beanEventTypeFactory);
        this.nestableTypes = propertySet.getNestableTypes();
        this.propertyNames = propertySet.getPropertyNameArray();
        this.propertyItems = propertySet.getPropertyItems();
        this.propertyDescriptors = propertySet.getPropertyDescriptors().toArray(new EventPropertyDescriptor[propertySet.getPropertyDescriptors().size()]);
        EventTypeUtility.TimestampPropertyDesc desc = EventTypeUtility.validatedDetermineTimestampProps(this, startTimestampPropertyName, endTimestampPropertyName, optionalSuperTypes);
        this.startTimestampPropertyName = desc.getStart();
        this.endTimestampPropertyName = desc.getEnd();
    }

    @Override
    public void setMetadataId(long publicId, long protectedId) {
        this.metadata = this.metadata.withIds(publicId, protectedId);
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        return EventTypeUtility.getNestablePropertyType(propertyName, this.propertyItems, this.nestableTypes, this.beanEventTypeFactory);
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String propertyName) {
        if (this.propertyGetterCache == null) {
            this.propertyGetterCache = new HashMap<String, EventPropertyGetterSPI>();
        }
        return EventTypeUtility.getNestableGetter(propertyName, this.propertyItems, this.propertyGetterCache, this.nestableTypes, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.getterFactory, this.metadata.getApplicationType() == EventTypeApplicationType.OBJECTARR, this.beanEventTypeFactory);
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        return this.getGetterSPI(propertyName);
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedPropertyName) {
        return this.getGetterMappedSPI(mappedPropertyName);
    }

    @Override
    public EventPropertyGetterMappedSPI getGetterMappedSPI(String mappedPropertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(mappedPropertyName);
        if (item == null || !item.getPropertyDescriptor().isMapped()) {
            return null;
        }
        MappedProperty mappedProperty = new MappedProperty(mappedPropertyName);
        return this.getterFactory.getPropertyProvidedGetterMap(this.nestableTypes, mappedPropertyName, mappedProperty, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedPropertyName) {
        return this.getGetterIndexedSPI(indexedPropertyName);
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexedSPI(String indexedPropertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(indexedPropertyName);
        if (item == null || !item.getPropertyDescriptor().isIndexed()) {
            return null;
        }
        IndexedProperty indexedProperty = new IndexedProperty(indexedPropertyName);
        return this.getterFactory.getPropertyProvidedGetterIndexed(this.nestableTypes, indexedPropertyName, indexedProperty, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), this.beanEventTypeFactory);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String propertyName) {
        Class propertyType = this.getPropertyType(propertyName);
        if (propertyType == null && this.propertyItems.containsKey(StringValue.unescapeDot(propertyName))) {
            return true;
        }
        return propertyType != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return this.optionalSuperTypes;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return this.optionalDeepSupertypes.iterator();
    }

    @Override
    public Set<EventType> getDeepSuperTypesAsSet() {
        return this.optionalDeepSupertypes;
    }

    public Map<String, Object> getTypes() {
        return this.nestableTypes;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public static ExprValidationException isDeepEqualsProperties(String otherName, Map<String, Object> setOne, Map<String, Object> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return new ExprValidationException("Type by name '" + otherName + "' expects " + setOne.size() + " properties but receives " + setTwo.size() + " properties");
        }
        for (Map.Entry<String, Object> entry : setOne.entrySet()) {
            String propName = entry.getKey();
            Object setTwoType = setTwo.get(entry.getKey());
            boolean setTwoTypeFound = setTwo.containsKey(entry.getKey());
            Object setOneType = entry.getValue();
            ExprValidationException message = BaseNestableEventUtil.comparePropType(propName, setOneType, setTwoType, setTwoTypeFound, otherName);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(propertyName);
        if (item == null) {
            return null;
        }
        return item.getPropertyDescriptor();
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public FragmentEventType getFragmentType(String propertyName) {
        PropertySetDescriptorItem item = this.propertyItems.get(propertyName);
        if (item != null) {
            return item.getFragmentEventType();
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return null;
            }
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    EventType eventType = ((EventType[])type)[0];
                    return new FragmentEventType(eventType, false, false);
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return new FragmentEventType(innerType, false, false);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return EventBeanUtility.createNativeFragmentType(((Class)type).getComponentType(), null, this.beanEventTypeFactory);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        String propertyMap = StringValue.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        if (propertyMap.endsWith("?")) {
            return null;
        }
        Object nestedType = this.nestableTypes.get(propertyMap);
        if (nestedType == null) {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyMap);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return innerType.getFragmentType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getFragmentType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                FragmentEventType fragmentParent = EventBeanUtility.createNativeFragmentType((Class)type, null, this.beanEventTypeFactory);
                if (fragmentParent == null) {
                    return null;
                }
                return fragmentParent.getFragmentType().getFragmentType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            return null;
        }
        if (nestedType instanceof Map) {
            return null;
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            if (!JavaClassHelper.isFragmentableType(simpleClass)) {
                return null;
            }
            BeanEventType nestedEventType = this.beanEventTypeFactory.getCreateBeanType(simpleClass);
            return nestedEventType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return innerType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType[]) {
            EventType[] innerType = (EventType[])nestedType;
            return innerType[0].getFragmentType(propertyNested);
        }
        if (nestedType instanceof TypeBeanOrUnderlying) {
            EventType innerType = ((TypeBeanOrUnderlying)nestedType).getEventType();
            if (!(innerType instanceof BaseNestableEventType)) {
                return null;
            }
            return innerType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])nestedType)[0].getEventType();
            if (!(innerType instanceof BaseNestableEventType)) {
                return null;
            }
            return innerType.getFragmentType(propertyNested);
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public ExprValidationException compareEquals(EventType otherType) {
        if (!(otherType instanceof BaseNestableEventType)) {
            return new ExprValidationException("Type by name '" + otherType.getName() + "' is not a compatible type (target type underlying is '" + otherType.getUnderlyingType().getName() + "')");
        }
        BaseNestableEventType other = (BaseNestableEventType)otherType;
        return BaseNestableEventType.isDeepEqualsProperties(otherType.getName(), other.nestableTypes, this.nestableTypes);
    }

    @Override
    public ExprValidationException equalsCompareType(EventType otherEventType) {
        if (this == otherEventType) {
            return null;
        }
        return this.compareEquals(otherEventType);
    }
}

