/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

public class EventTypeNameGeneratorStatement {
    private final int statementNumber;
    private int seqNum;

    public EventTypeNameGeneratorStatement(int statementNumber) {
        this.statementNumber = statementNumber;
    }

    public String getAnonymousTypeName() {
        return this.formatSingleConst("out");
    }

    public String getAnonymousTypeNameWithInner(int expressionNum) {
        return this.formatNV("eval", Integer.toString(expressionNum));
    }

    public String getAnonymousDBHistorical(int streamNum) {
        return this.formatNV("dbpoll", Integer.toString(streamNum));
    }

    public String getAnonymousMethodHistorical(int streamNum) {
        return this.formatNV("methodpoll", Integer.toString(streamNum));
    }

    public String getAnonymousRowrecogCompositeName() {
        return this.formatSingleConst("mrcomp");
    }

    public String getAnonymousRowrecogRowName() {
        return this.formatSingleConst("mrrow");
    }

    public String getAnonymousRowrecogMultimatchDefineName(int defineNum) {
        return this.formatNV("mrmd", Integer.toString(defineNum));
    }

    public String getAnonymousRowrecogMultimatchAllName() {
        return this.formatSingleConst("mrma");
    }

    public String getPatternTypeName(int stream) {
        return this.formatNV("pat", Integer.toString(stream));
    }

    public String getViewDerived(String name, int streamNum) {
        return this.formatNV("view", name + "(" + streamNum + ")");
    }

    public String getViewExpr(int streamNumber) {
        return this.formatNV("expr", Integer.toString(streamNumber));
    }

    public String getViewGroup(int streamNum) {
        return this.formatNV("grp", Integer.toString(streamNum));
    }

    public String getAnonymousTypeNameEnumMethod(String enumMethod, String propertyName) {
        return this.formatNV("enum", enumMethod + "(" + propertyName + ")");
    }

    public String getAnonymousTypeSubselectMultirow(int subselectNumber) {
        return this.formatNV("subq", Integer.toString(subselectNumber));
    }

    public String getAnonymousTypeNameUDFMethod(String methodName, String typeName) {
        return this.formatNV("mth", methodName + "(" + typeName + ")");
    }

    public String getAnonymousPatternName(int streamNum, short factoryNodeId) {
        return this.formatNV("pan", streamNum + "(" + factoryNodeId + ")");
    }

    public String getAnonymousPatternNameWTag(int streamNum, short factoryNodeId, String tag) {
        return this.formatNV("pwt", streamNum + "(" + factoryNodeId + "_" + tag + ")");
    }

    public String getContextPropertyTypeName(String contextName) {
        return this.formatNV("ctx", contextName);
    }

    public String getContextStatementTypeName(String contextName) {
        return this.formatNV("ctxout", contextName);
    }

    public String getDataflowOperatorTypeName(int operatorNumber) {
        return this.formatNV("df", "op_" + operatorNumber);
    }

    private String formatSingleConst(String postfixConst) {
        StringBuilder builder = new StringBuilder();
        builder.append("stmt");
        builder.append(this.statementNumber);
        builder.append("_");
        builder.append(postfixConst);
        builder.append(this.seqNum++);
        return builder.toString();
    }

    private String formatNV(String postfixNameOne, String postfixValueOne) {
        StringBuilder builder = new StringBuilder();
        builder.append("stmt");
        builder.append(this.statementNumber);
        builder.append("_");
        builder.append(postfixNameOne);
        builder.append("_");
        builder.append(postfixValueOne);
        builder.append("_");
        builder.append(this.seqNum++);
        return builder.toString();
    }
}

