/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.bean.core.BeanEventBean;
import com.espertech.esper.common.internal.event.core.EventTypeResolvingBeanFactory;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepository;
import com.espertech.esper.common.internal.event.json.core.JsonEventBean;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventBean;
import com.espertech.esper.common.internal.event.xml.XMLEventBean;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventTypeResolvingBeanFactoryImpl
implements EventTypeResolvingBeanFactory {
    private final EventTypeRepository eventTypeRepository;
    private final EventTypeAvroHandler avroHandler;

    public EventTypeResolvingBeanFactoryImpl(EventTypeRepository eventTypeRepository, EventTypeAvroHandler avroHandler) {
        this.eventTypeRepository = eventTypeRepository;
        this.avroHandler = avroHandler;
    }

    @Override
    public EventBean adapterForObjectArray(Object[] theEvent, String eventTypeName) throws EPException {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeObjectArray(eventTypeName, type);
        return new ObjectArrayEventBean(theEvent, type);
    }

    @Override
    public EventBean adapterForBean(Object data, String eventTypeName) {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeBean(eventTypeName, type);
        return new BeanEventBean(data, type);
    }

    @Override
    public EventBean adapterForMap(Map<String, Object> map, String eventTypeName) {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeMap(eventTypeName, type);
        return new MapEventBean(map, type);
    }

    @Override
    public EventBean adapterForXMLDOM(Node node, String eventTypeName) {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeXMLDOM(eventTypeName, type);
        Node namedNode = EventTypeResolvingBeanFactoryImpl.getXMLNodeFromDocument(node);
        return new XMLEventBean(namedNode, type);
    }

    @Override
    public EventBean adapterForAvro(Object avroGenericDataDotRecord, String eventTypeName) {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeAvro(eventTypeName, type);
        return this.avroHandler.adapterForTypeAvro(avroGenericDataDotRecord, type);
    }

    @Override
    public EventBean adapterForJson(String json, String eventTypeName) {
        EventType type = this.eventTypeRepository.getTypeByName(eventTypeName);
        EventTypeUtility.validateTypeJson(eventTypeName, type);
        JsonEventType jsonEventType = (JsonEventType)type;
        Object underlying = jsonEventType.parse(json);
        return new JsonEventBean(underlying, type);
    }

    public static Node getXMLNodeFromDocument(Node node) {
        Node resultNode = node;
        if (node instanceof Document) {
            resultNode = ((Document)node).getDocumentElement();
        } else if (!(node instanceof Element)) {
            throw new EPException("Unexpected DOM node of type '" + node.getClass() + "' encountered, please supply a Document or Element node");
        }
        return resultNode;
    }
}

