/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventBeanFactory;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeAvro;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeJson;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMap;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeObjectArray;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeWithSupertype;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.ColumnDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateSchemaDesc;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.bean.core.BeanEventBean;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerBeanForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerJsonForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerMapForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.EventBeanManufacturerObjectArrayForge;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.DecoratingEventBean;
import com.espertech.esper.common.internal.event.core.EventAdapterException;
import com.espertech.esper.common.internal.event.core.EventBeanAdapterFactory;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryBean;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryBeanWrapped;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryJson;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryMap;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryObjectArray;
import com.espertech.esper.common.internal.event.core.EventBeanFactoryXML;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturerForge;
import com.espertech.esper.common.internal.event.core.EventBeanSPI;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeCompileTimeResolver;
import com.espertech.esper.common.internal.event.core.EventTypeForgablesPair;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.EventTypeNestableGetterFactory;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.core.PropertySetDescriptor;
import com.espertech.esper.common.internal.event.core.PropertySetDescriptorItem;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.event.json.compiletime.JsonEventTypeUtility;
import com.espertech.esper.common.internal.event.json.core.JsonEventBean;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.map.MapEventBean;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.property.DynamicProperty;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.NestedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.property.SimpleProperty;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.XMLEventBean;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.type.ClassIdentifierWArray;
import com.espertech.esper.common.internal.util.EventRepresentationUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import com.espertech.esper.common.internal.util.StringValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.w3c.dom.Node;

public class EventTypeUtility {
    public static void compareExistingType(EventType newEventType, EventType existingType) throws ExprValidationException {
        ExprValidationException compared = ((EventTypeSPI)newEventType).equalsCompareType(existingType);
        if (compared != null) {
            throw new ExprValidationException("Event type named '" + newEventType.getName() + "' has already been declared with differing column name or type information: " + compared.getMessage(), compared);
        }
    }

    public static EventBeanSPI getShellForType(EventType eventType) {
        if (eventType instanceof BeanEventType) {
            return new BeanEventBean(null, eventType);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new ObjectArrayEventBean(null, eventType);
        }
        if (eventType instanceof MapEventType) {
            return new MapEventBean(null, eventType);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new XMLEventBean(null, eventType);
        }
        if (eventType instanceof JsonEventType) {
            return new JsonEventBean(null, eventType);
        }
        throw new EventAdapterException("Event type '" + eventType.getName() + "' is not an runtime-native event type");
    }

    public static EventBeanFactory getFactoryForType(EventType type, EventBeanTypedEventFactory factory, EventTypeAvroHandler eventTypeAvroHandler) {
        WrapperEventType wrapperType;
        if (type instanceof WrapperEventType && (wrapperType = (WrapperEventType)type).getUnderlyingEventType() instanceof BeanEventType) {
            return new EventBeanFactoryBeanWrapped(wrapperType.getUnderlyingEventType(), wrapperType, factory);
        }
        if (type instanceof BeanEventType) {
            return new EventBeanFactoryBean(type, factory);
        }
        if (type instanceof MapEventType) {
            return new EventBeanFactoryMap(type, factory);
        }
        if (type instanceof ObjectArrayEventType) {
            return new EventBeanFactoryObjectArray(type, factory);
        }
        if (type instanceof BaseXMLEventType) {
            return new EventBeanFactoryXML(type, factory);
        }
        if (type instanceof AvroSchemaEventType) {
            return eventTypeAvroHandler.getEventBeanFactory(type, factory);
        }
        if (type instanceof JsonEventType) {
            return new EventBeanFactoryJson((JsonEventType)type, factory);
        }
        throw new IllegalArgumentException("Cannot create event bean factory for event type '" + type.getName() + "': " + type.getClass().getName() + " is not a recognized event type or supported wrap event type");
    }

    public static EventBeanManufacturerForge getManufacturer(EventType eventType, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService, boolean allowAnyType, EventTypeAvroHandler avroHandler) throws EventBeanManufactureException {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            return new EventBeanManufacturerBeanForge(beanEventType, properties, classpathImportService);
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!allowAnyType && !EventTypeUtility.allowPopulate(typeSPI)) {
            return null;
        }
        if (eventType instanceof MapEventType) {
            MapEventType mapEventType = (MapEventType)eventType;
            return new EventBeanManufacturerMapForge(mapEventType, properties);
        }
        if (eventType instanceof ObjectArrayEventType) {
            ObjectArrayEventType objectArrayEventType = (ObjectArrayEventType)eventType;
            return new EventBeanManufacturerObjectArrayForge(objectArrayEventType, properties);
        }
        if (eventType instanceof AvroSchemaEventType) {
            AvroSchemaEventType avroSchemaEventType = (AvroSchemaEventType)eventType;
            return avroHandler.getEventBeanManufacturer(avroSchemaEventType, properties);
        }
        if (eventType instanceof JsonEventType) {
            JsonEventType jsonEventType = (JsonEventType)eventType;
            return new EventBeanManufacturerJsonForge(jsonEventType, properties);
        }
        return null;
    }

    public static Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType, boolean allowAnyType, boolean allowFragmentType) {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            return PropertyHelper.getWritableProperties(beanEventType.getUnderlyingType());
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!allowAnyType && !EventTypeUtility.allowPopulate(typeSPI)) {
            return null;
        }
        if (eventType instanceof BaseNestableEventType) {
            Map<String, Object> mapdef = ((BaseNestableEventType)eventType).getTypes();
            LinkedHashSet<WriteablePropertyDescriptor> writables = new LinkedHashSet<WriteablePropertyDescriptor>();
            for (Map.Entry<String, Object> types : mapdef.entrySet()) {
                TypeBeanOrUnderlying[] und;
                if (types.getValue() instanceof Class) {
                    writables.add(new WriteablePropertyDescriptor(types.getKey(), (Class)types.getValue(), null, false));
                }
                if (types.getValue() instanceof String) {
                    String typeName = types.getValue().toString();
                    Class clazz = JavaClassHelper.getPrimitiveClassForName(typeName);
                    if (clazz != null) {
                        writables.add(new WriteablePropertyDescriptor(types.getKey(), clazz, null, false));
                    } else if (allowFragmentType) {
                        writables.add(new WriteablePropertyDescriptor(types.getKey(), clazz, null, true));
                    }
                }
                if (allowFragmentType && types.getValue() instanceof TypeBeanOrUnderlying) {
                    und = (TypeBeanOrUnderlying[])types.getValue();
                    writables.add(new WriteablePropertyDescriptor(types.getKey(), und.getEventType().getUnderlyingType(), null, true));
                }
                if (!allowFragmentType || !(types.getValue() instanceof TypeBeanOrUnderlying[])) continue;
                und = (TypeBeanOrUnderlying[])types.getValue();
                writables.add(new WriteablePropertyDescriptor(types.getKey(), und[0].getEventType().getUnderlyingType(), null, true));
            }
            return writables;
        }
        if (eventType instanceof AvroSchemaEventType) {
            EventPropertyDescriptor[] desc;
            LinkedHashSet<WriteablePropertyDescriptor> writables = new LinkedHashSet<WriteablePropertyDescriptor>();
            for (EventPropertyDescriptor prop : desc = typeSPI.getWriteableProperties()) {
                writables.add(new WriteablePropertyDescriptor(prop.getPropertyName(), prop.getPropertyType(), null, false));
            }
            return writables;
        }
        return null;
    }

    public static CodegenExpression resolveTypeCodegen(EventType eventType, CodegenExpression initServicesRef) {
        return EventTypeUtility.resolveTypeCodegenGivenResolver(eventType, CodegenExpressionBuilder.exprDotMethodChain(initServicesRef).add("getEventTypeResolver", new CodegenExpression[0]));
    }

    public static CodegenExpression resolveTypeCodegenGivenResolver(EventType eventType, CodegenExpression typeResolver) {
        if (eventType == null) {
            throw new IllegalArgumentException("Null event type");
        }
        if (typeResolver == null) {
            throw new IllegalArgumentException("Event type resolver not provided");
        }
        if (eventType instanceof BeanEventType && eventType.getMetadata().getAccessModifier() == NameAccessModifier.TRANSIENT) {
            return CodegenExpressionBuilder.exprDotMethod(typeResolver, "resolvePrivateBean", CodegenExpressionBuilder.constant(eventType.getUnderlyingType()));
        }
        return CodegenExpressionBuilder.exprDotMethod(typeResolver, "resolve", eventType.getMetadata().toExpression());
    }

    public static CodegenExpression resolveTypeArrayCodegen(EventType[] eventTypes, CodegenExpression initServicesRef) {
        CodegenExpression[] expressions = new CodegenExpression[eventTypes.length];
        for (int i = 0; i < eventTypes.length; ++i) {
            expressions[i] = EventTypeUtility.resolveTypeCodegen(eventTypes[i], initServicesRef);
        }
        return CodegenExpressionBuilder.newArrayWithInit(EventType.class, expressions);
    }

    public static CodegenExpression resolveTypeArrayCodegenMayNull(EventType[] eventTypes, CodegenExpression initServicesRef) {
        CodegenExpression[] expressions = new CodegenExpression[eventTypes.length];
        for (int i = 0; i < eventTypes.length; ++i) {
            expressions[i] = eventTypes[i] == null ? CodegenExpressionBuilder.constantNull() : EventTypeUtility.resolveTypeCodegen(eventTypes[i], initServicesRef);
        }
        return CodegenExpressionBuilder.newArrayWithInit(EventType.class, expressions);
    }

    public static CodegenExpression codegenGetterWCoerce(EventPropertyGetterSPI getter, Class getterType, Class optionalCoercionType, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        getterType = JavaClassHelper.getBoxedType(getterType);
        CodegenExpressionNewAnonymousClass anonymous = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyValueGetter.class);
        CodegenMethod get = CodegenMethod.makeParentNode(Object.class, generator, classScope).addParam(CodegenNamedParam.from(EventBean.class, "bean"));
        anonymous.addMethod("get", get);
        CodegenExpression result = getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("bean"), method, classScope);
        if (optionalCoercionType != null && getterType != optionalCoercionType && JavaClassHelper.isNumeric(getterType)) {
            SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(getterType, JavaClassHelper.getBoxedType(optionalCoercionType));
            get.getBlock().declareVar(getterType, "prop", CodegenExpressionBuilder.cast(getterType, result));
            result = coercer.coerceCodegen(CodegenExpressionBuilder.ref("prop"), getterType);
        }
        get.getBlock().methodReturn(result);
        return anonymous;
    }

    public static CodegenExpression codegenGetterWCoerceWArray(EventPropertyGetterSPI getter, Class getterType, Class optionalCoercionType, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        getterType = JavaClassHelper.getBoxedType(getterType);
        CodegenExpressionNewAnonymousClass anonymous = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyValueGetter.class);
        CodegenMethod get = CodegenMethod.makeParentNode(Object.class, generator, classScope).addParam(CodegenNamedParam.from(EventBean.class, "bean"));
        anonymous.addMethod("get", get);
        CodegenExpression result = getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("bean"), method, classScope);
        if (optionalCoercionType != null && getterType != optionalCoercionType && JavaClassHelper.isNumeric(getterType)) {
            SimpleNumberCoercer coercer = SimpleNumberCoercerFactory.getCoercer(getterType, JavaClassHelper.getBoxedType(optionalCoercionType));
            get.getBlock().declareVar(getterType, "prop", CodegenExpressionBuilder.cast(getterType, result));
            result = coercer.coerceCodegen(CodegenExpressionBuilder.ref("prop"), getterType);
        }
        if (getterType.isArray()) {
            Class mkType = MultiKeyPlanner.getMKClassForComponentType(getterType.getComponentType());
            result = CodegenExpressionBuilder.newInstance(mkType, CodegenExpressionBuilder.cast(getterType, result));
        }
        get.getBlock().methodReturn(result);
        return anonymous;
    }

    public static CodegenExpression codegenWriter(EventType eventType, Class targetType, Class evaluationType, EventPropertyWriterSPI writer, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass anonymous = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyWriter.class);
        CodegenMethod write = CodegenMethod.makeParentNode(Void.TYPE, generator, classScope).addParam(CodegenNamedParam.from(Object.class, "value", EventBean.class, "bean"));
        anonymous.addMethod("write", write);
        evaluationType = JavaClassHelper.getBoxedType(evaluationType);
        write.getBlock().declareVar(eventType.getUnderlyingType(), "und", CodegenExpressionBuilder.cast(eventType.getUnderlyingType(), CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("bean")))).declareVar(evaluationType, "eval", CodegenExpressionBuilder.cast(evaluationType, (CodegenExpression)CodegenExpressionBuilder.ref("value"))).expression(writer.writeCodegen(CodegenExpressionBuilder.ref("eval"), CodegenExpressionBuilder.ref("und"), CodegenExpressionBuilder.ref("bean"), write, classScope));
        return anonymous;
    }

    public static LinkedHashMap<String, Object> getPropertyTypesNonPrimitive(LinkedHashMap<String, Object> propertyTypesMayPrimitive) {
        boolean hasPrimitive = false;
        for (Map.Entry<String, Object> entry : propertyTypesMayPrimitive.entrySet()) {
            if (!(entry.getValue() instanceof Class) || !((Class)entry.getValue()).isPrimitive()) continue;
            hasPrimitive = true;
            break;
        }
        if (!hasPrimitive) {
            return propertyTypesMayPrimitive;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(propertyTypesMayPrimitive);
        for (Map.Entry<String, Object> entry : propertyTypesMayPrimitive.entrySet()) {
            Class clazz;
            if (!(entry.getValue() instanceof Class) || !(clazz = (Class)entry.getValue()).isPrimitive()) continue;
            props.put(entry.getKey(), JavaClassHelper.getBoxedType(clazz));
        }
        return props;
    }

    public static EventType requireEventType(String aspectCamel, String aspectName, String optionalEventTypeName, EventTypeCompileTimeResolver eventTypeCompileTimeResolver) throws ExprValidationException {
        if (optionalEventTypeName == null) {
            throw new ExprValidationException(aspectCamel + " '" + aspectName + "' returns EventBean-array but does not provide the event type name");
        }
        EventType eventType = eventTypeCompileTimeResolver.getTypeByName(optionalEventTypeName);
        if (eventType == null) {
            throw new ExprValidationException(aspectCamel + " '" + aspectName + "' returns event type '" + optionalEventTypeName + "' and the event type cannot be found");
        }
        return eventType;
    }

    public static Pair<EventType[], Set<EventType>> getSuperTypesDepthFirst(Set<String> superTypesSet, EventUnderlyingType representation, EventTypeNameResolver eventTypeNameResolver) {
        return EventTypeUtility.getSuperTypesDepthFirst(superTypesSet == null || superTypesSet.isEmpty() ? null : superTypesSet.toArray(new String[superTypesSet.size()]), representation, eventTypeNameResolver);
    }

    public static Pair<EventType[], Set<EventType>> getSuperTypesDepthFirst(String[] superTypesSet, EventUnderlyingType representation, EventTypeNameResolver eventTypeNameResolver) throws EventAdapterException {
        if (superTypesSet == null || superTypesSet.length == 0) {
            return new Pair<Object, Object>(null, null);
        }
        EventType[] superTypes = new EventType[superTypesSet.length];
        LinkedHashSet<EventType> deepSuperTypes = new LinkedHashSet<EventType>();
        int count = 0;
        for (String superName : superTypesSet) {
            EventType type = eventTypeNameResolver.getTypeByName(superName);
            if (type == null) {
                throw new EventAdapterException("Supertype by name '" + superName + "' could not be found");
            }
            if (representation == EventUnderlyingType.MAP) {
                if (!(type instanceof MapEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not a Map, expected a Map event type as a supertype");
                }
            } else if (representation == EventUnderlyingType.OBJECTARRAY) {
                if (!(type instanceof ObjectArrayEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not an Object-array type, expected a Object-array event type as a supertype");
                }
            } else if (representation == EventUnderlyingType.AVRO) {
                if (!(type instanceof AvroSchemaEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not an Avro type, expected a Avro event type as a supertype");
                }
            } else if (representation == EventUnderlyingType.JSON) {
                if (!(type instanceof JsonEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not a Json type, expected a Json event type as a supertype");
                }
            } else {
                throw new IllegalStateException("Unrecognized enum " + (Object)((Object)representation));
            }
            superTypes[count++] = type;
            deepSuperTypes.add(type);
            EventTypeUtility.addRecursiveSupertypes(deepSuperTypes, type);
        }
        ArrayList superTypesListDepthFirst = new ArrayList(deepSuperTypes);
        Collections.reverse(superTypesListDepthFirst);
        return new Pair<EventType[], Set<EventType>>(superTypes, new LinkedHashSet(superTypesListDepthFirst));
    }

    public static EventPropertyDescriptor getNestablePropertyDescriptor(EventType target, String propertyName) {
        EventPropertyDescriptor descriptor = target.getPropertyDescriptor(propertyName);
        if (descriptor != null) {
            return descriptor;
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            return null;
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof PropertyBase) {
            return target.getPropertyDescriptor(((PropertyBase)property).getPropertyNameAtomic());
        }
        if (!(property instanceof NestedProperty)) {
            return null;
        }
        NestedProperty nested = (NestedProperty)property;
        ArrayDeque<Property> properties = new ArrayDeque<Property>(nested.getProperties());
        return EventTypeUtility.getNestablePropertyDescriptor(target, properties);
    }

    public static EventPropertyDescriptor getNestablePropertyDescriptor(EventType target, Deque<Property> stack) {
        Property topProperty = stack.removeFirst();
        if (stack.isEmpty()) {
            return target.getPropertyDescriptor(((PropertyBase)topProperty).getPropertyNameAtomic());
        }
        if (!(topProperty instanceof SimpleProperty)) {
            return null;
        }
        SimpleProperty simple = (SimpleProperty)topProperty;
        FragmentEventType fragmentEventType = target.getFragmentType(simple.getPropertyNameAtomic());
        if (fragmentEventType == null || fragmentEventType.getFragmentType() == null) {
            return null;
        }
        return EventTypeUtility.getNestablePropertyDescriptor(fragmentEventType.getFragmentType(), stack);
    }

    public static LinkedHashMap<String, Object> buildType(List<ColumnDesc> columns, Set<String> copyFrom, ClasspathImportServiceCompileTime classpathImportService, EventTypeNameResolver eventTypeResolver) throws ExprValidationException {
        LinkedHashMap<String, Object> typing = new LinkedHashMap<String, Object>();
        HashSet<String> columnNames = new HashSet<String>();
        if (copyFrom != null && !copyFrom.isEmpty()) {
            for (String copyFromName : copyFrom) {
                EventType type = eventTypeResolver.getTypeByName(copyFromName);
                if (type == null) {
                    throw new ExprValidationException("Type by name '" + copyFromName + "' could not be located");
                }
                EventTypeUtility.mergeType(typing, type, columnNames);
            }
        }
        for (ColumnDesc column : columns) {
            boolean added = columnNames.add(column.getName());
            if (!added) {
                throw new ExprValidationException("Duplicate column name '" + column.getName() + "'");
            }
            Object columnType = EventTypeUtility.buildType(column, classpathImportService);
            typing.put(column.getName(), columnType);
        }
        return typing;
    }

    public static Object buildType(ColumnDesc column, ClasspathImportServiceCompileTime classpathImportService) throws ExprValidationException {
        if (column.getType() == null) {
            return null;
        }
        ClassIdentifierWArray classIdent = ClassIdentifierWArray.parseSODA(column.getType());
        String typeName = classIdent.getClassIdentifier();
        if (classIdent.isArrayOfPrimitive()) {
            Class primitive = JavaClassHelper.getPrimitiveClassForName(typeName);
            if (primitive != null) {
                return JavaClassHelper.getArrayType(primitive, classIdent.getArrayDimensions());
            }
            throw new ExprValidationException("Type '" + typeName + "' is not a primitive type");
        }
        Class plain = JavaClassHelper.getClassForSimpleName(typeName, classpathImportService.getClassForNameProvider());
        if (plain != null) {
            return JavaClassHelper.getArrayType(plain, classIdent.getArrayDimensions());
        }
        Class resolved = null;
        try {
            resolved = classpathImportService.resolveClass(typeName, false);
        }
        catch (ClasspathImportException classpathImportException) {
            // empty catch block
        }
        String lowercase = typeName.toLowerCase(Locale.ENGLISH);
        if (lowercase.equals("biginteger")) {
            return JavaClassHelper.getArrayType(BigInteger.class, classIdent.getArrayDimensions());
        }
        if (lowercase.equals("bigdecimal")) {
            return JavaClassHelper.getArrayType(BigDecimal.class, classIdent.getArrayDimensions());
        }
        if (resolved == null) {
            try {
                resolved = JavaClassHelper.getClassForName(typeName, classpathImportService.getClassForNameProvider());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (resolved != null) {
            return JavaClassHelper.getArrayType(resolved, classIdent.getArrayDimensions());
        }
        if (classIdent.getArrayDimensions() > 1) {
            throw new EPException("Two-dimensional arrays are not supported for event-types (cannot find class '" + classIdent.getClassIdentifier() + "')");
        }
        if (classIdent.getArrayDimensions() == 1) {
            return column.getType() + "[]";
        }
        return column.getType();
    }

    private static void mergeType(Map<String, Object> typing, EventType typeToMerge, Set<String> columnNames) throws ExprValidationException {
        for (EventPropertyDescriptor prop : typeToMerge.getPropertyDescriptors()) {
            Object existing = typing.get(prop.getPropertyName());
            if (!prop.isFragment()) {
                Class assigned = prop.getPropertyType();
                if (existing != null && existing instanceof Class && JavaClassHelper.getBoxedType((Class)existing) != JavaClassHelper.getBoxedType(assigned)) {
                    throw new ExprValidationException("Type by name '" + typeToMerge.getName() + "' contributes property '" + prop.getPropertyName() + "' defined as '" + JavaClassHelper.getClassNameFullyQualPretty(assigned) + "' which overides the same property of type '" + JavaClassHelper.getClassNameFullyQualPretty((Class)existing) + "'");
                }
                typing.put(prop.getPropertyName(), prop.getPropertyType());
            } else {
                if (existing != null) {
                    throw new ExprValidationException("Property by name '" + prop.getPropertyName() + "' is defined twice by adding type '" + typeToMerge.getName() + "'");
                }
                FragmentEventType fragment = typeToMerge.getFragmentType(prop.getPropertyName());
                if (fragment == null) continue;
                if (fragment.isIndexed()) {
                    typing.put(prop.getPropertyName(), new EventType[]{fragment.getFragmentType()});
                } else {
                    typing.put(prop.getPropertyName(), fragment.getFragmentType());
                }
            }
            columnNames.add(prop.getPropertyName());
        }
    }

    public static void validateTimestampProperties(EventType eventType, String startTimestampProperty, String endTimestampProperty) throws ConfigurationException {
        Class type;
        if (startTimestampProperty != null) {
            if (eventType.getGetter(startTimestampProperty) == null) {
                throw new ConfigurationException("Declared start timestamp property name '" + startTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(startTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared start timestamp property '" + startTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
        }
        if (endTimestampProperty != null) {
            if (startTimestampProperty == null) {
                throw new ConfigurationException("Declared end timestamp property requires that a start timestamp property is also declared");
            }
            if (eventType.getGetter(endTimestampProperty) == null) {
                throw new ConfigurationException("Declared end timestamp property name '" + endTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(endTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
            Class startType = eventType.getPropertyType(startTimestampProperty);
            if (JavaClassHelper.getBoxedType(startType) != JavaClassHelper.getBoxedType(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to have the same property type as the start-timestamp property '" + startTimestampProperty + "'");
            }
        }
    }

    public static boolean isTypeOrSubTypeOf(EventType candidate, EventType superType) {
        if (candidate == superType) {
            return true;
        }
        if (candidate.getSuperTypes() != null) {
            Iterator<EventType> it = candidate.getDeepSuperTypes();
            while (it.hasNext()) {
                if (it.next() != superType) continue;
                return true;
            }
        }
        return false;
    }

    public static LinkedHashMap<String, Object> compileMapTypeProperties(Map<String, Object> typing, EventTypeNameResolver eventTypeResolver) {
        LinkedHashMap<String, Object> compiled = new LinkedHashMap<String, Object>(typing);
        for (Map.Entry<String, Object> specifiedEntry : typing.entrySet()) {
            EventType eventType;
            Object typeSpec = specifiedEntry.getValue();
            String nameSpec = specifiedEntry.getKey();
            if (typeSpec instanceof Class) {
                compiled.put(nameSpec, JavaClassHelper.getBoxedType((Class)typeSpec));
                continue;
            }
            if (!(typeSpec instanceof String)) continue;
            String typeNameSpec = (String)typeSpec;
            boolean isArray = EventTypeUtility.isPropertyArray(typeNameSpec);
            if (isArray) {
                typeNameSpec = EventTypeUtility.getPropertyRemoveArray(typeNameSpec);
            }
            if ((eventType = eventTypeResolver.getTypeByName(typeNameSpec)) == null || !(eventType instanceof BeanEventType)) continue;
            BeanEventType beanEventType = (BeanEventType)eventType;
            Class underlyingType = beanEventType.getUnderlyingType();
            if (isArray) {
                underlyingType = JavaClassHelper.getArrayType(underlyingType);
            }
            compiled.put(nameSpec, underlyingType);
        }
        return compiled;
    }

    public static boolean isPropertyArray(String name) {
        return name.trim().endsWith("[]");
    }

    public static boolean isTypeOrSubTypeOf(String typeName, EventType sameTypeOrSubtype) {
        if (sameTypeOrSubtype.getName().equals(typeName)) {
            return true;
        }
        if (sameTypeOrSubtype.getSuperTypes() == null) {
            return false;
        }
        for (EventType superType : sameTypeOrSubtype.getSuperTypes()) {
            if (!superType.getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static String getPropertyRemoveArray(String name) {
        return name.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    /*
     * WARNING - void declaration
     */
    public static PropertySetDescriptor getNestableProperties(Map<String, Object> propertiesToAdd, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNestableGetterFactory factory, EventType[] optionalSuperTypes, BeanEventTypeFactory beanEventTypeFactory) throws EPException {
        ArrayList<String> propertyNameList = new ArrayList<String>();
        ArrayList<EventPropertyDescriptor> propertyDescriptors = new ArrayList<EventPropertyDescriptor>();
        LinkedHashMap<String, Object> nestableTypes = new LinkedHashMap<String, Object>();
        HashMap<String, PropertySetDescriptorItem> propertyItems = new HashMap<String, PropertySetDescriptorItem>();
        if (optionalSuperTypes != null) {
            for (int i = 0; i < optionalSuperTypes.length; ++i) {
                BaseNestableEventType superType = (BaseNestableEventType)optionalSuperTypes[i];
                for (String string : superType.getPropertyNames()) {
                    if (nestableTypes.containsKey(string)) continue;
                    propertyNameList.add(string);
                }
                for (EventPropertyDescriptor eventPropertyDescriptor : superType.getPropertyDescriptors()) {
                    if (nestableTypes.containsKey(eventPropertyDescriptor.getPropertyName())) continue;
                    propertyDescriptors.add(eventPropertyDescriptor);
                }
                propertyItems.putAll(superType.propertyItems);
                nestableTypes.putAll(superType.nestableTypes);
            }
        }
        nestableTypes.putAll(propertiesToAdd);
        for (Map.Entry<String, Object> entry : propertiesToAdd.entrySet()) {
            PropertySetDescriptorItem item;
            FragmentEventType fragmentEventType;
            EventType eventType;
            EventPropertyGetterSPI getter;
            String value;
            Class clazz;
            if (!(entry.getKey() instanceof String)) {
                throw new EPException("Invalid type configuration: property name is not a String-type value");
            }
            String name = entry.getKey();
            if (entry.getValue() instanceof String && (clazz = JavaClassHelper.getPrimitiveClassForName(value = entry.getValue().toString().trim())) != null) {
                entry.setValue(clazz);
            }
            if (entry.getValue() instanceof Class) {
                void var14_34;
                boolean isMapped;
                Class classType = (Class)entry.getValue();
                boolean isArray = classType.isArray();
                Object var14_30 = null;
                if (isArray) {
                    Class<?> clazz2 = classType.getComponentType();
                }
                if (isMapped = JavaClassHelper.isImplementsInterface(classType, Map.class)) {
                    Class<Object> clazz3 = Object.class;
                }
                boolean isFragment = JavaClassHelper.isFragmentableType(classType);
                BeanEventType nativeFragmentType = null;
                FragmentEventType fragmentType = null;
                if (isFragment) {
                    fragmentType = EventBeanUtility.createNativeFragmentType(classType, null, beanEventTypeFactory);
                    if (fragmentType != null) {
                        nativeFragmentType = (BeanEventType)fragmentType.getFragmentType();
                    } else {
                        isFragment = false;
                    }
                }
                EventPropertyGetterSPI getter2 = factory.getGetterProperty(name, nativeFragmentType, eventBeanTypedEventFactory);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, classType, (Class)var14_34, false, false, isArray, isMapped, isFragment);
                PropertySetDescriptorItem item3 = new PropertySetDescriptorItem(descriptor, classType, getter2, fragmentType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item3);
                continue;
            }
            if (entry.getValue() == null) {
                getter = factory.getGetterProperty(name, null, null);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, null, null, false, false, false, false, false);
                PropertySetDescriptorItem propertySetDescriptorItem = new PropertySetDescriptorItem(descriptor, null, getter, null);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, propertySetDescriptorItem);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                getter = factory.getGetterProperty(name, null, null);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, Map.class, null, false, false, false, true, false);
                PropertySetDescriptorItem propertySetDescriptorItem = new PropertySetDescriptorItem(descriptor, Map.class, getter, null);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, propertySetDescriptorItem);
                continue;
            }
            if (entry.getValue() instanceof EventType) {
                eventType = (EventType)entry.getValue();
                EventPropertyGetterSPI getter3 = factory.getGetterEventBean(name, eventType.getUnderlyingType());
                EventPropertyDescriptor eventPropertyDescriptor = new EventPropertyDescriptor(name, eventType.getUnderlyingType(), null, false, false, false, false, true);
                FragmentEventType fragmentEventType2 = new FragmentEventType(eventType, false, false);
                PropertySetDescriptorItem item4 = new PropertySetDescriptorItem(eventPropertyDescriptor, eventType.getUnderlyingType(), getter3, fragmentEventType2);
                propertyNameList.add(name);
                propertyDescriptors.add(eventPropertyDescriptor);
                propertyItems.put(name, item4);
                continue;
            }
            if (entry.getValue() instanceof EventType[]) {
                eventType = ((EventType[])entry.getValue())[0];
                Object prototypeArray = Array.newInstance(eventType.getUnderlyingType(), 0);
                EventPropertyGetterSPI eventPropertyGetterSPI = factory.getGetterEventBeanArray(name, eventType);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, prototypeArray.getClass(), eventType.getUnderlyingType(), false, false, true, false, true);
                FragmentEventType fragmentEventType3 = new FragmentEventType(eventType, true, false);
                PropertySetDescriptorItem item5 = new PropertySetDescriptorItem(descriptor, prototypeArray.getClass(), eventPropertyGetterSPI, fragmentEventType3);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item5);
                continue;
            }
            if (entry.getValue() instanceof TypeBeanOrUnderlying) {
                eventType = ((TypeBeanOrUnderlying)entry.getValue()).getEventType();
                if (!(eventType instanceof BaseNestableEventType)) {
                    throw new EPException("Nestable type configuration encountered an unexpected property type name '" + entry.getValue() + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared event type");
                }
                Class underlyingType = eventType.getUnderlyingType();
                Class clazz4 = null;
                EventPropertyGetterSPI getter5 = factory.getGetterBeanNested(name, eventType, eventBeanTypedEventFactory);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, underlyingType, clazz4, false, false, false, false, true);
                fragmentEventType = new FragmentEventType(eventType, false, false);
                item = new PropertySetDescriptorItem(descriptor, underlyingType, getter5, fragmentEventType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item);
                continue;
            }
            if (entry.getValue() instanceof TypeBeanOrUnderlying[]) {
                Class<?> underlyingType;
                eventType = ((TypeBeanOrUnderlying[])entry.getValue())[0].getEventType();
                if (!(eventType instanceof BaseNestableEventType) && !(eventType instanceof BeanEventType)) {
                    throw new EPException("Nestable type configuration encountered an unexpected property type name '" + entry.getValue() + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared event type");
                }
                Class<?> clazz5 = underlyingType = eventType.getUnderlyingType();
                if (underlyingType != Object[].class) {
                    underlyingType = Array.newInstance(underlyingType, 0).getClass();
                }
                EventPropertyGetterSPI getter6 = factory.getGetterBeanNestedArray(name, eventType, eventBeanTypedEventFactory);
                EventPropertyDescriptor descriptor = new EventPropertyDescriptor(name, underlyingType, clazz5, false, false, true, false, true);
                fragmentEventType = new FragmentEventType(eventType, true, false);
                item = new PropertySetDescriptorItem(descriptor, underlyingType, getter6, fragmentEventType);
                propertyNameList.add(name);
                propertyDescriptors.add(descriptor);
                propertyItems.put(name, item);
                continue;
            }
            EventTypeUtility.generateExceptionNestedProp(name, entry.getValue());
        }
        return new PropertySetDescriptor(propertyNameList, propertyDescriptors, propertyItems, nestableTypes);
    }

    private static void generateExceptionNestedProp(String name, Object value) throws EPException {
        String clazzName = value == null ? "null" : value.getClass().getSimpleName();
        throw new EPException("Nestable type configuration encountered an unexpected property type of '" + clazzName + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared event type");
    }

    public static Class getNestablePropertyType(String propertyName, Map<String, PropertySetDescriptorItem> simplePropertyTypes, Map<String, Object> nestableTypes, BeanEventTypeFactory beanEventTypeFactory) {
        Object nestedType;
        PropertySetDescriptorItem item = simplePropertyTypes.get(StringValue.unescapeDot(propertyName));
        if (item != null) {
            return item.getSimplePropertyType();
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return Object.class;
            }
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (property instanceof SimpleProperty) {
                PropertySetDescriptorItem propitem = simplePropertyTypes.get(propertyName);
                if (propitem != null) {
                    return propitem.getSimplePropertyType();
                }
                return null;
            }
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    return ((EventType[])type)[0].getUnderlyingType();
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                    return innerType.getUnderlyingType();
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return ((Class)type).getComponentType();
            }
            if (property instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)property;
                Object type = nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return Object.class;
                }
                return null;
            }
            return null;
        }
        String propertyMap = StringValue.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyMap);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    return innerType.getPropertyType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getPropertyType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                BeanEventType beanEventType = beanEventTypeFactory.getCreateBeanType(componentType);
                return beanEventType.getPropertyType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return isRootedDynamic ? Object.class : null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parseAndWalk(propertyNested, isRootedDynamic);
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(prop.getPropertyTypeMap(null, beanEventTypeFactory));
        }
        if (nestedType instanceof Map) {
            Property prop = PropertyParser.parseAndWalk(propertyNested, isRootedDynamic);
            Map nestedTypes = (Map)nestedType;
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(prop.getPropertyTypeMap(nestedTypes, beanEventTypeFactory));
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            if (JavaClassHelper.isJavaBuiltinDataType(simpleClass)) {
                return null;
            }
            if (simpleClass.isArray() && (JavaClassHelper.isJavaBuiltinDataType(simpleClass.getComponentType()) || simpleClass.getComponentType() == Object.class)) {
                return null;
            }
            BeanEventType nestedEventType = beanEventTypeFactory.getCreateBeanType(simpleClass);
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(nestedEventType.getPropertyType(propertyNested));
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(innerType.getPropertyType(propertyNested));
        }
        if (nestedType instanceof EventType[]) {
            return null;
        }
        if (nestedType instanceof TypeBeanOrUnderlying) {
            EventType innerType = ((TypeBeanOrUnderlying)nestedType).getEventType();
            if (!(innerType instanceof BaseNestableEventType)) {
                return null;
            }
            return isRootedDynamic ? Object.class : JavaClassHelper.getBoxedType(innerType.getPropertyType(propertyNested));
        }
        if (nestedType instanceof TypeBeanOrUnderlying[]) {
            return null;
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + "' for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public static EventPropertyGetterSPI getNestableGetter(String propertyName, Map<String, PropertySetDescriptorItem> propertyGetters, Map<String, EventPropertyGetterSPI> propertyGetterCache, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNestableGetterFactory factory, boolean isObjectArray, BeanEventTypeFactory beanEventTypeFactory) {
        Object nestedType;
        EventPropertyGetterSPI cachedGetter = propertyGetterCache.get(propertyName);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        String unescapePropName = StringValue.unescapeDot(propertyName);
        PropertySetDescriptorItem item = propertyGetters.get(unescapePropName);
        if (item != null) {
            EventPropertyGetterSPI getter = item.getPropertyGetter();
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyName);
            if (prop instanceof DynamicProperty) {
                DynamicProperty dynamicProperty = (DynamicProperty)prop;
                EventPropertyGetterSPI getterDyn = factory.getPropertyDynamicGetter(nestableTypes, propertyName, dynamicProperty, eventBeanTypedEventFactory, beanEventTypeFactory);
                propertyGetterCache.put(propertyName, getterDyn);
                return getterDyn;
            }
            if (prop instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)prop;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    EventPropertyGetterSPI getterArr = factory.getGetterIndexedEventBean(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex());
                    propertyGetterCache.put(propertyName, getterArr);
                    return getterArr;
                }
                if (type instanceof TypeBeanOrUnderlying) {
                    EventType innerType = ((TypeBeanOrUnderlying)type).getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = factory.getGetterBeanNested(indexedProp.getPropertyNameAtomic(), innerType, eventBeanTypedEventFactory);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventType innerType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = factory.getGetterIndexedUnderlyingArray(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), eventBeanTypedEventFactory, innerType);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventPropertyGetterSPI indexedGetter = factory.getGetterIndexedClassArray(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), eventBeanTypedEventFactory, componentType, beanEventTypeFactory);
                propertyGetterCache.put(propertyName, indexedGetter);
                return indexedGetter;
            }
            if (prop instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)prop;
                Object type = nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return factory.getGetterMappedProperty(mappedProp.getPropertyNameAtomic(), mappedProp.getKey());
                }
                return null;
            }
            return null;
        }
        String propertyMap = StringValue.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parseAndWalkLaxToSimple(propertyMap);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof TypeBeanOrUnderlying[]) {
                    EventTypeSPI innerType = (EventTypeSPI)((TypeBeanOrUnderlying[])type)[0].getEventType();
                    if (!(innerType instanceof BaseNestableEventType)) {
                        return null;
                    }
                    EventPropertyGetterSPI innerGetter = innerType.getGetterSPI(propertyNested);
                    if (innerGetter == null) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = factory.getGetterNestedEntryBeanArray(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), innerGetter, innerType, eventBeanTypedEventFactory);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (type instanceof EventType[]) {
                    EventTypeSPI componentType = (EventTypeSPI)((EventType[])type)[0];
                    EventPropertyGetterSPI nestedGetter = componentType.getGetterSPI(propertyNested);
                    if (nestedGetter == null) {
                        return null;
                    }
                    EventPropertyGetterSPI typeGetter = factory.getGetterIndexedEntryEventBeanArrayElement(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter);
                    propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                BeanEventType nestedEventType = beanEventTypeFactory.getCreateBeanType(componentType);
                BeanEventPropertyGetter nestedGetter = (BeanEventPropertyGetter)nestedEventType.getGetterSPI(propertyNested);
                if (nestedGetter == null) {
                    return null;
                }
                Class propertyTypeGetter = nestedEventType.getPropertyType(propertyNested);
                EventPropertyGetterSPI indexGetter = factory.getGetterIndexedEntryPOJO(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter, eventBeanTypedEventFactory, beanEventTypeFactory, propertyTypeGetter);
                propertyGetterCache.put(propertyName, indexGetter);
                return indexGetter;
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            if (isRootedDynamic) {
                Property prop = PropertyParser.parseAndWalk(propertyNested, true);
                if (!isObjectArray) {
                    EventPropertyGetterSPI getterNested = factory.getGetterRootedDynamicNested(prop, eventBeanTypedEventFactory, beanEventTypeFactory);
                    EventPropertyGetterSPI dynamicGetter = factory.getGetterNestedPropertyProvidedGetterDynamic(nestableTypes, propertyMap, getterNested, eventBeanTypedEventFactory);
                    propertyGetterCache.put(propertyName, dynamicGetter);
                    return dynamicGetter;
                }
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyNested);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(null, eventBeanTypedEventFactory, beanEventTypeFactory);
            if (getterNestedMap == null) {
                return null;
            }
            EventPropertyGetterSPI mapGetter = factory.getGetterNestedMapProp(propertyMap, getterNestedMap);
            propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Map) {
            Map nestedTypes;
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyNested);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(nestedTypes = (Map)nestedType, eventBeanTypedEventFactory, beanEventTypeFactory);
            if (getterNestedMap == null) {
                return null;
            }
            EventPropertyGetterSPI mapGetter = factory.getGetterNestedMapProp(propertyMap, getterNestedMap);
            propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Class) {
            Class propertyComponentType;
            Class propertyType;
            Class simpleClass = (Class)nestedType;
            if (simpleClass.isArray()) {
                return null;
            }
            BeanEventType nestedEventType = beanEventTypeFactory.getCreateBeanType(simpleClass);
            BeanEventPropertyGetter nestedGetter = (BeanEventPropertyGetter)nestedEventType.getGetterSPI(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            EventPropertyDescriptor desc = nestedEventType.getPropertyDescriptor(propertyNested);
            if (desc == null) {
                propertyType = nestedEventType.getPropertyType(propertyNested);
                propertyComponentType = propertyType.isArray() ? propertyType.getComponentType() : JavaClassHelper.getGenericType(propertyType, 0);
            } else {
                propertyType = desc.getPropertyType();
                propertyComponentType = desc.getPropertyComponentType();
            }
            EventPropertyGetterSPI getter = factory.getGetterNestedPOJOProp(propertyMap, nestedGetter, eventBeanTypedEventFactory, beanEventTypeFactory, propertyType, propertyComponentType);
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType) {
            EventTypeSPI innerType = (EventTypeSPI)nestedType;
            EventPropertyGetterSPI nestedGetter = innerType.getGetterSPI(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            EventPropertyGetterSPI getter = factory.getGetterNestedEventBean(propertyMap, nestedGetter);
            propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType[]) {
            EventType[] typeArray = (EventType[])nestedType;
            EventPropertyGetterSPI beanArrGetter = factory.getGetterEventBeanArray(propertyMap, typeArray[0]);
            propertyGetterCache.put(propertyName, beanArrGetter);
            return beanArrGetter;
        }
        if (nestedType instanceof TypeBeanOrUnderlying) {
            EventType innerType = ((TypeBeanOrUnderlying)nestedType).getEventType();
            if (!(innerType instanceof BaseNestableEventType)) {
                return null;
            }
            EventPropertyGetterSPI innerGetter = ((EventTypeSPI)innerType).getGetterSPI(propertyNested);
            if (innerGetter == null) {
                return null;
            }
            EventPropertyGetterSPI outerGetter = factory.getGetterNestedEntryBean(propertyMap, innerGetter, innerType, eventBeanTypedEventFactory);
            propertyGetterCache.put(propertyName, outerGetter);
            return outerGetter;
        }
        if (nestedType instanceof TypeBeanOrUnderlying[]) {
            EventType innerType = ((TypeBeanOrUnderlying[])nestedType)[0].getEventType();
            if (!(innerType instanceof BaseNestableEventType)) {
                return null;
            }
            EventPropertyGetterSPI innerGetter = ((EventTypeSPI)innerType).getGetterSPI(propertyNested);
            if (innerGetter == null) {
                return null;
            }
            EventPropertyGetterSPI outerGetter = factory.getGetterNestedEntryBeanArray(propertyMap, 0, innerGetter, innerType, eventBeanTypedEventFactory);
            propertyGetterCache.put(propertyName, outerGetter);
            return outerGetter;
        }
        String message = "Nestable type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public static LinkedHashMap<String, Object> validateObjectArrayDef(String[] propertyNames, Object[] propertyTypes) {
        if (propertyNames.length != propertyTypes.length) {
            throw new ConfigurationException("Number of property names and property types do not match, found " + propertyNames.length + " property names and " + propertyTypes.length + " property types");
        }
        HashSet<String> propertyNamesSet = new HashSet<String>();
        LinkedHashMap<String, Object> propertyTypesMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (propertyNamesSet.contains(propertyName)) {
                throw new ConfigurationException("Property '" + propertyName + "' is listed twice in the type definition");
            }
            propertyNamesSet.add(propertyName);
            propertyTypesMap.put(propertyName, propertyTypes[i]);
        }
        return propertyTypesMap;
    }

    public static WriteablePropertyDescriptor findWritable(String propertyName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(propertyName)) continue;
            return writable;
        }
        return null;
    }

    public static TimestampPropertyDesc validatedDetermineTimestampProps(EventType type, String startProposed, String endProposed, EventType[] superTypes) throws EPException {
        String startTimestampPropertyName = startProposed;
        String endTimestampPropertyName = endProposed;
        if (superTypes != null && superTypes.length > 0) {
            for (EventType superType : superTypes) {
                if (superType.getStartTimestampPropertyName() != null) {
                    if (startTimestampPropertyName != null && !startTimestampPropertyName.equals(superType.getStartTimestampPropertyName())) {
                        throw EventTypeUtility.getExceptionTimestampInherited("start", startTimestampPropertyName, superType.getStartTimestampPropertyName(), superType);
                    }
                    startTimestampPropertyName = superType.getStartTimestampPropertyName();
                }
                if (superType.getEndTimestampPropertyName() == null) continue;
                if (endTimestampPropertyName != null && !endTimestampPropertyName.equals(superType.getEndTimestampPropertyName())) {
                    throw EventTypeUtility.getExceptionTimestampInherited("end", endTimestampPropertyName, superType.getEndTimestampPropertyName(), superType);
                }
                endTimestampPropertyName = superType.getEndTimestampPropertyName();
            }
        }
        EventTypeUtility.validateTimestampProperties(type, startTimestampPropertyName, endTimestampPropertyName);
        return new TimestampPropertyDesc(startTimestampPropertyName, endTimestampPropertyName);
    }

    private static EPException getExceptionTimestampInherited(String tstype, String firstName, String secondName, EventType superType) {
        String message = "Event type declares " + tstype + " timestamp as property '" + firstName + "' however inherited event type '" + superType.getName() + "' declares " + tstype + " timestamp as property '" + secondName + "'";
        return new EPException(message);
    }

    private static void addRecursiveSupertypes(Set<EventType> superTypes, EventType child) {
        if (child.getSuperTypes() != null) {
            for (int i = 0; i < child.getSuperTypes().length; ++i) {
                superTypes.add(child.getSuperTypes()[i]);
                EventTypeUtility.addRecursiveSupertypes(superTypes, child.getSuperTypes()[i]);
            }
        }
    }

    public static String disallowedAtTypeMessage() {
        return "The @type annotation is only allowed when the invocation target returns EventBean instances";
    }

    public static void validateEventBeanClassVisibility(Class clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new EventAdapterException("Event class '" + clazz.getName() + "' does not have public visibility");
        }
    }

    public static EventPropertyGetterSPI[] getGetters(EventType eventType, String[] props) {
        EventPropertyGetterSPI[] getters = new EventPropertyGetterSPI[props.length];
        EventTypeSPI spi = (EventTypeSPI)eventType;
        for (int i = 0; i < getters.length; ++i) {
            getters[i] = spi.getGetterSPI(props[i]);
        }
        return getters;
    }

    public static Class[] getPropertyTypes(EventType eventType, String[] props) {
        Class[] types = new Class[props.length];
        for (int i = 0; i < props.length; ++i) {
            types[i] = eventType.getPropertyType(props[i]);
        }
        return types;
    }

    public static EventType[] shiftRight(EventType[] src) {
        EventType[] types = new EventType[src.length + 1];
        System.arraycopy(src, 0, types, 1, src.length);
        return types;
    }

    public static String getAdapterForMethodName(EventType eventType) {
        if (eventType instanceof MapEventType) {
            return "adapterForTypedMap";
        }
        if (eventType instanceof ObjectArrayEventType) {
            return "adapterForTypedObjectArray";
        }
        if (eventType instanceof BeanEventType) {
            return "adapterForTypedBean";
        }
        if (eventType instanceof BaseXMLEventType) {
            return "adapterForTypedDOM";
        }
        if (eventType instanceof AvroSchemaEventType) {
            return "adapterForTypedAvro";
        }
        if (eventType instanceof JsonEventType) {
            return "adapterForTypedJson";
        }
        if (eventType instanceof WrapperEventType) {
            return "adapterForTypedWrapper";
        }
        throw new IllegalArgumentException("Unrecognized event type " + eventType);
    }

    public static String getMessageExpecting(String eventTypeName, EventType existingType, String typeOfEventType) {
        String message = "Event type named '" + eventTypeName + "' has not been defined or is not a " + typeOfEventType + " event type";
        message = existingType != null ? message + ", the name '" + eventTypeName + "' refers to a " + JavaClassHelper.getClassNameFullyQualPretty(existingType.getUnderlyingType()) + " event type" : message + ", the name '" + eventTypeName + "' has not been defined as an event type";
        return message;
    }

    public static void validateTypeObjectArray(String eventTypeName, EventType type) {
        if (!(type instanceof ObjectArrayEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "Object-array"));
        }
    }

    public static void validateTypeBean(String eventTypeName, EventType type) {
        if (!(type instanceof BeanEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "Bean-type"));
        }
    }

    public static void validateTypeMap(String eventTypeName, EventType type) {
        if (!(type instanceof MapEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "Map-type"));
        }
    }

    public static void validateTypeJson(String eventTypeName, EventType type) {
        if (!(type instanceof JsonEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "Json-type"));
        }
    }

    public static void validateTypeXMLDOM(String eventTypeName, EventType type) {
        if (!(type instanceof BaseXMLEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "XML-DOM-type"));
        }
    }

    public static void validateTypeAvro(String eventTypeName, EventType type) {
        if (!(type instanceof AvroSchemaEventType)) {
            throw new EPException(EventTypeUtility.getMessageExpecting(eventTypeName, type, "Avro"));
        }
    }

    public static void validateModifiers(String eventTypeName, EventTypeBusModifier eventBusVisibility, NameAccessModifier nameAccessModifier) throws ExprValidationException {
        if (eventBusVisibility != EventTypeBusModifier.BUS) {
            return;
        }
        if (nameAccessModifier != NameAccessModifier.PRECONFIGURED && nameAccessModifier != NameAccessModifier.PUBLIC) {
            throw new ExprValidationException("Event type '" + eventTypeName + "' with bus-visibility requires the public access modifier for the event type");
        }
    }

    public static EventBean[] typeCast(List<EventBean> events, EventType targetType, EventBeanTypedEventFactory eventAdapterService, EventTypeAvroHandler eventTypeAvroHandler) {
        EventBean[] convertedArray = new EventBean[events.size()];
        int count = 0;
        for (EventBean theEvent : events) {
            EventBean converted;
            if (theEvent instanceof DecoratingEventBean) {
                DecoratingEventBean wrapper = (DecoratingEventBean)((Object)theEvent);
                if (targetType instanceof MapEventType) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.putAll(wrapper.getDecoratingProperties());
                    for (EventPropertyDescriptor propDesc : wrapper.getUnderlyingEvent().getEventType().getPropertyDescriptors()) {
                        props.put(propDesc.getPropertyName(), wrapper.getUnderlyingEvent().get(propDesc.getPropertyName()));
                    }
                    converted = eventAdapterService.adapterForTypedMap(props, targetType);
                } else {
                    converted = eventAdapterService.adapterForTypedWrapper(wrapper.getUnderlyingEvent(), wrapper.getDecoratingProperties(), targetType);
                }
            } else if (theEvent.getEventType() instanceof MapEventType && targetType instanceof MapEventType) {
                MappedEventBean mapEvent = (MappedEventBean)theEvent;
                converted = eventAdapterService.adapterForTypedMap(mapEvent.getProperties(), targetType);
            } else if (theEvent.getEventType() instanceof MapEventType && targetType instanceof WrapperEventType) {
                converted = eventAdapterService.adapterForTypedWrapper(theEvent, Collections.EMPTY_MAP, targetType);
            } else if (theEvent.getEventType() instanceof BeanEventType && targetType instanceof BeanEventType) {
                converted = eventAdapterService.adapterForTypedBean(theEvent.getUnderlying(), targetType);
            } else if (theEvent.getEventType() instanceof ObjectArrayEventType && targetType instanceof ObjectArrayEventType) {
                Object[] convertedObjectArray = ObjectArrayEventType.convertEvent(theEvent, (ObjectArrayEventType)targetType);
                converted = eventAdapterService.adapterForTypedObjectArray(convertedObjectArray, targetType);
            } else if (theEvent.getEventType() instanceof AvroSchemaEventType && targetType instanceof AvroSchemaEventType) {
                Object convertedGenericRecord = eventTypeAvroHandler.convertEvent(theEvent, (AvroSchemaEventType)targetType);
                converted = eventAdapterService.adapterForTypedAvro(convertedGenericRecord, targetType);
            } else if (theEvent.getEventType() instanceof JsonEventType && targetType instanceof JsonEventType) {
                Object und = EventTypeUtility.convertJsonEvents(theEvent, (JsonEventType)targetType);
                converted = eventAdapterService.adapterForTypedJson(und, targetType);
            } else {
                throw new EPException("Unknown event type " + theEvent.getEventType());
            }
            convertedArray[count] = converted;
            ++count;
        }
        return convertedArray;
    }

    private static Object convertJsonEvents(EventBean theEvent, JsonEventType targetType) {
        JsonEventObjectBase target;
        try {
            target = (JsonEventObjectBase)targetType.getUnderlyingType().newInstance();
        }
        catch (Exception e) {
            throw new EPException("Failed to allocate instance of Json event: " + e.getMessage(), e);
        }
        JsonEventObjectBase source = (JsonEventObjectBase)theEvent.getUnderlying();
        for (Map.Entry<String, Object> entry : targetType.getTypes().entrySet()) {
            int targetNum = target.getNativeNum(entry.getKey());
            int sourceNum = source.getNativeNum(entry.getKey());
            if (targetNum == -1) continue;
            target.setNativeValue(targetNum, source.getNativeValue(sourceNum));
        }
        return target;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventTypeForgablesPair createNonVariantType(boolean isAnonymous, CreateSchemaDesc spec, String packageName, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        void var8_35;
        EventTypeBusModifier eventBusVisibility;
        NameAccessModifier visibility;
        if (spec.getAssignedType() == CreateSchemaDesc.AssignedType.VARIANT) {
            throw new IllegalStateException("Variant type is not allowed in this context");
        }
        Annotation[] annotations = base.getStatementRawInfo().getAnnotations();
        if (isAnonymous) {
            visibility = NameAccessModifier.TRANSIENT;
            eventBusVisibility = EventTypeBusModifier.NONBUS;
        } else {
            visibility = services.getModuleVisibilityRules().getAccessModifierEventType(base.getStatementRawInfo(), spec.getSchemaName());
            eventBusVisibility = services.getModuleVisibilityRules().getBusModifierEventType(base.getStatementRawInfo(), spec.getSchemaName());
            EventTypeUtility.validateModifiers(spec.getSchemaName(), eventBusVisibility, visibility);
        }
        List<StmtClassForgeableFactory> additionalForgeables = Collections.emptyList();
        if (spec.getTypes().isEmpty()) {
            ConfigurationCommonEventTypeWithSupertype config;
            EventUnderlyingType representation = EventRepresentationUtil.getRepresentation(annotations, services.getConfiguration(), spec.getAssignedType());
            LinkedHashMap<String, Object> typing = EventTypeUtility.buildType(spec.getColumns(), spec.getCopyFrom(), services.getClasspathImportServiceCompileTime(), services.getEventTypeCompileTimeResolver());
            LinkedHashMap<String, Object> compiledTyping = EventTypeUtility.compileMapTypeProperties(typing, services.getEventTypeCompileTimeResolver());
            if (representation == EventUnderlyingType.MAP) {
                config = new ConfigurationCommonEventTypeMap();
            } else if (representation == EventUnderlyingType.OBJECTARRAY) {
                config = new ConfigurationCommonEventTypeObjectArray();
            } else if (representation == EventUnderlyingType.AVRO) {
                config = new ConfigurationCommonEventTypeAvro();
            } else {
                if (representation != EventUnderlyingType.JSON) throw new IllegalStateException("Unrecognized representation '" + (Object)((Object)representation) + "'");
                config = new ConfigurationCommonEventTypeJson();
            }
            if (spec.getInherits() != null) {
                config.getSuperTypes().addAll(spec.getInherits());
                if (spec.getInherits().size() > 1 && (representation == EventUnderlyingType.OBJECTARRAY || representation == EventUnderlyingType.JSON)) {
                    throw new ExprValidationException("Object-array event types only allow a single supertype");
                }
            }
            config.setStartTimestampPropertyName(spec.getStartTimestampProperty());
            config.setEndTimestampPropertyName(spec.getEndTimestampProperty());
            Function<EventTypeApplicationType, EventTypeMetadata> metadataFunc = appType -> new EventTypeMetadata(spec.getSchemaName(), base.getModuleName(), EventTypeTypeClass.STREAM, (EventTypeApplicationType)((Object)appType), visibility, eventBusVisibility, false, EventTypeIdPair.unassigned());
            if (representation == EventUnderlyingType.MAP) {
                Pair<EventType[], Set<EventType>> st = EventTypeUtility.getSuperTypesDepthFirst(config.getSuperTypes(), EventUnderlyingType.MAP, (EventTypeNameResolver)services.getEventTypeCompileTimeResolver());
                EventTypeMetadata metadata = metadataFunc.apply(EventTypeApplicationType.MAP);
                MapEventType mapEventType = BaseNestableEventUtil.makeMapTypeCompileTime(metadata, compiledTyping, st.getFirst(), st.getSecond(), config.getStartTimestampPropertyName(), config.getEndTimestampPropertyName(), services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
            } else if (representation == EventUnderlyingType.OBJECTARRAY) {
                Pair<EventType[], Set<EventType>> st = EventTypeUtility.getSuperTypesDepthFirst(config.getSuperTypes(), EventUnderlyingType.OBJECTARRAY, (EventTypeNameResolver)services.getEventTypeCompileTimeResolver());
                EventTypeMetadata metadata = metadataFunc.apply(EventTypeApplicationType.OBJECTARR);
                ObjectArrayEventType objectArrayEventType = BaseNestableEventUtil.makeOATypeCompileTime(metadata, compiledTyping, st.getFirst(), st.getSecond(), config.getStartTimestampPropertyName(), config.getEndTimestampPropertyName(), services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
            } else if (representation == EventUnderlyingType.AVRO) {
                Pair<EventType[], Set<EventType>> avroSuperTypes = EventTypeUtility.getSuperTypesDepthFirst(config.getSuperTypes(), EventUnderlyingType.AVRO, (EventTypeNameResolver)services.getEventTypeCompileTimeResolver());
                EventTypeMetadata metadata = metadataFunc.apply(EventTypeApplicationType.AVRO);
                AvroSchemaEventType avroSchemaEventType = services.getEventTypeAvroHandler().newEventTypeFromNormalized(metadata, services.getEventTypeCompileTimeResolver(), services.getBeanEventTypeFactoryPrivate().getEventBeanTypedEventFactory(), compiledTyping, annotations, (ConfigurationCommonEventTypeAvro)config, avroSuperTypes.getFirst(), avroSuperTypes.getSecond(), base.getStatementName());
            } else {
                if (representation != EventUnderlyingType.JSON) throw new IllegalStateException("Unrecognized representation " + (Object)((Object)representation));
                Pair<EventType[], Set<EventType>> st = EventTypeUtility.getSuperTypesDepthFirst(config.getSuperTypes(), EventUnderlyingType.JSON, (EventTypeNameResolver)services.getEventTypeCompileTimeResolver());
                EventTypeMetadata metadata = metadataFunc.apply(EventTypeApplicationType.JSON);
                EventTypeForgablesPair desc = JsonEventTypeUtility.makeJsonTypeCompileTimeNewType(metadata, compiledTyping, st, config, base.getStatementRawInfo(), services);
                EventType eventType = desc.getEventType();
                additionalForgeables = desc.getAdditionalForgeables();
            }
        } else {
            if (spec.getCopyFrom() != null && !spec.getCopyFrom().isEmpty()) {
                throw new ExprValidationException("Copy-from types are not allowed with class-provided types");
            }
            if (spec.getTypes().size() != 1) {
                throw new IllegalStateException("Multiple types provided");
            }
            try {
                String name = spec.getTypes().iterator().next();
                Class clazz = services.getClasspathImportServiceCompileTime().resolveClassForBeanEventType(name);
                BeanEventTypeStem stem = services.getBeanEventTypeStemService().getCreateStem(clazz, null);
                EventTypeMetadata metadata = new EventTypeMetadata(spec.getSchemaName(), base.getModuleName(), EventTypeTypeClass.STREAM, EventTypeApplicationType.CLASS, visibility, eventBusVisibility, false, EventTypeIdPair.unassigned());
                EventType[] superTypes = EventTypeUtility.getSuperTypes(stem.getSuperTypes(), services);
                Set<EventType> deepSuperTypes = EventTypeUtility.getDeepSupertypes(stem.getDeepSuperTypes(), services);
                BeanEventType beanEventType = new BeanEventType(stem, metadata, services.getBeanEventTypeFactoryPrivate(), superTypes, deepSuperTypes, spec.getStartTimestampProperty(), spec.getEndTimestampProperty());
            }
            catch (ClasspathImportException ex) {
                throw new ExprValidationException(ex.getMessage(), ex);
            }
        }
        services.getEventTypeCompileTimeRegistry().newType((EventType)var8_35);
        return new EventTypeForgablesPair((EventType)var8_35, additionalForgeables);
    }

    private static boolean allowPopulate(EventTypeSPI typeSPI) {
        EventTypeMetadata metadata = typeSPI.getMetadata();
        if (metadata.getTypeClass() == EventTypeTypeClass.STREAM || metadata.getTypeClass() == EventTypeTypeClass.APPLICATION) {
            return true;
        }
        return metadata.getTypeClass() == EventTypeTypeClass.STATEMENTOUT || metadata.getTypeClass() == EventTypeTypeClass.TABLE_INTERNAL;
    }

    private static EventType[] getSuperTypes(Class[] superTypes, StatementCompileTimeServices services) {
        if (superTypes == null || superTypes.length == 0) {
            return null;
        }
        EventType[] types = new EventType[superTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = EventTypeUtility.resolveOrCreateType(superTypes[i], services);
        }
        return types;
    }

    private static Set<EventType> getDeepSupertypes(Set<Class> superTypes, StatementCompileTimeServices services) {
        if (superTypes == null || superTypes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<EventType> supers = new LinkedHashSet<EventType>(4);
        for (Class clazz : superTypes) {
            supers.add(EventTypeUtility.resolveOrCreateType(clazz, services));
        }
        return supers;
    }

    private static EventType resolveOrCreateType(Class clazz, StatementCompileTimeServices services) {
        services.getEventTypeCompileTimeResolver();
        Collection<EventType> moduleTypes = services.getEventTypeCompileTimeRegistry().getNewTypesAdded();
        for (EventType eventType2 : moduleTypes) {
            if (!EventTypeUtility.matches(eventType2, clazz)) continue;
            return eventType2;
        }
        PathRegistry<String, EventType> pathRegistry = services.getEventTypeCompileTimeResolver().getPath();
        ArrayList found = new ArrayList();
        pathRegistry.traverse(eventType -> {
            if (EventTypeUtility.matches(eventType, clazz)) {
                found.add(eventType);
            }
        });
        if (found.size() > 1) {
            throw new EPException("Found multiple parent types in path for classs '" + clazz + "'");
        }
        if (!found.isEmpty()) {
            return (EventType)found.get(0);
        }
        return services.getBeanEventTypeFactoryPrivate().getCreateBeanType(clazz);
    }

    private static boolean matches(EventType eventType, Class clazz) {
        if (!(eventType instanceof BeanEventType)) {
            return false;
        }
        BeanEventType beanEventType = (BeanEventType)eventType;
        return beanEventType.getStem().getClazz() == clazz;
    }

    public static EventBeanAdapterFactory getAdapterFactoryForType(EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeAvroHandler eventTypeAvroHandler) {
        if (eventType instanceof BeanEventType) {
            return new EventBeanAdapterFactoryBean(eventType, eventBeanTypedEventFactory);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new EventBeanAdapterFactoryObjectArray(eventType, eventBeanTypedEventFactory);
        }
        if (eventType instanceof MapEventType) {
            return new EventBeanAdapterFactoryMap(eventType, eventBeanTypedEventFactory);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new EventBeanAdapterFactoryXml(eventType, eventBeanTypedEventFactory);
        }
        if (eventType instanceof AvroSchemaEventType) {
            return new EventBeanAdapterFactoryAvro(eventType, eventTypeAvroHandler);
        }
        throw new EventAdapterException("Event type '" + eventType.getName() + "' is not an runtime-native event type");
    }

    public static class EventBeanAdapterFactoryAvro
    implements EventBeanAdapterFactory {
        private final EventType eventType;
        private final EventTypeAvroHandler eventTypeAvroHandler;

        public EventBeanAdapterFactoryAvro(EventType eventType, EventTypeAvroHandler eventTypeAvroHandler) {
            this.eventType = eventType;
            this.eventTypeAvroHandler = eventTypeAvroHandler;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return this.eventTypeAvroHandler.adapterForTypeAvro(underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryXml
    implements EventBeanAdapterFactory {
        private final EventType eventType;
        private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

        public EventBeanAdapterFactoryXml(EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
            this.eventType = eventType;
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return this.eventBeanTypedEventFactory.adapterForTypedDOM((Node)underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryObjectArray
    implements EventBeanAdapterFactory {
        private final EventType eventType;
        private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

        public EventBeanAdapterFactoryObjectArray(EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
            this.eventType = eventType;
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return this.eventBeanTypedEventFactory.adapterForTypedObjectArray((Object[])underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryMap
    implements EventBeanAdapterFactory {
        private final EventType eventType;
        private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

        public EventBeanAdapterFactoryMap(EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
            this.eventType = eventType;
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return this.eventBeanTypedEventFactory.adapterForTypedMap((Map)underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryBean
    implements EventBeanAdapterFactory {
        private final EventType eventType;
        private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

        public EventBeanAdapterFactoryBean(EventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
            this.eventType = eventType;
            this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return this.eventBeanTypedEventFactory.adapterForTypedBean(underlying, this.eventType);
        }
    }

    public static class TimestampPropertyDesc {
        private final String start;
        private final String end;

        public TimestampPropertyDesc(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }
    }
}

