/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.JsonSchema;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeWithSupertype;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.util.ParentClassLoader;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeForgablesPair;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDelegate;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDelegateFactory;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonUnderlying;
import com.espertech.esper.common.internal.event.json.core.EventTypeNestableGetterFactoryJson;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventTypeDetail;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeNull;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeFactoryClassTyped;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeFactoryEventTypeTyped;
import com.espertech.esper.common.internal.event.json.write.JsonWriteForgeNull;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonEventTypeUtility {
    public static JsonEventType makeJsonTypeCompileTimeExistingType(EventTypeMetadata metadata, JsonEventType existingType, StatementCompileTimeServices services) {
        EventTypeNestableGetterFactoryJson getterFactoryJson = new EventTypeNestableGetterFactoryJson(existingType.getDetail());
        return new JsonEventType(metadata, existingType.getTypes(), null, Collections.emptySet(), existingType.getStartTimestampPropertyName(), existingType.getEndTimestampPropertyName(), getterFactoryJson, services.getBeanEventTypeFactoryPrivate(), existingType.getDetail(), existingType.getUnderlyingType());
    }

    public static EventTypeForgablesPair makeJsonTypeCompileTimeNewType(EventTypeMetadata metadata, Map<String, Object> compiledTyping, Pair<EventType[], Set<EventType>> superTypes, ConfigurationCommonEventTypeWithSupertype config, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        JsonSchema jsonSchema;
        if (metadata.getApplicationType() != EventTypeApplicationType.JSON) {
            throw new IllegalStateException("Expected Json application type");
        }
        final JsonEventType optionalSuperType = (JsonEventType)(superTypes == null ? null : (superTypes.getFirst() == null || superTypes.getFirst().length == 0 ? null : superTypes.getFirst()[0]));
        final int numFieldsSuperType = optionalSuperType == null ? 0 : optionalSuperType.getDetail().getFieldDescriptors().size();
        Map<String, Object> properties = BaseNestableEventUtil.resolvePropertyTypes(compiledTyping, services.getEventTypeCompileTimeResolver());
        properties = JsonEventTypeUtility.removeEventBeanTypes(properties);
        Map<String, String> fieldNames = JsonEventTypeUtility.computeFieldNames(properties);
        final Map<String, JsonUnderlyingField> fieldDescriptors = JsonEventTypeUtility.computeFields(properties, fieldNames, optionalSuperType);
        final Map<String, JsonForgeDesc> forges = JsonEventTypeUtility.computeValueForges(properties);
        final boolean dynamic = optionalSuperType != null && optionalSuperType.getDetail().isDynamic() ? true : (jsonSchema = (JsonSchema)AnnotationUtil.findAnnotation(raw.getAnnotations(), JsonSchema.class)) != null && jsonSchema.dynamic();
        String jsonClassName = metadata.getName();
        if (metadata.getAccessModifier().isPrivateOrTransient()) {
            String uuid = CodeGenerationIDGenerator.generateClassNameUUID();
            jsonClassName = jsonClassName + "__" + uuid;
        } else if (raw.getModuleName() != null) {
            jsonClassName = jsonClassName + "__module_" + raw.getModuleName();
        }
        final String underlyingClassName = jsonClassName;
        final Map<String, Object> propertySet = properties;
        StmtClassForgeableFactory underlying = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonUnderlying(underlyingClassName, packageScope, propertySet, fieldDescriptors, dynamic, numFieldsSuperType, optionalSuperType, forges);
            }
        };
        final String delegateClassName = jsonClassName + "__Delegate";
        StmtClassForgeableFactory delegate = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonDelegate(delegateClassName, packageScope, propertySet, fieldDescriptors, forges, underlyingClassName, dynamic, optionalSuperType);
            }
        };
        final String delegateFactoryClassName = jsonClassName + "__Factory";
        StmtClassForgeableFactory delegateFactory = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonDelegateFactory(delegateFactoryClassName, packageScope, delegateClassName, underlyingClassName);
            }
        };
        String underlyingClassNameFull = services.getPackageName() + "." + underlyingClassName;
        String delegateClassNameFull = services.getPackageName() + "." + delegateClassName;
        String delegateFactoryClassNameFull = services.getPackageName() + "." + delegateFactoryClassName;
        String serdeClassNameFull = services.getPackageName() + "." + jsonClassName + "__Serde";
        JsonEventTypeDetail detail = new JsonEventTypeDetail(underlyingClassNameFull, delegateClassNameFull, delegateFactoryClassNameFull, serdeClassNameFull, fieldDescriptors, dynamic, numFieldsSuperType);
        EventTypeNestableGetterFactoryJson getterFactoryJson = new EventTypeNestableGetterFactoryJson(detail);
        Class standIn = services.getCompilerServices().compileStandInClass(CodegenClassType.JSONEVENT, underlyingClassName, services.getServices());
        JsonEventType eventType = new JsonEventType(metadata, properties, superTypes == null ? new EventType[]{} : superTypes.getFirst(), superTypes == null ? Collections.emptySet() : superTypes.getSecond(), config == null ? null : config.getStartTimestampPropertyName(), config == null ? null : config.getEndTimestampPropertyName(), getterFactoryJson, services.getBeanEventTypeFactoryPrivate(), detail, standIn);
        return new EventTypeForgablesPair(eventType, Arrays.asList(underlying, delegate, delegateFactory));
    }

    private static Map<String, Object> removeEventBeanTypes(Map<String, Object> properties) {
        LinkedHashMap<String, Object> verified = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            EventType eventType;
            String propertyName = prop.getKey();
            Object propertyType = prop.getValue();
            verified.put(propertyName, propertyType);
            if (propertyType instanceof EventType) {
                eventType = (EventType)propertyType;
                verified.put(propertyName, new TypeBeanOrUnderlying(eventType));
                continue;
            }
            if (!(propertyType instanceof EventType[])) continue;
            eventType = ((EventType[])propertyType)[0];
            verified.put(propertyName, new TypeBeanOrUnderlying[]{new TypeBeanOrUnderlying(eventType)});
        }
        return verified;
    }

    private static Map<String, JsonForgeDesc> computeValueForges(Map<String, Object> compiledTyping) throws ExprValidationException {
        HashMap<String, JsonForgeDesc> valueForges = new HashMap<String, JsonForgeDesc>();
        for (Map.Entry<String, Object> entry : compiledTyping.entrySet()) {
            EventType eventType;
            JsonForgeDesc forgeDesc;
            Object type = entry.getValue();
            if (type == null) {
                forgeDesc = new JsonForgeDesc(null, null, JsonEndValueForgeNull.INSTANCE, JsonWriteForgeNull.INSTANCE);
            } else if (type instanceof Class) {
                Class clazz = (Class)type;
                forgeDesc = JsonForgeFactoryClassTyped.forge(clazz);
            } else if (type instanceof TypeBeanOrUnderlying) {
                eventType = ((TypeBeanOrUnderlying)type).getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(eventType);
                forgeDesc = eventType instanceof JsonEventType ? JsonForgeFactoryEventTypeTyped.forgeNonArray((JsonEventType)eventType) : JsonForgeFactoryClassTyped.forge(Map.class);
            } else if (type instanceof TypeBeanOrUnderlying[]) {
                eventType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(eventType);
                forgeDesc = eventType instanceof JsonEventType ? JsonForgeFactoryEventTypeTyped.forgeArray((JsonEventType)eventType) : JsonForgeFactoryClassTyped.forge(Map[].class);
            } else {
                throw new IllegalStateException("Unrecognized type " + type);
            }
            valueForges.put(entry.getKey(), forgeDesc);
        }
        return valueForges;
    }

    private static void validateJsonOrMapType(EventType eventType) throws ExprValidationException {
        if (!(eventType instanceof JsonEventType) && !(eventType instanceof MapEventType)) {
            throw new ExprValidationException("Failed to validate event type '" + eventType.getMetadata().getName() + "', expected a Json or Map event type");
        }
    }

    private static Map<String, JsonUnderlyingField> computeFields(Map<String, Object> compiledTyping, Map<String, String> fieldNames, JsonEventType optionalSuperType) throws ExprValidationException {
        LinkedHashMap<String, JsonUnderlyingField> allFieldsInclSupertype = new LinkedHashMap<String, JsonUnderlyingField>();
        int index = 0;
        if (optionalSuperType != null) {
            allFieldsInclSupertype.putAll(optionalSuperType.getDetail().getFieldDescriptors());
            index = allFieldsInclSupertype.size();
        }
        for (Map.Entry<String, Object> entry : compiledTyping.entrySet()) {
            EventType other;
            Class assignedType;
            String fieldName = fieldNames.get(entry.getKey());
            Object type = entry.getValue();
            if (type == null) {
                assignedType = Object.class;
            } else if (type instanceof Class) {
                assignedType = (Class)type;
            } else if (type instanceof TypeBeanOrUnderlying) {
                other = ((TypeBeanOrUnderlying)type).getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(other);
                assignedType = JsonEventTypeUtility.getAssignedType(other);
            } else if (type instanceof TypeBeanOrUnderlying[]) {
                other = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(other);
                assignedType = JavaClassHelper.getArrayType(JsonEventTypeUtility.getAssignedType(other));
            } else {
                throw new IllegalStateException("Unrecognized type " + type);
            }
            allFieldsInclSupertype.put(entry.getKey(), new JsonUnderlyingField(fieldName, index, assignedType));
            ++index;
        }
        return allFieldsInclSupertype;
    }

    private static Class getAssignedType(EventType type) throws ExprValidationException {
        if (type instanceof JsonEventType) {
            return type.getUnderlyingType();
        }
        if (type instanceof MapEventType) {
            return Map.class;
        }
        throw new ExprValidationException("Incompatible type '" + type.getName() + "' encountered, expected a Json or Map event type");
    }

    private static Map<String, String> computeFieldNames(Map<String, Object> compiledTyping) {
        HashMap<String, String> fields = new HashMap<String, String>();
        HashSet<String> assignedNames = new HashSet<String>();
        for (String name : compiledTyping.keySet()) {
            String assigned = "_" + IdentifierUtil.getIdentifierMayStartNumeric(name.toLowerCase(Locale.ENGLISH));
            if (!assignedNames.add(assigned)) {
                int suffix = 0;
                while (true) {
                    String withSuffix;
                    if (!assignedNames.contains(withSuffix = assigned + "_" + suffix)) {
                        assigned = withSuffix;
                        assignedNames.add(assigned);
                        break;
                    }
                    ++suffix;
                }
            }
            fields.put(name, assigned);
        }
        return fields;
    }

    public static void addJsonUnderlyingClass(Map<String, EventType> moduleTypes, ParentClassLoader classLoaderParent, String optionalDeploymentId) {
        for (Map.Entry<String, EventType> eventType : moduleTypes.entrySet()) {
            JsonEventTypeUtility.addJsonUnderlyingClassInternal(eventType.getValue(), classLoaderParent, optionalDeploymentId);
        }
    }

    public static void addJsonUnderlyingClass(PathRegistry<String, EventType> pathEventTypes, ParentClassLoader classLoaderParent) {
        pathEventTypes.traverse(type -> JsonEventTypeUtility.addJsonUnderlyingClassInternal(type, classLoaderParent, null));
    }

    private static void addJsonUnderlyingClassInternal(EventType eventType, ParentClassLoader classLoaderParent, String optionalDeploymentId) {
        if (!(eventType instanceof JsonEventType)) {
            return;
        }
        JsonEventType jsonEventType = (JsonEventType)eventType;
        boolean allowDuplicate = eventType.getMetadata().getTypeClass() == EventTypeTypeClass.NAMED_WINDOW;
        classLoaderParent.add(jsonEventType.getDetail().getUnderlyingClassName(), jsonEventType.getUnderlyingType(), optionalDeploymentId, allowDuplicate);
        classLoaderParent.add(jsonEventType.getDetail().getDelegateClassName(), jsonEventType.getDelegateType(), optionalDeploymentId, allowDuplicate);
        classLoaderParent.add(jsonEventType.getDetail().getDelegateFactoryClassName(), jsonEventType.getDelegateFactory().getClass(), optionalDeploymentId, allowDuplicate);
    }
}

