/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableRSPFactoryProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateJsonGenericArray;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateJsonGenericObject;
import com.espertech.esper.common.internal.event.json.parser.core.JsonHandlerDelegator;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonDelegateRefs;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StmtClassForgeableJsonDelegate
implements StmtClassForgeable {
    private final String className;
    private final CodegenPackageScope packageScope;
    private final Map<String, Object> properties;
    private final Map<String, JsonUnderlyingField> fieldDescriptors;
    private final Map<String, JsonForgeDesc> forges;
    private final String underlyingClassName;
    private final boolean dynamic;
    private final JsonEventType optionalSuperType;

    public StmtClassForgeableJsonDelegate(String className, CodegenPackageScope packageScope, Map<String, Object> properties, Map<String, JsonUnderlyingField> fieldDescriptors, Map<String, JsonForgeDesc> forges, String underlyingClassName, boolean dynamic, JsonEventType optionalSuperType) {
        this.className = className;
        this.packageScope = packageScope;
        this.properties = properties;
        this.fieldDescriptors = fieldDescriptors;
        this.forges = forges;
        this.underlyingClassName = underlyingClassName;
        this.dynamic = dynamic;
        this.optionalSuperType = optionalSuperType;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(2);
        members.add(new CodegenTypedParam(this.underlyingClassName, "bean"));
        CodegenTypedParam delegatorParam = new CodegenTypedParam(JsonHandlerDelegator.class, "delegator", false, false);
        CodegenTypedParam parentParam = new CodegenTypedParam(JsonDelegateBase.class, "parent", false, false);
        CodegenTypedParam beanParam = new CodegenTypedParam(this.underlyingClassName, "bean", false, false);
        List<CodegenTypedParam> ctorParams = Arrays.asList(delegatorParam, parentParam, beanParam);
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, ctorParams);
        if (this.optionalSuperType != null) {
            ctor.getBlock().superCtor(CodegenExpressionBuilder.ref("delegator"), CodegenExpressionBuilder.ref("parent"), CodegenExpressionBuilder.ref("bean"));
        } else {
            ctor.getBlock().superCtor(CodegenExpressionBuilder.ref("delegator"), CodegenExpressionBuilder.ref("parent"));
        }
        ctor.getBlock().assignRef(CodegenExpressionBuilder.ref("this.bean"), (CodegenExpression)CodegenExpressionBuilder.ref("bean"));
        CodegenMethod startObjectMethod = CodegenMethod.makeParentNode(JsonDelegateBase.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(String.class, "name");
        if (this.optionalSuperType != null) {
            startObjectMethod.getBlock().declareVar(JsonDelegateBase.class, "delegate", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "startObject", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("delegate"))).blockReturn(CodegenExpressionBuilder.ref("delegate"));
        }
        for (String property : this.properties.keySet()) {
            JsonForgeDesc forge = this.forges.get(property);
            if (forge.getOptionalStartObjectForge() == null) continue;
            startObjectMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(property))).blockReturn(forge.getOptionalStartObjectForge().newDelegate(JsonDelegateRefs.INSTANCE, startObjectMethod, classScope));
        }
        CodegenExpression resultStartObject = this.dynamic ? CodegenExpressionBuilder.newInstance(JsonDelegateJsonGenericObject.class, JsonDelegateRefs.INSTANCE.getBaseHandler(), JsonDelegateRefs.INSTANCE.getThis()) : CodegenExpressionBuilder.constantNull();
        startObjectMethod.getBlock().methodReturn(resultStartObject);
        CodegenMethod startArrayMethod = CodegenMethod.makeParentNode(JsonDelegateBase.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(String.class, "name");
        if (this.optionalSuperType != null) {
            startArrayMethod.getBlock().declareVar(JsonDelegateBase.class, "delegate", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "startArray", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("delegate"))).blockReturn(CodegenExpressionBuilder.ref("delegate"));
        }
        for (String property : this.properties.keySet()) {
            JsonForgeDesc forge = this.forges.get(property);
            if (forge.getOptionalStartArrayForge() == null) continue;
            startArrayMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(property))).blockReturn(forge.getOptionalStartArrayForge().newDelegate(JsonDelegateRefs.INSTANCE, startArrayMethod, classScope));
        }
        CodegenExpression resultStartArray = this.dynamic ? CodegenExpressionBuilder.newInstance(JsonDelegateJsonGenericArray.class, JsonDelegateRefs.INSTANCE.getBaseHandler(), JsonDelegateRefs.INSTANCE.getThis()) : CodegenExpressionBuilder.constantNull();
        startArrayMethod.getBlock().methodReturn(resultStartArray);
        CodegenMethod endObjectValueMethod = CodegenMethod.makeParentNode(Boolean.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(String.class, "name");
        if (this.optionalSuperType != null) {
            endObjectValueMethod.getBlock().declareVar(Boolean.TYPE, "handled", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "endObjectValue", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.ref("handled")).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            if (entry.getValue() == null) continue;
            String fieldName = this.fieldDescriptors.get(entry.getKey()).getFieldName();
            JsonForgeDesc forge = this.forges.get(entry.getKey());
            CodegenExpression value = forge.getEndValueForge().captureValue(JsonEndValueRefs.INSTANCE, endObjectValueMethod, classScope);
            endObjectValueMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(entry.getKey()))).assignRef(CodegenExpressionBuilder.ref("bean." + fieldName), value).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        if (this.dynamic) {
            endObjectValueMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("this"), "addGeneralJson", CodegenExpressionBuilder.ref("bean.__dyn"), CodegenExpressionBuilder.ref("name"));
        }
        endObjectValueMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantFalse());
        CodegenMethod getResultMethod = CodegenMethod.makeParentNode(this.underlyingClassName, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getResultMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("bean"));
        CodegenClassMethods codegenClassMethods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(startObjectMethod, "startObject", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(startArrayMethod, "startArray", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(endObjectValueMethod, "endObjectValue", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(getResultMethod, "getResult", codegenClassMethods);
        CodegenClass clazz = new CodegenClass(CodegenClassType.JSONDELEGATEFACTORY, this.className, classScope, members, ctor, codegenClassMethods, Collections.emptyList());
        if (this.optionalSuperType == null) {
            clazz.getSupers().setClassExtended(JsonDelegateBase.class);
        } else {
            clazz.getSupers().setClassExtended(this.optionalSuperType.getDetail().getDelegateClassName());
        }
        return clazz;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.JSONDELEGATE;
    }
}

