/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementSwitch;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import com.espertech.esper.common.internal.event.json.write.JsonWriteForgeRefs;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StmtClassForgeableJsonUnderlying
implements StmtClassForgeable {
    public static final String DYNAMIC_PROP_FIELD = "__dyn";
    private final String className;
    private final CodegenPackageScope packageScope;
    private final Map<String, Object> propertiesThisType;
    private final Map<String, JsonUnderlyingField> fieldDescriptorsInclSupertype;
    private final boolean dynamic;
    private final int numFieldsSupertype;
    private final JsonEventType optionalSupertype;
    private final Map<String, JsonForgeDesc> forges;

    public StmtClassForgeableJsonUnderlying(String className, CodegenPackageScope packageScope, Map<String, Object> propertiesThisType, Map<String, JsonUnderlyingField> fieldDescriptorsInclSupertype, boolean dynamic, int numFieldsSupertype, JsonEventType optionalSupertype, Map<String, JsonForgeDesc> forges) {
        this.className = className;
        this.packageScope = packageScope;
        this.propertiesThisType = propertiesThisType;
        this.fieldDescriptorsInclSupertype = fieldDescriptorsInclSupertype;
        this.dynamic = dynamic;
        this.numFieldsSupertype = numFieldsSupertype;
        this.optionalSupertype = optionalSupertype;
        this.forges = forges;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableJsonUnderlying.class, includeDebugSymbols, Collections.emptyList());
        if (this.needDynamic()) {
            ctor.getBlock().assignRef(DYNAMIC_PROP_FIELD, CodegenExpressionBuilder.newInstance(LinkedHashMap.class, new CodegenExpression[0]));
        }
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        ArrayList<CodegenTypedParam> explicitMembers = new ArrayList<CodegenTypedParam>(this.propertiesThisType.size());
        if (this.needDynamic()) {
            explicitMembers.add(new CodegenTypedParam(Map.class, DYNAMIC_PROP_FIELD, false, true));
        }
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            explicitMembers.add(new CodegenTypedParam(field.getPropertyType(), field.getFieldName(), false, true));
        }
        CodegenMethod getNativeSizeMethod = CodegenMethod.makeParentNode(Integer.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getNativeSizeMethod.getBlock().methodReturn(CodegenExpressionBuilder.constant(this.propertiesThisType.size() + this.numFieldsSupertype));
        CodegenStackGenerator.recursiveBuildStack(getNativeSizeMethod, "getNativeSize", methods);
        CodegenMethod getNativeEntryMethod = CodegenMethod.makeParentNode(Map.Entry.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num");
        this.makeGetNativeEntry(getNativeEntryMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeEntryMethod, "getNativeEntry", methods);
        CodegenMethod getNativeKey = CodegenMethod.makeParentNode(String.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num");
        this.makeGetNativeKey(getNativeKey);
        CodegenStackGenerator.recursiveBuildStack(getNativeKey, "getNativeKey", methods);
        CodegenMethod nativeContainsKeyMethod = CodegenMethod.makeParentNode(Boolean.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Object.class, "name");
        this.makeNativeContainsKey(nativeContainsKeyMethod);
        CodegenStackGenerator.recursiveBuildStack(nativeContainsKeyMethod, "nativeContainsKey", methods);
        CodegenMethod getNativeValueMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num");
        this.makeGetNativeValueMethod(getNativeValueMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeValueMethod, "getNativeValue", methods);
        CodegenMethod getNativeNumMethod = CodegenMethod.makeParentNode(Integer.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(String.class, "name");
        this.makeGetNativeNum(getNativeNumMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(getNativeNumMethod, "getNativeNum", methods);
        CodegenMethod setNativeValueMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num").addParam(Object.class, "value");
        this.makeSetNativeValue(setNativeValueMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(setNativeValueMethod, "setNativeValue", methods);
        CodegenMethod nativeWriteMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(JsonWriter.class, "writer").addThrown(IOException.class);
        this.makeNativeWrite(nativeWriteMethod, classScope);
        CodegenStackGenerator.recursiveBuildStack(nativeWriteMethod, "nativeWrite", methods);
        if (!this.parentDynamic()) {
            CodegenMethod addJsonValueMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(String.class, "name").addParam(Object.class, "value");
            if (this.needDynamic()) {
                addJsonValueMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(DYNAMIC_PROP_FIELD), "put", CodegenExpressionBuilder.ref("name"), CodegenExpressionBuilder.ref("value"));
            }
            CodegenStackGenerator.recursiveBuildStack(addJsonValueMethod, "addJsonValue", methods);
            CodegenMethod getJsonValuesMethod = CodegenMethod.makeParentNode(Map.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
            getJsonValuesMethod.getBlock().methodReturn(this.dynamic ? CodegenExpressionBuilder.ref(DYNAMIC_PROP_FIELD) : CodegenExpressionBuilder.publicConstValue(Collections.class, "EMPTY_MAP"));
            CodegenStackGenerator.recursiveBuildStack(getJsonValuesMethod, "getJsonValues", methods);
        }
        CodegenClass clazz = new CodegenClass(CodegenClassType.JSONEVENT, this.className, classScope, explicitMembers, ctor, methods, Collections.emptyList());
        if (this.optionalSupertype == null) {
            clazz.getSupers().setClassExtended(JsonEventObjectBase.class);
        } else {
            clazz.getSupers().setClassExtended(this.optionalSupertype.getUnderlyingType());
        }
        return clazz;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.JSONEVENT;
    }

    private void makeNativeWrite(CodegenMethod method, CodegenClassScope classScope) {
        boolean first = true;
        if (this.optionalSupertype != null && !this.optionalSupertype.getTypes().isEmpty()) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("super"), "nativeWrite", CodegenExpressionBuilder.ref("writer"));
            first = false;
        }
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            JsonForgeDesc forge = this.forges.get(property.getKey());
            String fieldName = field.getFieldName();
            if (!first) {
                method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeObjectSeparator", new CodegenExpression[0]);
            }
            first = false;
            CodegenExpression write = forge.getWriteForge().codegenWrite(new JsonWriteForgeRefs(CodegenExpressionBuilder.ref("writer"), CodegenExpressionBuilder.ref(fieldName), CodegenExpressionBuilder.constant(property.getKey())), method, classScope);
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberName", CodegenExpressionBuilder.constant(property.getKey())).exprDotMethod(CodegenExpressionBuilder.ref("writer"), "writeMemberSeparator", new CodegenExpression[0]).expression(write);
        }
    }

    private void makeGetNativeNum(CodegenMethod method, CodegenClassScope classScope) {
        if (this.numFieldsSupertype > 0) {
            method.getBlock().declareVar(Integer.TYPE, "parent", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeNum", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("parent"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(-1))).blockReturn(CodegenExpressionBuilder.ref("parent"));
        }
        CodegenExpression[] expressions = new CodegenExpression[this.propertiesThisType.size()];
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            expressions[field.getPropertyNumber() - this.numFieldsSupertype] = CodegenExpressionBuilder.constant(property.getKey());
        }
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("name"), expressions, true, false);
        for (int i = 0; i < switchStmt.getBlocks().length; ++i) {
            switchStmt.getBlocks()[i].blockReturn(CodegenExpressionBuilder.constant(this.numFieldsSupertype + i));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.constant(-1));
    }

    private void makeGetNativeValueMethod(CodegenMethod method, CodegenClassScope classScope) {
        if (this.numFieldsSupertype > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.numFieldsSupertype))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeValue", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = this.getCasesNumberNtoM();
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        this.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.ref(field.getFieldName()));
            ++index;
        }
    }

    private void makeSetNativeValue(CodegenMethod method, CodegenClassScope classScope) {
        if (this.numFieldsSupertype > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.numFieldsSupertype))).exprDotMethod(CodegenExpressionBuilder.ref("super"), "setNativeValue", CodegenExpressionBuilder.ref("num"), CodegenExpressionBuilder.ref("value")).blockReturnNoValue();
        }
        CodegenExpression[] cases = this.getCasesNumberNtoM();
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, false, false);
        this.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        CodegenBlock[] blocks = switchStmt.getBlocks();
        int index = 0;
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            String fieldName = field.getFieldName();
            Object type = this.propertiesThisType.get(property.getKey());
            if (type != null) {
                if (type instanceof Class) {
                    blocks[index].assignRef(fieldName, CodegenExpressionBuilder.cast((Class)type, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                } else if (type instanceof TypeBeanOrUnderlying) {
                    EventType eventType = ((TypeBeanOrUnderlying)type).getEventType();
                    if (eventType instanceof JsonEventType) {
                        JsonEventType jsonEventType = (JsonEventType)eventType;
                        CodegenExpression castAsBean = CodegenExpressionBuilder.castUnderlying(jsonEventType.getDetail().getUnderlyingClassName(), CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                        CodegenExpression castUnd = CodegenExpressionBuilder.cast(jsonEventType.getDetail().getUnderlyingClassName(), (CodegenExpression)CodegenExpressionBuilder.ref("value"));
                        blocks[index].assignRef(fieldName, CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), EventBean.class), castAsBean, castUnd));
                    } else {
                        CodegenExpression castAsBean = CodegenExpressionBuilder.castUnderlying(Map.class, CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
                        CodegenExpression castUnd = CodegenExpressionBuilder.cast(Map.class, (CodegenExpression)CodegenExpressionBuilder.ref("value"));
                        blocks[index].assignRef(fieldName, CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), EventBean.class), castAsBean, castUnd));
                    }
                } else if (type instanceof TypeBeanOrUnderlying[]) {
                    TypeBeanOrUnderlying[] typeDef = (TypeBeanOrUnderlying[])type;
                    EventType eventType = typeDef[0].getEventType();
                    Class arrayType = JavaClassHelper.getArrayType(eventType.getUnderlyingType());
                    blocks[index].ifRefNull("value").assignRef(fieldName, CodegenExpressionBuilder.constantNull()).blockReturnNoValue().ifCondition(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("value"), arrayType)).assignRef(fieldName, CodegenExpressionBuilder.cast(arrayType, (CodegenExpression)CodegenExpressionBuilder.ref("value"))).blockReturnNoValue().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.cast(EventBean[].class, (CodegenExpression)CodegenExpressionBuilder.ref("value"))).declareVar(arrayType, "array", CodegenExpressionBuilder.newArrayByLength(eventType.getUnderlyingType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events"))).assignArrayElement("array", (CodegenExpression)CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.castUnderlying(eventType.getUnderlyingType(), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.ref("i")))).blockEnd().assignRef(fieldName, (CodegenExpression)CodegenExpressionBuilder.ref("array"));
                } else {
                    throw new UnsupportedOperationException("Unrecognized type " + type);
                }
            }
            ++index;
        }
    }

    private void makeGetNativeEntry(CodegenMethod method, CodegenClassScope classScope) {
        CodegenMethod toEntry = method.makeChild(Map.Entry.class, this.getClass(), (CodegenScope)classScope).addParam(String.class, "name").addParam(Object.class, "value");
        toEntry.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(AbstractMap.SimpleEntry.class, CodegenExpressionBuilder.ref("name"), CodegenExpressionBuilder.ref("value")));
        if (this.numFieldsSupertype > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.numFieldsSupertype))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeEntry", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = this.getCasesNumberNtoM();
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        this.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.localMethod(toEntry, CodegenExpressionBuilder.constant(property.getKey()), CodegenExpressionBuilder.ref(field.getFieldName())));
            ++index;
        }
    }

    private void makeGetNativeKey(CodegenMethod method) {
        if (this.numFieldsSupertype > 0) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("num"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(this.numFieldsSupertype))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "getNativeKey", CodegenExpressionBuilder.ref("num")));
        }
        CodegenExpression[] cases = this.getCasesNumberNtoM();
        CodegenStatementSwitch switchStmt = method.getBlock().switchBlockExpressions(CodegenExpressionBuilder.ref("num"), cases, true, false);
        this.makeNoSuchElementDefault(switchStmt, CodegenExpressionBuilder.ref("num"));
        int index = 0;
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            switchStmt.getBlocks()[index].blockReturn(CodegenExpressionBuilder.constant(property.getKey()));
            ++index;
        }
    }

    private void makeNativeContainsKey(CodegenMethod method) {
        if (this.optionalSupertype != null) {
            method.getBlock().declareVar(Boolean.TYPE, "parent", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "nativeContainsKey", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.ref("parent")).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        if (this.propertiesThisType.isEmpty()) {
            method.getBlock().methodReturn(CodegenExpressionBuilder.constantFalse());
            return;
        }
        Set<String> names = this.propertiesThisType.keySet();
        Iterator<String> it = names.iterator();
        CodegenExpression or = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(it.next()));
        while (it.hasNext()) {
            or = CodegenExpressionBuilder.or(or, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(it.next())), new CodegenExpression[0]);
        }
        method.getBlock().methodReturn(or);
    }

    private CodegenExpression[] getCasesNumberNtoM() {
        CodegenExpression[] cases = new CodegenExpression[this.propertiesThisType.size()];
        int index = 0;
        for (Map.Entry<String, Object> property : this.propertiesThisType.entrySet()) {
            JsonUnderlyingField field = this.fieldDescriptorsInclSupertype.get(property.getKey());
            cases[index] = CodegenExpressionBuilder.constant(field.getPropertyNumber());
            ++index;
        }
        return cases;
    }

    private void makeNoSuchElementDefault(CodegenStatementSwitch switchStmt, CodegenExpressionRef num) {
        switchStmt.getDefaultBlock().blockThrow(CodegenExpressionBuilder.newInstance(NoSuchElementException.class, CodegenExpressionBuilder.concat(CodegenExpressionBuilder.constant("Field at number "), num)));
    }

    private boolean needDynamic() {
        return this.dynamic && !this.parentDynamic();
    }

    private boolean parentDynamic() {
        return this.optionalSupertype != null && this.optionalSupertype.getDetail().isDynamic();
    }
}

