/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.client.json.minimaljson.JsonWriter;
import com.espertech.esper.common.client.json.minimaljson.WriterConfig;
import com.espertech.esper.common.client.json.minimaljson.WritingBuffer;
import com.espertech.esper.common.client.json.util.JsonEventObject;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingEntrySet;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingKeySet;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingValueCollection;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonEventObjectBase
implements JsonEventObject {
    private static final Logger log = LoggerFactory.getLogger(JsonEventObjectBase.class);

    public abstract void addJsonValue(String var1, Object var2);

    public abstract Map<String, Object> getJsonValues();

    public abstract int getNativeSize();

    public abstract Map.Entry<String, Object> getNativeEntry(int var1);

    public abstract String getNativeKey(int var1);

    public abstract Object getNativeValue(int var1);

    public abstract int getNativeNum(String var1);

    public abstract void setNativeValue(int var1, Object var2);

    public abstract boolean nativeContainsKey(Object var1);

    public abstract void nativeWrite(JsonWriter var1) throws IOException;

    @Override
    public void writeTo(Writer writer, WriterConfig config) throws IOException {
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        this.write(config.createWriter(buffer));
        buffer.flush();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.writeObjectOpen();
        this.nativeWrite(writer);
        boolean first = this.getNativeSize() == 0;
        for (Map.Entry<String, Object> entry : this.getJsonValues().entrySet()) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeMemberName(entry.getKey());
            writer.writeMemberSeparator();
            this.writeJsonValue(writer, entry.getKey(), entry.getValue());
        }
        writer.writeObjectClose();
    }

    @Override
    public int size() {
        return this.getJsonValues().size() + this.getNativeSize();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new JsonEventUnderlyingEntrySet(this);
    }

    @Override
    public boolean isEmpty() {
        return this.getNativeSize() == 0 && this.getJsonValues().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new JsonEventUnderlyingKeySet(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nativeContainsKey(key) || this.getJsonValues().containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (key == null || !(key instanceof String)) {
            return this.getJsonValues().get(key);
        }
        int num = this.getNativeNum((String)key);
        if (num == -1) {
            return this.getJsonValues().get(key);
        }
        return this.getNativeValue(num);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.getNativeSize(); ++i) {
                if (this.getNativeValue(i) != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.getNativeSize(); ++i) {
                if (!value.equals(this.getNativeValue(i))) continue;
                return true;
            }
        }
        return this.getJsonValues().containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return new JsonEventUnderlyingValueCollection(this, this.getJsonValues().values());
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(WriterConfig config) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo(writer, config);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    @Override
    public String toString() {
        return this.toString(WriterConfig.MINIMAL);
    }

    protected void writeNullableString(JsonWriter writer, String value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeString(value);
        }
    }

    protected void writeNullableStringToString(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeString(value.toString());
        }
    }

    protected void writeNullableBoolean(JsonWriter writer, Boolean value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeLiteral(value != false ? "true" : "false");
        }
    }

    protected void writeNullableNumber(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.writeLiteral("null");
        } else {
            writer.writeNumber(value.toString());
        }
    }

    protected void writeArray2DimString(JsonWriter writer, String[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (String[] strings : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayString(writer, strings);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimCharacter(JsonWriter writer, Character[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Character[] characters : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayCharacter(writer, characters);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimLong(JsonWriter writer, Long[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Long[] longs : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayLong(writer, longs);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimInteger(JsonWriter writer, Integer[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Integer[] ints : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayInteger(writer, ints);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimShort(JsonWriter writer, Short[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Short[] shorts : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayShort(writer, shorts);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimDouble(JsonWriter writer, Double[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Double[] doubles : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayDouble(writer, doubles);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimFloat(JsonWriter writer, Float[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Float[] floats : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayFloat(writer, floats);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimByte(JsonWriter writer, Byte[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Byte[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayByte(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimBoolean(JsonWriter writer, Boolean[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Boolean[] bools : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayBoolean(writer, bools);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimBigInteger(JsonWriter writer, BigInteger[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigInteger[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayBigInteger(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimBigDecimal(JsonWriter writer, BigDecimal[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigDecimal[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayBigDecimal(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimBooleanPrimitive(JsonWriter writer, boolean[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (boolean[] b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayBooleanPrimitive(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimBytePrimitive(JsonWriter writer, byte[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (byte[] bytes : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayBytePrimitive(writer, bytes);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimShortPrimitive(JsonWriter writer, short[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (short[] shorts : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayShortPrimitive(writer, shorts);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimIntPrimitive(JsonWriter writer, int[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (int[] ints : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayIntPrimitive(writer, ints);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimLongPrimitive(JsonWriter writer, long[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (long[] longs : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayLongPrimitive(writer, longs);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimFloatPrimitive(JsonWriter writer, float[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (float[] floats : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayFloatPrimitive(writer, floats);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimDoublePrimitive(JsonWriter writer, double[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (double[] doubles : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayDoublePrimitive(writer, doubles);
        }
        writer.writeArrayClose();
    }

    protected void writeArray2DimCharPrimitive(JsonWriter writer, char[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (char[] chars : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeArrayCharPrimitive(writer, chars);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayString(JsonWriter writer, String[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (String string : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableString(writer, string);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayCharacter(JsonWriter writer, Character[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Character character : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableStringToString(writer, character);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayLong(JsonWriter writer, Long[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Long l : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, l);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayInteger(JsonWriter writer, Integer[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Integer i : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, i);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayShort(JsonWriter writer, Short[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Short s : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, s);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayDouble(JsonWriter writer, Double[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Double d : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, d);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayFloat(JsonWriter writer, Float[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Float f : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, f);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayByte(JsonWriter writer, Byte[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Byte b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayBoolean(JsonWriter writer, Boolean[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Boolean b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableBoolean(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayBigInteger(JsonWriter writer, BigInteger[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigInteger b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayBigDecimal(JsonWriter writer, BigDecimal[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (BigDecimal b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeNullableNumber(writer, b);
        }
        writer.writeArrayClose();
    }

    protected void writeArrayBooleanPrimitive(JsonWriter writer, boolean[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (boolean b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeLiteral(b ? "true" : "false");
        }
        writer.writeArrayClose();
    }

    protected void writeArrayBytePrimitive(JsonWriter writer, byte[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (byte b : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Byte.toString(b));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayShortPrimitive(JsonWriter writer, short[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (short s : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Short.toString(s));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayIntPrimitive(JsonWriter writer, int[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (int i : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Integer.toString(i));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayLongPrimitive(JsonWriter writer, long[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (long l : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Long.toString(l));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayFloatPrimitive(JsonWriter writer, float[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (float f : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Float.toString(f));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayDoublePrimitive(JsonWriter writer, double[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (double d : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeNumber(Double.toString(d));
        }
        writer.writeArrayClose();
    }

    protected void writeArrayCharPrimitive(JsonWriter writer, char[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (char c : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeString(Character.toString(c));
        }
        writer.writeArrayClose();
    }

    protected void writeEnumArray(JsonWriter writer, Object[] array) throws IOException {
        this.writeObjectArrayWToString(writer, array);
    }

    protected void writeEnumArray2Dim(JsonWriter writer, Object[][] array) throws IOException {
        this.writeObjectArray2DimWToString(writer, array);
    }

    protected void writeJsonValue(JsonWriter writer, String name, Object jsonValue) throws IOException {
        if (jsonValue == null) {
            writer.writeLiteral("null");
        } else if (jsonValue instanceof Boolean) {
            writer.writeLiteral((Boolean)jsonValue != false ? "true" : "false");
        } else if (jsonValue instanceof String) {
            writer.writeString((String)jsonValue);
        } else if (jsonValue instanceof Number) {
            writer.writeNumber(jsonValue.toString());
        } else if (jsonValue instanceof Object[]) {
            this.writeJsonArray(writer, name, (Object[])jsonValue);
        } else if (jsonValue instanceof Map) {
            this.writeJsonMap(writer, (Map)jsonValue);
        } else if (jsonValue instanceof JsonEventObjectBase) {
            writer.writeObjectOpen();
            JsonEventObjectBase und = (JsonEventObjectBase)jsonValue;
            und.write(writer);
            writer.writeObjectClose();
        } else {
            log.warn("Unknown json value of type " + jsonValue.getClass() + " encountered, skipping member '" + name + "'");
        }
    }

    protected void writeJsonMap(JsonWriter writer, Map<String, Object> map) throws IOException {
        if (map == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeObjectOpen();
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            writer.writeMemberName(entry.getKey());
            writer.writeMemberSeparator();
            this.writeJsonValue(writer, entry.getKey(), entry.getValue());
        }
        writer.writeObjectClose();
    }

    protected void writeJsonArray(JsonWriter writer, String name, Object[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object item : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeJsonValue(writer, name, item);
        }
        writer.writeArrayClose();
    }

    protected static void writeNested(JsonWriter writer, JsonEventObjectBase nested) throws IOException {
        if (nested == null) {
            writer.writeLiteral("null");
            return;
        }
        nested.write(writer);
    }

    protected static void writeNestedArray(JsonWriter writer, JsonEventObjectBase[] nesteds) throws IOException {
        if (nesteds == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (JsonEventObjectBase nested : nesteds) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            nested.write(writer);
        }
        writer.writeArrayClose();
    }

    private void writeObjectArrayWToString(JsonWriter writer, Object[] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object object : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            if (object == null) {
                writer.writeLiteral("null");
                continue;
            }
            writer.writeString(object.toString());
        }
        writer.writeArrayClose();
    }

    private void writeObjectArray2DimWToString(JsonWriter writer, Object[][] array) throws IOException {
        if (array == null) {
            writer.writeLiteral("null");
            return;
        }
        writer.writeArrayOpen();
        boolean first = true;
        for (Object[] objects : array) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            first = false;
            this.writeObjectArrayWToString(writer, objects);
        }
        writer.writeArrayClose();
    }
}

