/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingKeySetIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class JsonEventUnderlyingKeySet
implements Set<String> {
    private final JsonEventObjectBase jeu;
    private final Set<String> keySet;

    public JsonEventUnderlyingKeySet(JsonEventObjectBase jsonEventUnderlyingBase) {
        this.jeu = jsonEventUnderlyingBase;
        this.keySet = this.jeu.getJsonValues().keySet();
    }

    @Override
    public int size() {
        return this.jeu.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jeu.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return new JsonEventUnderlyingKeySetIterator(this.jeu, this.keySet);
    }

    @Override
    public boolean contains(Object value) {
        return this.jeu.containsKey(value);
    }

    @Override
    public Object[] toArray() {
        if (this.jeu.getNativeSize() == 0) {
            return this.keySet.toArray();
        }
        Object[] result = new String[this.size()];
        this.fillArray((String[])result);
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.jeu.getNativeSize() == 0) {
            return this.keySet.containsAll(c);
        }
        for (Object key : c) {
            if (this.contains(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int nativeSize = this.jeu.getNativeSize();
        if (nativeSize == 0) {
            return this.keySet.toArray(a);
        }
        String[] array = (String[])a;
        int size = this.size();
        if (a.length >= size) {
            this.fillArray(array);
            return a;
        }
        String[] result = new String[this.size()];
        this.fillArray(result);
        return result;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super String> filter) {
        throw new UnsupportedOperationException();
    }

    private void fillArray(String[] array) {
        int size = this.jeu.getNativeSize();
        for (int i = 0; i < size; ++i) {
            array[i] = this.jeu.getNativeKey(i);
        }
        Iterator<String> it = this.keySet.iterator();
        while (it.hasNext()) {
            array[size++] = it.next();
        }
    }
}

