/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.getter.JsonEventPropertyGetter;
import com.espertech.esper.common.internal.event.json.getter.JsonFieldGetterHelper;
import com.espertech.esper.common.internal.util.CollectionUtil;

public final class JsonGetterIndexed
implements JsonEventPropertyGetter {
    private final JsonUnderlyingField field;
    private final int index;
    private final String underlyingClassName;
    private final EventType optionalInnerType;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

    public JsonGetterIndexed(JsonUnderlyingField field, int index, String underlyingClassName, EventType optionalInnerType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.field = field;
        this.index = index;
        this.underlyingClassName = underlyingClassName;
        this.optionalInnerType = optionalInnerType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "arrayValueAtIndex", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getFieldName()), CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "arrayExistsAtIndex", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getFieldName()), CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.optionalInnerType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField eventType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(this.optionalInnerType, EPStatementInitServices.REF));
        return CodegenExpressionBuilder.staticMethod(JsonFieldGetterHelper.class, "handleJsonCreateFragmentIndexed", underlyingExpression, CodegenExpressionBuilder.constant(this.field.getPropertyNumber()), CodegenExpressionBuilder.constant(this.index), eventType, factory);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return this.getJsonExists(eventBean.getUnderlying());
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonFragment(eventBean.getUnderlying());
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonProp(eventBean.getUnderlying());
    }

    @Override
    public Object getJsonProp(Object object) throws PropertyAccessException {
        return JsonFieldGetterHelper.getJsonIndexedProp(object, this.field.getPropertyNumber(), this.index);
    }

    @Override
    public boolean getJsonExists(Object object) throws PropertyAccessException {
        return JsonFieldGetterHelper.getJsonIndexedPropExists(object, this.field, this.index);
    }

    @Override
    public Object getJsonFragment(Object object) throws PropertyAccessException {
        if (this.optionalInnerType == null) {
            return null;
        }
        Object value = JsonFieldGetterHelper.getJsonIndexedProp(object, this.field.getPropertyNumber(), this.index);
        if (value == null) {
            return null;
        }
        return this.eventBeanTypedEventFactory.adapterForTypedJson(value, this.optionalInnerType);
    }
}

