/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.getter.JsonEventPropertyGetter;
import com.espertech.esper.common.internal.event.json.getter.JsonFieldGetterHelper;
import com.espertech.esper.common.internal.util.CollectionUtil;

public final class JsonGetterMapped
implements JsonEventPropertyGetter {
    private final JsonUnderlyingField field;
    private final String key;
    private final String underlyingClassName;

    public JsonGetterMapped(JsonUnderlyingField field, String key, String underlyingClassName) {
        this.field = field;
        this.key = key;
        this.underlyingClassName = underlyingClassName;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "mapValueForKey", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getFieldName()), CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "mapExistsForKey", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getFieldName()), CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return this.getJsonExists(eventBean.getUnderlying());
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonProp(eventBean.getUnderlying());
    }

    @Override
    public Object getJsonProp(Object object) throws PropertyAccessException {
        return JsonFieldGetterHelper.getJsonMappedProp(object, this.field.getPropertyNumber(), this.key);
    }

    @Override
    public Object getJsonFragment(Object object) throws PropertyAccessException {
        return null;
    }

    @Override
    public boolean getJsonExists(Object object) throws PropertyAccessException {
        return JsonFieldGetterHelper.getJsonMappedExists(object, this.field.getPropertyNumber(), this.key);
    }
}

