/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.getter.JsonEventPropertyGetter;
import com.espertech.esper.common.internal.event.json.getter.JsonFieldGetterHelper;

public final class JsonGetterNested
implements JsonEventPropertyGetter {
    private final JsonUnderlyingField field;
    private final JsonEventPropertyGetter innerGetter;
    private final String underlyingClassName;

    public JsonGetterNested(JsonUnderlyingField field, JsonEventPropertyGetter innerGetter, String underlyingClassName) {
        this.field = field;
        this.innerGetter = innerGetter;
        this.underlyingClassName = underlyingClassName;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonProp(eventBean.getUnderlying());
    }

    @Override
    public Object getJsonProp(Object object) throws PropertyAccessException {
        Object value = JsonFieldGetterHelper.getJsonSimpleProp(this.field, object);
        if (value == null) {
            return null;
        }
        return this.innerGetter.getJsonProp(value);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method = codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(this.underlyingClassName, "und");
        method.getBlock().declareVar(this.field.getPropertyType(), "inner", (CodegenExpression)CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("und"), this.field.getFieldName())).ifRefNullReturnNull("inner").methodReturn(this.innerGetter.underlyingGetCodegen(CodegenExpressionBuilder.ref("inner"), method, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method = codegenMethodScope.makeChild(Boolean.TYPE, this.getClass(), (CodegenScope)codegenClassScope).addParam(this.underlyingClassName, "und");
        method.getBlock().declareVar(this.field.getPropertyType(), "inner", (CodegenExpression)CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("und"), this.field.getFieldName())).ifRefNull("inner").blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(this.innerGetter.underlyingExistsCodegen(CodegenExpressionBuilder.ref("inner"), method, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethod method = codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(this.underlyingClassName, "und");
        method.getBlock().declareVar(this.field.getPropertyType(), "inner", (CodegenExpression)CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("und"), this.field.getFieldName())).ifRefNull("inner").blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(this.innerGetter.underlyingFragmentCodegen(CodegenExpressionBuilder.ref("inner"), method, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return this.getJsonExists(eventBean.getUnderlying());
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonFragment(eventBean.getUnderlying());
    }

    @Override
    public boolean getJsonExists(Object object) throws PropertyAccessException {
        Object value = JsonFieldGetterHelper.getJsonSimpleProp(this.field, object);
        if (value == null) {
            return false;
        }
        return this.innerGetter.getJsonExists(value);
    }

    @Override
    public Object getJsonFragment(Object object) throws PropertyAccessException {
        Object value = JsonFieldGetterHelper.getJsonSimpleProp(this.field, object);
        if (value == null) {
            return null;
        }
        return this.innerGetter.getJsonFragment(value);
    }
}

