/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.getter.JsonEventPropertyGetter;

public abstract class JsonGetterSimpleBase
implements JsonEventPropertyGetter {
    protected final JsonUnderlyingField field;
    protected final String underlyingClassName;
    protected final EventType fragmentType;
    protected final EventBeanTypedEventFactory eventBeanTypedEventFactory;

    public JsonGetterSimpleBase(JsonUnderlyingField field, String underlyingClassName, EventType fragmentType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.field = field;
        this.underlyingClassName = underlyingClassName;
        this.fragmentType = fragmentType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonProp(eventBean.getUnderlying());
    }

    @Override
    public Object getJsonProp(Object object) throws PropertyAccessException {
        return ((JsonEventObjectBase)object).getNativeValue(this.field.getPropertyNumber());
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.underlyingClassName, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getFieldName());
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonFragment(eventBean.getUnderlying());
    }

    @Override
    public boolean getJsonExists(Object object) throws PropertyAccessException {
        return true;
    }
}

