/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.core;

import com.espertech.esper.common.internal.event.json.parser.core.JsonHandlerDelegator;
import com.espertech.esper.common.internal.event.json.parser.core.JsonValueType;
import java.util.Map;

public abstract class JsonDelegateBase {
    protected final JsonHandlerDelegator baseHandler;
    protected final JsonDelegateBase parent;
    protected String stringValue;
    protected JsonValueType valueType;
    protected Object objectValue;

    public abstract JsonDelegateBase startObject(String var1);

    public abstract JsonDelegateBase startArray(String var1);

    public abstract boolean endObjectValue(String var1);

    public void endArrayValue(String name) {
    }

    public abstract Object getResult();

    public JsonDelegateBase(JsonHandlerDelegator baseHandler, JsonDelegateBase parent) {
        this.baseHandler = baseHandler;
        this.parent = parent;
    }

    public void endString(String string) {
        this.stringValue = string;
        this.valueType = JsonValueType.STRING;
    }

    public void endNumber(String string) {
        this.stringValue = string;
        this.valueType = JsonValueType.NUMBER;
    }

    public void endNull() {
        this.valueType = JsonValueType.NULL;
        this.stringValue = null;
        this.objectValue = null;
    }

    public void endBoolean(boolean value) {
        this.valueType = JsonValueType.BOOLEAN;
        if (value) {
            this.objectValue = Boolean.TRUE;
            this.stringValue = "true";
        } else {
            this.objectValue = Boolean.FALSE;
            this.stringValue = "false";
        }
    }

    public void setObjectValue(Object object) {
        this.objectValue = object;
    }

    public JsonDelegateBase getParent() {
        return this.parent;
    }

    public void addGeneralJson(Map<String, Object> event, String name) {
        event.put(name, this.valueToObject());
    }

    protected Object valueToObject() {
        if (this.valueType == JsonValueType.STRING) {
            return this.stringValue;
        }
        if (this.valueType == JsonValueType.NUMBER) {
            return JsonDelegateBase.jsonNumberFromString(this.stringValue);
        }
        if (this.valueType == JsonValueType.NULL) {
            return null;
        }
        return this.objectValue;
    }

    public static Object jsonNumberFromString(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            return Double.parseDouble(text);
        }
    }
}

