/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.writer;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class JsonEventBeanCopyMethod
implements EventBeanCopyMethod {
    private final JsonEventType eventType;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final int[] regularFieldsCopy;
    private final int[] mapIndexesToCopy;
    private final int[] arrayIndexesToCopy;

    public JsonEventBeanCopyMethod(JsonEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, int[] regularFieldsCopy, int[] mapIndexesToCopy, int[] arrayIndexesToCopy) {
        this.eventType = eventType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.regularFieldsCopy = regularFieldsCopy;
        this.mapIndexesToCopy = mapIndexesToCopy;
        this.arrayIndexesToCopy = arrayIndexesToCopy;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        JsonEventObjectBase copy;
        JsonEventObjectBase source = (JsonEventObjectBase)theEvent.getUnderlying();
        try {
            copy = (JsonEventObjectBase)this.eventType.getUnderlyingType().newInstance();
        }
        catch (Exception ex) {
            throw new EPException("Failed to instantiate Json event: " + ex.getMessage(), ex);
        }
        for (int index : this.regularFieldsCopy) {
            copy.setNativeValue(index, source.getNativeValue(index));
        }
        for (int index : this.mapIndexesToCopy) {
            Map innerMap = (Map)source.getNativeValue(index);
            if (innerMap == null) continue;
            HashMap copyMap = new HashMap(innerMap);
            copy.setNativeValue(index, copyMap);
        }
        for (int index : this.arrayIndexesToCopy) {
            Object array = source.getNativeValue(index);
            if (array == null || !array.getClass().isArray() || Array.getLength(array) == 0) continue;
            Object copied = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
            System.arraycopy(array, 0, copied, 0, Array.getLength(array));
            copy.setNativeValue(index, copied);
        }
        if (source.getJsonValues().isEmpty()) {
            Object object = source.getJsonValues().entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                copy.addJsonValue((String)entry.getKey(), entry.getValue());
            }
        }
        return this.eventBeanTypedEventFactory.adapterForTypedJson(copy, this.eventType);
    }
}

