/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.writer;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.writer.JsonEventBeanCopyMethod;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import java.util.HashSet;
import java.util.Set;

public class JsonEventBeanCopyMethodForge
implements EventBeanCopyMethodForge {
    private final JsonEventType eventType;
    private final int[] regularIndexes;
    private final int[] mapIndexes;
    private final int[] arrayIndexes;

    public JsonEventBeanCopyMethodForge(JsonEventType eventType, Set<String> mapPropertiesToCopy, Set<String> arrayPropertiesToCopy) {
        this.eventType = eventType;
        HashSet<Integer> mapIndexesToCopy = new HashSet<Integer>();
        for (String string : mapPropertiesToCopy) {
            JsonUnderlyingField field = eventType.getDetail().getFieldDescriptors().get(string);
            mapIndexesToCopy.add(field.getPropertyNumber());
        }
        HashSet<Integer> arrayIndexesToCopy = new HashSet<Integer>();
        for (String prop : arrayPropertiesToCopy) {
            JsonUnderlyingField field = eventType.getDetail().getFieldDescriptors().get(prop);
            arrayIndexesToCopy.add(field.getPropertyNumber());
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String prop : eventType.getTypes().keySet()) {
            if (mapPropertiesToCopy.contains(prop) || arrayPropertiesToCopy.contains(prop)) continue;
            JsonUnderlyingField field = eventType.getDetail().getFieldDescriptors().get(prop);
            hashSet.add(field.getPropertyNumber());
        }
        this.mapIndexes = IntArrayUtil.toArray(mapIndexesToCopy);
        this.arrayIndexes = IntArrayUtil.toArray(arrayIndexesToCopy);
        this.regularIndexes = IntArrayUtil.toArray(hashSet);
    }

    @Override
    public CodegenExpression makeCopyMethodClassScoped(CodegenClassScope classScope) {
        CodegenExpressionField factory = classScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        return CodegenExpressionBuilder.newInstance(JsonEventBeanCopyMethod.class, CodegenExpressionBuilder.cast(JsonEventType.class, EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF)), factory, CodegenExpressionBuilder.constant(this.regularIndexes), CodegenExpressionBuilder.constant(this.mapIndexes), CodegenExpressionBuilder.constant(this.arrayIndexes));
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        return new JsonEventBeanCopyMethod(this.eventType, eventBeanTypedEventFactory, this.regularIndexes, this.mapIndexes, this.arrayIndexes);
    }
}

